/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.ui;

import com.google.gson.annotations.SerializedName;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import lombok.NonNull;

public class BrowserDescriptor
implements Serializable {
    private static final long serialVersionUID = 3745812401643512530L;
    @SerializedName(value="browser_package_name")
    private String mPackageName;
    @SerializedName(value="browser_signature_hashes")
    private Set<String> mSignatureHashes;
    @SerializedName(value="browser_version_lower_bound")
    private String mVersionLowerBound;
    @SerializedName(value="browser_version_upper_bound")
    private String mVersionUpperBound;

    public BrowserDescriptor(@NonNull String packageName, @NonNull Set<String> signatureHashes, @Nullable String versionLowerBound, @Nullable String versionUpperBound) {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked non-null but is null");
        }
        if (signatureHashes == null) {
            throw new NullPointerException("signatureHashes is marked non-null but is null");
        }
        this.mPackageName = packageName;
        this.mSignatureHashes = signatureHashes;
        this.mVersionLowerBound = versionLowerBound;
        this.mVersionUpperBound = versionUpperBound;
    }

    public BrowserDescriptor(@NonNull String packageName, @NonNull String signatureHash, @Nullable String versionLowerBound, @Nullable String versionUpperBound) {
        if (packageName == null) {
            throw new NullPointerException("packageName is marked non-null but is null");
        }
        if (signatureHash == null) {
            throw new NullPointerException("signatureHash is marked non-null but is null");
        }
        this.mPackageName = packageName;
        this.mSignatureHashes = Collections.singleton(signatureHash);
        this.mVersionLowerBound = versionLowerBound;
        this.mVersionUpperBound = versionUpperBound;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public Set<String> getSignatureHashes() {
        return this.mSignatureHashes;
    }

    public String getVersionLowerBound() {
        return this.mVersionLowerBound;
    }

    public String getVersionUpperBound() {
        return this.mVersionUpperBound;
    }
}

