/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.util.IClockSkewManager;
import java.util.Calendar;
import java.util.Date;
import lombok.NonNull;

public class ClockSkewManager
implements IClockSkewManager {
    private final INameValueStorage<Long> mClockSkewStorage;

    public ClockSkewManager(@NonNull INameValueStorage<Long> storage) {
        if (storage == null) {
            throw new NullPointerException("storage is marked non-null but is null");
        }
        this.mClockSkewStorage = storage;
    }

    @Override
    public void onTimestampReceived(long referenceTime) {
        long clientTime = this.getCurrentClientTime().getTime();
        long skewMillis = clientTime - referenceTime;
        this.mClockSkewStorage.put("skew", skewMillis);
    }

    @Override
    public long getSkewMillis() {
        return this.mClockSkewStorage.get("skew");
    }

    @Override
    public Date toClientTime(long referenceTime) {
        return new Date(referenceTime + this.getSkewMillis());
    }

    @Override
    public Date toReferenceTime(long clientTime) {
        return new Date(clientTime - this.getSkewMillis());
    }

    @Override
    public Date getCurrentClientTime() {
        return Calendar.getInstance().getTime();
    }

    @Override
    public Date getAdjustedReferenceTime() {
        return this.toReferenceTime(this.getCurrentClientTime().getTime());
    }

    private static final class PreferencesMetadata {
        private static final String KEY_SKEW = "skew";

        private PreferencesMetadata() {
        }
    }
}

