/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import lombok.NonNull;

public class UrlUtil {
    private static final String TAG = UrlUtil.class.getSimpleName();

    public static URL appendPathToURL(@NonNull URL urlToAppend, @Nullable String pathString) throws URISyntaxException, MalformedURLException {
        if (urlToAppend == null) {
            throw new NullPointerException("urlToAppend is marked non-null but is null");
        }
        return UrlUtil.appendPathAndQueryToURL(urlToAppend, pathString, null);
    }

    public static URL appendPathAndQueryToURL(@NonNull URL urlToAppend, @Nullable String pathString, @Nullable String queryParam) throws URISyntaxException, MalformedURLException {
        int lastIndex;
        if (urlToAppend == null) {
            throw new NullPointerException("urlToAppend is marked non-null but is null");
        }
        if (StringUtil.isNullOrEmpty(pathString)) {
            return urlToAppend;
        }
        CommonURIBuilder pathBuilder = new CommonURIBuilder();
        pathBuilder.setPath(pathString);
        List pathSegmentsToAppend = pathBuilder.getPathSegments();
        CommonURIBuilder builder = new CommonURIBuilder(urlToAppend.toString());
        ArrayList<String> pathSegments = new ArrayList<String>(builder.getPathSegments());
        if (pathSegments.size() > 0 && ((String)pathSegments.get(lastIndex = pathSegments.size() - 1)).equals("") && !pathBuilder.isPathEmpty()) {
            pathSegments.remove(lastIndex);
        }
        for (String path : pathSegmentsToAppend) {
            if (StringUtil.isNullOrEmpty(path)) continue;
            pathSegments.add(path);
        }
        builder.setPathSegments(pathSegments);
        if (queryParam != null && !queryParam.isEmpty()) {
            builder.setQuery(queryParam);
        }
        return builder.build().toURL();
    }

    @NonNull
    public static Map<String, String> getParameters(@Nullable String urlString) throws ClientException {
        if (StringUtil.isNullOrEmpty(urlString)) {
            Logger.warn(TAG, "url string is null.");
            return Collections.emptyMap();
        }
        try {
            return UrlUtil.getParameters(new URI(urlString));
        }
        catch (URISyntaxException e) {
            throw new ClientException("malformed_url", "Cannot extract parameter from a malformed URL string.", e);
        }
    }

    @NonNull
    public static Map<String, String> getParameters(@Nullable URI uri) {
        String methodName = ":getUrlParameters";
        if (uri == null) {
            Logger.warn(TAG, "uri is null.");
            return Collections.emptyMap();
        }
        if (uri.isOpaque()) {
            try {
                return UrlUtil.getParameters(new URI("scheme://" + uri.toString()));
            }
            catch (URISyntaxException e) {
                Logger.warn(TAG, "Cannot convert opaque URI.");
                return Collections.emptyMap();
            }
        }
        String fragment = uri.getFragment();
        if (!StringUtil.isNullOrEmpty(fragment) && !UrlUtil.urlFormDecode(fragment).isEmpty()) {
            Logger.warn(TAG, "Received url contains unexpected fragment parameters.");
            Logger.warnPII(TAG, "Unexpected fragment: " + uri.getFragment());
        }
        if (StringUtil.isNullOrEmpty(uri.getQuery())) {
            Logger.info(TAG + ":getUrlParameters", "URL does not contain query parameter");
            return Collections.emptyMap();
        }
        return UrlUtil.urlFormDecode(uri.getRawQuery());
    }

    @NonNull
    public static Map<String, String> urlFormDecode(@NonNull String urlParameter) {
        if (urlParameter == null) {
            throw new NullPointerException("urlParameter is marked non-null but is null");
        }
        return UrlUtil.urlFormDecodeData(urlParameter, "&");
    }

    @NonNull
    static Map<String, String> urlFormDecodeData(@NonNull String urlParameter, @NonNull String delimiter) {
        if (urlParameter == null) {
            throw new NullPointerException("urlParameter is marked non-null but is null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        String methodName = ":urlFormDecodeData";
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtil.isNullOrEmpty(urlParameter)) {
            StringTokenizer parameterTokenizer = new StringTokenizer(urlParameter, delimiter);
            while (parameterTokenizer.hasMoreTokens()) {
                String key;
                String value;
                block10: {
                    String pair = parameterTokenizer.nextToken();
                    String[] elements = pair.split("=", 2);
                    value = null;
                    key = null;
                    if (elements.length == 2) {
                        try {
                            key = StringUtil.urlFormDecode(elements[0].trim());
                            value = StringUtil.urlFormDecode(elements[1].trim());
                            break block10;
                        }
                        catch (UnsupportedEncodingException e) {
                            Logger.errorPII(TAG + ":urlFormDecodeData", "Encoding format is not supported", e);
                            continue;
                        }
                    }
                    if (elements.length == 1) {
                        try {
                            key = StringUtil.urlFormDecode(elements[0].trim());
                            value = "";
                        }
                        catch (UnsupportedEncodingException e) {
                            Logger.errorPII(TAG + ":urlFormDecodeData", "Encoding format is not supported", e);
                            continue;
                        }
                    }
                }
                if (StringUtil.isNullOrEmpty(key)) continue;
                result.put(key, value);
            }
        }
        return result;
    }

    public static URL makeUrlSilent(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeTrailingSlash(@NonNull String urlString) {
        if (urlString == null) {
            throw new NullPointerException("urlString is marked non-null but is null");
        }
        return urlString.replaceFirst("/*$", "");
    }
}

