/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.cache.AccountDeletionRecord;
import com.microsoft.identity.common.java.cache.BrokerApplicationMetadata;
import com.microsoft.identity.common.java.cache.CacheKeyValueDelegate;
import com.microsoft.identity.common.java.cache.CacheRecord;
import com.microsoft.identity.common.java.cache.IBrokerApplicationMetadataCache;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.MicrosoftFamilyOAuth2TokenCache;
import com.microsoft.identity.common.java.cache.MicrosoftStsAccountCredentialAdapter;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.cache.SharedPreferencesAccountCredentialCache;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class BrokerOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends MicrosoftTokenResponse, GenericAccount extends MicrosoftAccount, GenericRefreshToken extends MicrosoftRefreshToken>
extends OAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse> {
    private static final String TAG = BrokerOAuth2TokenCache.class.getSimpleName();
    private static final String UNCHECKED = "unchecked";
    private final IBrokerApplicationMetadataCache mApplicationMetadataCache;
    private final MicrosoftFamilyOAuth2TokenCache mFociCache;
    private final int mUid;
    private ProcessUidCacheFactory mDelegate = null;

    public BrokerOAuth2TokenCache(@NonNull IPlatformComponents components, int uid, @NonNull IBrokerApplicationMetadataCache applicationMetadataCache) {
        super(components);
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        if (applicationMetadataCache == null) {
            throw new NullPointerException("applicationMetadataCache is marked non-null but is null");
        }
        Logger.verbose(TAG + "ctor", "Init::" + TAG);
        this.mUid = uid;
        this.mFociCache = BrokerOAuth2TokenCache.initializeFociCache(this.getComponents());
        this.mApplicationMetadataCache = applicationMetadataCache;
    }

    public BrokerOAuth2TokenCache(@NonNull IPlatformComponents components, int uid, @NonNull IBrokerApplicationMetadataCache applicationMetadataCache, @NonNull ProcessUidCacheFactory delegate, @NonNull MicrosoftFamilyOAuth2TokenCache fociCache) {
        super(components);
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        if (applicationMetadataCache == null) {
            throw new NullPointerException("applicationMetadataCache is marked non-null but is null");
        }
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (fociCache == null) {
            throw new NullPointerException("fociCache is marked non-null but is null");
        }
        Logger.verbose(TAG + "ctor", "Init::" + TAG);
        this.mApplicationMetadataCache = applicationMetadataCache;
        this.mUid = uid;
        this.mDelegate = delegate;
        this.mFociCache = fociCache;
    }

    @Deprecated
    public ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable String familyId) throws ClientException {
        ICacheRecord result;
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        if (accessTokenRecord == null) {
            throw new NullPointerException("accessTokenRecord is marked non-null but is null");
        }
        String methodName = ":save (4 args)";
        boolean isFoci = !StringUtil.isNullOrEmpty(familyId);
        Logger.info(TAG + ":save (4 args)", "Saving to FOCI cache? [" + isFoci + "]");
        if (isFoci) {
            result = this.mFociCache.save(accountRecord, idTokenRecord, accessTokenRecord);
        } else {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(idTokenRecord.getClientId(), idTokenRecord.getEnvironment(), this.mUid);
            if (null == targetCache) {
                Logger.warn(TAG + ":save (4 args)", "Existing cache not found. A new one will be created.");
                targetCache = this.initializeProcessUidCache(this.getComponents(), this.mUid);
            }
            result = targetCache.save(accountRecord, idTokenRecord, accessTokenRecord);
        }
        this.updateApplicationMetadataCache(result.getAccessToken().getClientId(), result.getAccessToken().getEnvironment(), familyId, this.mUid);
        return result;
    }

    public ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable RefreshTokenRecord refreshTokenRecord, @Nullable String familyId) throws ClientException {
        ICacheRecord result;
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        if (accessTokenRecord == null) {
            throw new NullPointerException("accessTokenRecord is marked non-null but is null");
        }
        String methodName = ":save (5 args)";
        boolean isFoci = !StringUtil.isNullOrEmpty(familyId);
        Logger.info(TAG + ":save (5 args)", "Saving to FOCI cache? [" + isFoci + "]");
        if (isFoci) {
            result = this.mFociCache.save(accountRecord, idTokenRecord, accessTokenRecord, refreshTokenRecord);
        } else {
            MsalOAuth2TokenCache targetCache = this.initializeProcessUidCache(this.getComponents(), this.mUid);
            result = targetCache.save(accountRecord, idTokenRecord, accessTokenRecord, refreshTokenRecord);
        }
        this.updateApplicationMetadataCache(result.getAccessToken().getClientId(), result.getAccessToken().getEnvironment(), familyId, this.mUid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable String familyId, @NonNull AbstractAuthenticationScheme authScheme) throws ClientException {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        if (accessTokenRecord == null) {
            throw new NullPointerException("accessTokenRecord is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        BrokerOAuth2TokenCache brokerOAuth2TokenCache = this;
        synchronized (brokerOAuth2TokenCache) {
            ICacheRecord cacheRecord = this.save(accountRecord, idTokenRecord, accessTokenRecord, familyId);
            return this.loadAggregatedAccountData(authScheme, cacheRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable RefreshTokenRecord refreshTokenRecord, @Nullable String familyId, @NonNull AbstractAuthenticationScheme authScheme) throws ClientException {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        if (accessTokenRecord == null) {
            throw new NullPointerException("accessTokenRecord is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        BrokerOAuth2TokenCache brokerOAuth2TokenCache = this;
        synchronized (brokerOAuth2TokenCache) {
            ICacheRecord cacheRecord = this.save(accountRecord, idTokenRecord, accessTokenRecord, refreshTokenRecord, familyId);
            return this.loadAggregatedAccountData(authScheme, cacheRecord);
        }
    }

    private List<ICacheRecord> loadAggregatedAccountData(@NonNull AbstractAuthenticationScheme authScheme, @NonNull ICacheRecord cacheRecord) {
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        String methodName = ":loadAggregatedAccountData";
        String clientId = cacheRecord.getAccessToken().getClientId();
        String target = cacheRecord.getAccessToken().getTarget();
        String environment = cacheRecord.getAccessToken().getEnvironment();
        String applicationIdentifier = cacheRecord.getAccessToken().getApplicationIdentifier();
        String mamEnrollmentIdentifier = cacheRecord.getAccessToken().getMamEnrollmentIdentifier();
        MsalOAuth2TokenCache cache = this.getTokenCacheForClient(clientId, environment, this.mUid);
        if (cache == null) {
            Logger.warn(TAG + ":loadAggregatedAccountData", "Cache not found for clientid: " + clientId + "environment:" + environment + "processUid: " + this.mUid);
            return null;
        }
        return cache.loadWithAggregatedAccountData(clientId, applicationIdentifier, mamEnrollmentIdentifier, target, cacheRecord.getAccount(), authScheme);
    }

    @Override
    public ICacheRecord save(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        boolean isFoci;
        if (oAuth2Strategy == null) {
            throw new NullPointerException("oAuth2Strategy is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String methodName = ":save";
        boolean bl = isFoci = !StringUtil.isNullOrEmpty(((MicrosoftTokenResponse)response).getFamilyId());
        if (isFoci) {
            Logger.verbose(TAG + ":save", "Received FOCI value: [" + ((MicrosoftTokenResponse)response).getFamilyId() + "]");
        }
        Logger.info(TAG + ":save", "Saving to FOCI cache? [" + isFoci + "]");
        MsalOAuth2TokenCache targetCache = isFoci ? this.mFociCache : this.initializeProcessUidCache(this.getComponents(), this.mUid);
        ICacheRecord result = ((OAuth2TokenCache)targetCache).save(oAuth2Strategy, request, response);
        this.updateApplicationMetadataCache(result.getRefreshToken().getClientId(), result.getRefreshToken().getEnvironment(), result.getRefreshToken().getFamilyId(), this.mUid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        if (oAuth2Strategy == null) {
            throw new NullPointerException("oAuth2Strategy is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        BrokerOAuth2TokenCache brokerOAuth2TokenCache = this;
        synchronized (brokerOAuth2TokenCache) {
            String methodName = ":saveAndLoadAggregatedAccountData";
            boolean isFoci = !StringUtil.isNullOrEmpty(((MicrosoftTokenResponse)response).getFamilyId());
            Logger.info(TAG + ":saveAndLoadAggregatedAccountData", "Saving to FOCI cache? [" + isFoci + "]");
            MsalOAuth2TokenCache targetCache = isFoci ? this.mFociCache : this.initializeProcessUidCache(this.getComponents(), this.mUid);
            List<ICacheRecord> result = ((OAuth2TokenCache)targetCache).saveAndLoadAggregatedAccountData(oAuth2Strategy, request, response);
            ICacheRecord justSavedRecord = result.get(0);
            this.updateApplicationMetadataCache(justSavedRecord.getRefreshToken().getClientId(), justSavedRecord.getRefreshToken().getEnvironment(), justSavedRecord.getRefreshToken().getFamilyId(), this.mUid);
            return result;
        }
    }

    private void updateApplicationMetadataCache(@NonNull String clientId, @NonNull String environment, @Nullable String familyId, int uid) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        String methodName = ":updateApplicationMetadataCache";
        BrokerApplicationMetadata applicationMetadata = new BrokerApplicationMetadata();
        applicationMetadata.setClientId(clientId);
        applicationMetadata.setEnvironment(environment);
        applicationMetadata.setFoci(familyId);
        applicationMetadata.setUid(uid);
        Logger.verbose(TAG + ":updateApplicationMetadataCache", "Adding cache entry for clientId: [" + clientId + "]");
        boolean success = this.mApplicationMetadataCache.insert(applicationMetadata);
        Logger.info(TAG + ":updateApplicationMetadataCache", "Cache updated successfully? [" + success + "]");
    }

    @Override
    public ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord) {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    @Override
    public ICacheRecord load(@NonNull String clientId, @NonNull String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String target, @NonNull AccountRecord account, @NonNull AbstractAuthenticationScheme authScheme) {
        MsalOAuth2TokenCache targetCache;
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (applicationIdentifier == null) {
            throw new NullPointerException("applicationIdentifier is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        String methodName = ":load";
        Logger.verbose(TAG + ":load", "Performing lookup in app-specific cache.");
        BrokerApplicationMetadata appMetadata = this.mApplicationMetadataCache.getMetadata(clientId, account.getEnvironment(), this.mUid);
        boolean isKnownFoci = false;
        if (null != appMetadata) {
            isKnownFoci = null != appMetadata.getFoci();
            Logger.info(TAG + ":load", "App is known foci? " + isKnownFoci);
        }
        boolean shouldUseFociCache = null == (targetCache = this.getTokenCacheForClient(clientId, account.getEnvironment(), this.mUid)) || isKnownFoci;
        Logger.info(TAG + ":load", "Loading from FOCI cache? [" + shouldUseFociCache + "]");
        ICacheRecord resultRecord = shouldUseFociCache ? this.mFociCache.loadByFamilyId(clientId, target, account, authScheme) : ((OAuth2TokenCache)targetCache).load(clientId, applicationIdentifier, mamEnrollmentIdentifier, target, account, authScheme);
        boolean resultFound = null != resultRecord.getRefreshToken();
        Logger.verbose(TAG + ":load", "Result found? [" + resultFound + "]");
        return resultRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> loadWithAggregatedAccountData(@NonNull String clientId, @NonNull String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String target, @NonNull AccountRecord account, @NonNull AbstractAuthenticationScheme authScheme) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (applicationIdentifier == null) {
            throw new NullPointerException("applicationIdentifier is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        BrokerOAuth2TokenCache brokerOAuth2TokenCache = this;
        synchronized (brokerOAuth2TokenCache) {
            List<Object> resultRecords;
            MsalOAuth2TokenCache targetCache;
            String methodName = ":loadWithAggregatedAccountData";
            BrokerApplicationMetadata appMetadata = this.mApplicationMetadataCache.getMetadata(clientId, account.getEnvironment(), this.mUid);
            boolean isKnownFoci = false;
            if (null != appMetadata) {
                isKnownFoci = null != appMetadata.getFoci();
                Logger.info(TAG + ":loadWithAggregatedAccountData", "App is known foci? " + isKnownFoci);
            }
            boolean appIsUnknownUseFociAsFallback = null == (targetCache = this.getTokenCacheForClient(appMetadata));
            Logger.info(TAG + ":loadWithAggregatedAccountData", "Loading from FOCI cache? [" + (isKnownFoci || appIsUnknownUseFociAsFallback) + "]");
            if (appIsUnknownUseFociAsFallback) {
                resultRecords = new ArrayList<ICacheRecord>();
                resultRecords.add(this.mFociCache.loadByFamilyId(clientId, target, account, authScheme));
            } else {
                resultRecords = isKnownFoci ? this.mFociCache.loadByFamilyIdWithAggregatedAccountData(clientId, target, account, authScheme) : ((OAuth2TokenCache)targetCache).loadWithAggregatedAccountData(clientId, applicationIdentifier, mamEnrollmentIdentifier, target, account, authScheme);
            }
            boolean resultFound = !resultRecords.isEmpty() && null != ((ICacheRecord)resultRecords.get(0)).getRefreshToken();
            Logger.verbose(TAG + ":loadWithAggregatedAccountData", "Result found? [" + resultFound + "]");
            return resultRecords;
        }
    }

    @Override
    public boolean removeCredential(@NonNull Credential credential) {
        if (credential == null) {
            throw new NullPointerException("credential is marked non-null but is null");
        }
        String methodName = ":removeCredential";
        MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(credential.getClientId(), credential.getEnvironment(), this.mUid);
        boolean removed = false;
        if (null != targetCache) {
            removed = ((OAuth2TokenCache)targetCache).removeCredential(credential);
        } else {
            Logger.warn(TAG + ":removeCredential", "Could not remove credential. Cache not found.");
        }
        Logger.verbose(TAG + ":removeCredential", "Credential removed? [" + removed + "]");
        return removed;
    }

    @Override
    @Nullable
    public AccountRecord getAccount(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId, @Nullable String realm) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        String methodName = ":getAccount";
        MsalOAuth2TokenCache targetCache = null;
        AccountRecord result = null;
        if (null != environment) {
            targetCache = this.getTokenCacheForClient(clientId, environment, this.mUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":getAccount", "Target cache was null. Using FOCI cache.");
                targetCache = this.mFociCache;
            }
            result = ((OAuth2TokenCache)targetCache).getAccount(environment, clientId, homeAccountId, realm);
        } else {
            List<OAuth2TokenCache> clientIdTokenCaches = this.getTokenCachesForClientId(clientId);
            Iterator<OAuth2TokenCache> cacheIterator = clientIdTokenCaches.iterator();
            while (null == result && cacheIterator.hasNext()) {
                result = cacheIterator.next().getAccount(null, clientId, homeAccountId, realm);
            }
        }
        return result;
    }

    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        List<ICacheRecord> result;
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        String methodName = ":getAccountsWithAggregatedAccountData";
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":getAccountsWithAggregatedAccountData", "Falling back to FoCI cache...");
                targetCache = this.mFociCache;
            }
            List<ICacheRecord> resultByAggregatedAccountData = ((OAuth2TokenCache)targetCache).getAccountsWithAggregatedAccountData(environment, clientId, homeAccountId);
            result = resultByAggregatedAccountData;
        } else {
            List<OAuth2TokenCache> caches = this.getTokenCachesForClientId(clientId);
            result = new ArrayList<ICacheRecord>();
            for (OAuth2TokenCache cache : caches) {
                List<ICacheRecord> accountsWithAggregatedAccountData = cache.getAccountsWithAggregatedAccountData(null, clientId, homeAccountId);
                result.addAll(accountsWithAggregatedAccountData);
            }
        }
        return result;
    }

    private List<OAuth2TokenCache> getTokenCachesForClientId(@NonNull String clientId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        List allMetadata = this.mApplicationMetadataCache.getAll();
        ArrayList<OAuth2TokenCache> result = new ArrayList<OAuth2TokenCache>();
        boolean containsFoci = false;
        boolean processUidCacheInitialized = false;
        for (BrokerApplicationMetadata metadata : allMetadata) {
            MsalOAuth2TokenCache candidateCache;
            if (!clientId.equals(metadata.getClientId())) continue;
            if (null != metadata.getFoci() && !containsFoci) {
                result.add(this.mFociCache);
                containsFoci = true;
                continue;
            }
            if (processUidCacheInitialized || null == (candidateCache = this.initializeProcessUidCache(this.getComponents(), this.mUid))) continue;
            result.add(candidateCache);
            processUidCacheInitialized = true;
        }
        return result;
    }

    @Override
    @Nullable
    public AccountRecord getAccountByLocalAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String localAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (localAccountId == null) {
            throw new NullPointerException("localAccountId is marked non-null but is null");
        }
        String methodName = ":getAccountByLocalAccountId";
        Logger.verbose(TAG + ":getAccountByLocalAccountId", "Loading account by local account id.");
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mUid);
            Logger.info(TAG + ":getAccountByLocalAccountId", "Loading from FOCI cache? [" + (targetCache == null) + "]");
            if (null != targetCache) {
                return ((OAuth2TokenCache)targetCache).getAccountByLocalAccountId(environment, clientId, localAccountId);
            }
            return this.mFociCache.getAccountByLocalAccountId(environment, clientId, localAccountId);
        }
        AccountRecord result = null;
        List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
        Iterator<OAuth2TokenCache> cacheIterator = cachesToInspect.iterator();
        while (null == result && cacheIterator.hasNext()) {
            result = cacheIterator.next().getAccountByLocalAccountId(null, clientId, localAccountId);
        }
        return result;
    }

    @Override
    @Nullable
    public ICacheRecord getAccountWithAggregatedAccountDataByLocalAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String localAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (localAccountId == null) {
            throw new NullPointerException("localAccountId is marked non-null but is null");
        }
        String methodName = ":getAccountWithAggregatedAccountDataByLocalAccountId";
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mUid);
            Logger.info(TAG + ":getAccountWithAggregatedAccountDataByLocalAccountId", "Loading from FOCI cache? [" + (targetCache == null) + "]");
            if (null != targetCache) {
                return ((OAuth2TokenCache)targetCache).getAccountWithAggregatedAccountDataByLocalAccountId(environment, clientId, localAccountId);
            }
            return this.mFociCache.getAccountWithAggregatedAccountDataByLocalAccountId(environment, clientId, localAccountId);
        }
        ICacheRecord result = null;
        List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
        Iterator<OAuth2TokenCache> cacheIterator = cachesToInspect.iterator();
        while (null == result && cacheIterator.hasNext()) {
            result = cacheIterator.next().getAccountWithAggregatedAccountDataByLocalAccountId(null, clientId, localAccountId);
        }
        return result;
    }

    @Override
    public List<AccountRecord> getAccounts(@Nullable String environment, @NonNull String clientId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        String methodName = ":getAccounts (2 param)";
        ArrayList<AccountRecord> result = new ArrayList<AccountRecord>();
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mUid);
            if (null != targetCache) {
                result.addAll(((OAuth2TokenCache)targetCache).getAccounts(environment, clientId));
            } else {
                Logger.warn(TAG + ":getAccounts (2 param)", "No caches to inspect.");
            }
        } else {
            List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
            for (OAuth2TokenCache cache : cachesToInspect) {
                if (cache == null) continue;
                result.addAll(cache.getAccounts(null, clientId));
            }
            Logger.verbose(TAG + ":getAccounts (2 param)", "Found [" + result.size() + "] accounts.");
        }
        return result;
    }

    @Override
    public List<AccountRecord> getAllTenantAccountsForAccountByClientId(@NonNull String clientId, @NonNull AccountRecord accountRecord) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        String methodName = ":getAllTenantAccountsForAccountByClientId";
        MsalOAuth2TokenCache cache = this.getTokenCacheForClient(clientId, accountRecord.getEnvironment(), this.mUid);
        if (cache == null) {
            Logger.warn(TAG + ":getAllTenantAccountsForAccountByClientId", "Cache not found for clientid: " + clientId + "environment:" + accountRecord.getEnvironment() + "processUid: " + this.mUid);
            return Collections.emptyList();
        }
        List<AccountRecord> tenantAccountsForAccountByClientId = ((OAuth2TokenCache)cache).getAllTenantAccountsForAccountByClientId(clientId, accountRecord);
        return tenantAccountsForAccountByClientId;
    }

    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(@Nullable String environment, @NonNull String clientId) {
        List<ICacheRecord> result;
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        String methodName = ":getAccountsWithAggregatedAccountData";
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":getAccountsWithAggregatedAccountData", "Falling back to FoCI cache...");
                targetCache = this.mFociCache;
            }
            List<ICacheRecord> targetCacheAccountsWithAggregatedAccountData = ((OAuth2TokenCache)targetCache).getAccountsWithAggregatedAccountData(environment, clientId);
            result = targetCacheAccountsWithAggregatedAccountData;
        } else {
            List<OAuth2TokenCache> caches = this.getTokenCachesForClientId(clientId);
            result = new ArrayList<ICacheRecord>();
            for (OAuth2TokenCache cache : caches) {
                List<ICacheRecord> cacheAccountsWithAggregatedAccountData = cache.getAccountsWithAggregatedAccountData(null, clientId);
                result.addAll(cacheAccountsWithAggregatedAccountData);
            }
        }
        return result;
    }

    @Override
    public List<IdTokenRecord> getIdTokensForAccountRecord(@NonNull String clientId, @NonNull AccountRecord accountRecord) {
        List<IdTokenRecord> cacheIdTokensForAccountRecord;
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        String methodName = ":getIdTokensForAccountRecord";
        String accountEnv = accountRecord.getEnvironment();
        if (null == clientId) {
            throw new UnsupportedOperationException("Aggregating IdTokens across ClientIds is not supported - do you have a feature request?");
        }
        MsalOAuth2TokenCache cache = this.getTokenCacheForClient(clientId, accountEnv, this.mUid);
        if (cache == null) {
            Logger.warn(TAG + ":getIdTokensForAccountRecord", "Cache not found for clientid: " + clientId + "environment:" + accountRecord.getEnvironment() + "processUid: " + this.mUid);
            return Collections.emptyList();
        }
        List<IdTokenRecord> result = cacheIdTokensForAccountRecord = ((OAuth2TokenCache)cache).getIdTokensForAccountRecord(clientId, accountRecord);
        return result;
    }

    public List<AccountRecord> getAccounts() {
        String methodName = ":getAccounts";
        HashSet<AccountRecord> allAccounts = new HashSet<AccountRecord>();
        List allMetadata = this.mApplicationMetadataCache.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            MsalOAuth2TokenCache candidateCache = this.getTokenCacheForClient(metadata);
            if (null == candidateCache) continue;
            allAccounts.addAll(candidateCache.getAccountCredentialCache().getAccounts());
        }
        allAccounts.addAll(this.mFociCache.getAccountCredentialCache().getAccounts());
        ArrayList<AccountRecord> allAccountsResult = new ArrayList<AccountRecord>(allAccounts);
        Logger.verbose(TAG + ":getAccounts", "Found [" + allAccountsResult.size() + "] accounts.");
        return allAccountsResult;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Lombok inserts null checks that may be redundant")
    public AccountDeletionRecord removeAccountFromDevice(@NonNull AccountRecord accountRecord) {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        String methodName = ":removeAccountFromDevice";
        Set<String> allClientIds = this.mApplicationMetadataCache.getAllClientIds();
        Logger.info(TAG + ":removeAccountFromDevice", "Found [" + allClientIds.size() + "] client ids.");
        ArrayList<AccountDeletionRecord> deletionRecordList = new ArrayList<AccountDeletionRecord>();
        for (String clientId : allClientIds) {
            deletionRecordList.add(this.removeAccountInternal(accountRecord.getEnvironment(), clientId, accountRecord.getHomeAccountId(), null, true));
        }
        ArrayList<AccountRecord> deletedAccountRecords = new ArrayList<AccountRecord>();
        for (AccountDeletionRecord accountDeletionRecord : deletionRecordList) {
            deletedAccountRecords.addAll(accountDeletionRecord);
        }
        Logger.info(TAG + ":removeAccountFromDevice", "Deleted [" + deletedAccountRecords.size() + "] AccountRecords.");
        return new AccountDeletionRecord(deletedAccountRecords);
    }

    @Override
    public AccountDeletionRecord removeAccount(@Nullable String environment, @Nullable String clientId, @Nullable String homeAccountId, @Nullable String realm) {
        return this.removeAccountInternal(environment, clientId, homeAccountId, realm, false);
    }

    @Override
    public AccountDeletionRecord removeAccount(String environment, String clientId, String homeAccountId, String realm, CredentialType ... typesToRemove) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    @Override
    public void clearAll() {
        List allClientsMetadata = this.mApplicationMetadataCache.getAll();
        for (BrokerApplicationMetadata clientMetadata : allClientsMetadata) {
            MsalOAuth2TokenCache clientTokenCache = this.getTokenCacheForClient(clientMetadata.getClientId(), clientMetadata.getEnvironment(), clientMetadata.getUid());
            if (clientTokenCache == null) continue;
            ((OAuth2TokenCache)clientTokenCache).clearAll();
        }
        this.mFociCache.clearAll();
        this.mApplicationMetadataCache.clear();
    }

    public boolean isClientIdKnownToCache(@NonNull String clientId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        return this.getAllClientIds().contains(clientId);
    }

    public List<ICacheRecord> getFociCacheRecords() {
        String methodName = ":getFociCacheRecords";
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        List<BrokerApplicationMetadata> allFociApplicationMetadata = this.mApplicationMetadataCache.getAllFociApplicationMetadata();
        for (BrokerApplicationMetadata fociAppMetadata : allFociApplicationMetadata) {
            List<AccountRecord> accounts = this.mFociCache.getAccounts(fociAppMetadata.getEnvironment(), fociAppMetadata.getClientId());
            for (AccountRecord account : accounts) {
                String homeAccountId = account.getHomeAccountId();
                String environment = account.getEnvironment();
                String clientId = fociAppMetadata.getClientId();
                String realm = account.getRealm();
                List<Credential> refreshTokens = this.mFociCache.getAccountCredentialCache().getCredentialsFilteredBy(homeAccountId, environment, CredentialType.RefreshToken, clientId, null, null, null, null, null);
                List<Credential> v1IdTokens = this.mFociCache.getAccountCredentialCache().getCredentialsFilteredBy(homeAccountId, environment, CredentialType.V1IdToken, clientId, null, null, realm, null, null);
                List<Credential> idTokens = this.mFociCache.getAccountCredentialCache().getCredentialsFilteredBy(homeAccountId, environment, CredentialType.IdToken, clientId, null, null, realm, null, null);
                if (refreshTokens.isEmpty()) continue;
                CacheRecord.CacheRecordBuilder cacheRecord = CacheRecord.builder();
                cacheRecord.account(account);
                cacheRecord.refreshToken((RefreshTokenRecord)refreshTokens.get(0));
                if (!v1IdTokens.isEmpty()) {
                    Logger.verbose(TAG + ":getFociCacheRecords", "Found [" + v1IdTokens.size() + "] V1IdTokens");
                    cacheRecord.v1IdToken((IdTokenRecord)v1IdTokens.get(0));
                } else {
                    Logger.warn(TAG + ":getFociCacheRecords", "No V1IdTokens exist for this account.");
                }
                if (!idTokens.isEmpty()) {
                    Logger.verbose(TAG + ":getFociCacheRecords", "Found [" + idTokens.size() + "] IdTokens");
                    cacheRecord.idToken((IdTokenRecord)idTokens.get(0));
                } else {
                    Logger.warn(TAG + ":getFociCacheRecords", "No IdTokens exist for this account.");
                }
                result.add(cacheRecord.build());
            }
        }
        return result;
    }

    private AccountDeletionRecord removeAccountInternal(@Nullable String environment, @Nullable String clientId, @Nullable String homeAccountId, @Nullable String realm, boolean deviceWide) {
        String methodName = ":removeAccountInternal";
        List allMetadata = this.mApplicationMetadataCache.getAll();
        ArrayList<AccountDeletionRecord> deletionRecordList = new ArrayList<AccountDeletionRecord>();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            MsalOAuth2TokenCache candidateCache = this.getTokenCacheForClient(metadata.getClientId(), metadata.getEnvironment(), deviceWide ? metadata.getUid() : this.mUid);
            if (null == candidateCache) continue;
            deletionRecordList.add(((OAuth2TokenCache)candidateCache).removeAccount(environment, clientId, homeAccountId, realm));
        }
        ArrayList<AccountRecord> deletedAccountRecords = new ArrayList<AccountRecord>();
        for (AccountDeletionRecord accountDeletionRecord : deletionRecordList) {
            deletedAccountRecords.addAll(accountDeletionRecord);
        }
        Logger.info(TAG + ":removeAccountInternal", "Deleted [" + deletedAccountRecords.size() + "] AccountRecords.");
        return new AccountDeletionRecord(deletedAccountRecords);
    }

    @Override
    protected Set<String> getAllClientIds() {
        return this.mApplicationMetadataCache.getAllClientIds();
    }

    @Override
    public AccountRecord getAccountByHomeAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        String methodName = "getAccountByHomeAccountId";
        Logger.verbose(TAG + "getAccountByHomeAccountId", "Loading account by home account id.");
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mUid);
            Logger.info(TAG + "getAccountByHomeAccountId", "Loading from FOCI cache? [" + (targetCache == null) + "]");
            if (null != targetCache) {
                return ((OAuth2TokenCache)targetCache).getAccountByHomeAccountId(environment, clientId, homeAccountId);
            }
            return this.mFociCache.getAccountByHomeAccountId(environment, clientId, homeAccountId);
        }
        AccountRecord result = null;
        List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
        Iterator<OAuth2TokenCache> cacheIterator = cachesToInspect.iterator();
        while (null == result && cacheIterator.hasNext()) {
            result = cacheIterator.next().getAccountByHomeAccountId(null, clientId, homeAccountId);
        }
        return result;
    }

    private MsalOAuth2TokenCache initializeProcessUidCache(@NonNull IPlatformComponents components, int uid) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        String methodName = ":initializeProcessUidCache";
        Logger.verbose(TAG + ":initializeProcessUidCache", "Initializing uid cache.");
        if (null != this.mDelegate) {
            Logger.warn(TAG + ":initializeProcessUidCache", "Using swapped delegate cache.");
            return this.mDelegate.getTokenCache(components, uid);
        }
        INameValueStorage<String> sharedPreferencesFileManager = components.getStorageSupplier().getEncryptedNameValueStore(SharedPreferencesAccountCredentialCache.getBrokerUidSequesteredFilename(uid), String.class);
        return BrokerOAuth2TokenCache.getTokenCache(components, sharedPreferencesFileManager, false);
    }

    private static MicrosoftFamilyOAuth2TokenCache initializeFociCache(@NonNull IPlatformComponents components) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        String methodName = ":initializeFociCache";
        Logger.verbose(TAG + ":initializeFociCache", "Initializing foci cache");
        INameValueStorage<String> sharedPreferencesFileManager = components.getStorageSupplier().getEncryptedNameValueStore("com.microsoft.identity.client.account_credential_cache.foci-1", String.class);
        return (MicrosoftFamilyOAuth2TokenCache)BrokerOAuth2TokenCache.getTokenCache(components, sharedPreferencesFileManager, true);
    }

    private static <T extends MsalOAuth2TokenCache> T getTokenCache(@NonNull IPlatformComponents components, @NonNull INameValueStorage<String> spfm, boolean isFoci) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        if (spfm == null) {
            throw new NullPointerException("spfm is marked non-null but is null");
        }
        CacheKeyValueDelegate cacheKeyValueDelegate = new CacheKeyValueDelegate();
        SharedPreferencesAccountCredentialCache accountCredentialCache = new SharedPreferencesAccountCredentialCache(cacheKeyValueDelegate, spfm);
        MicrosoftStsAccountCredentialAdapter accountCredentialAdapter = new MicrosoftStsAccountCredentialAdapter();
        return (T)(isFoci ? new MicrosoftFamilyOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken>(components, accountCredentialCache, accountCredentialAdapter) : new MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken>(components, accountCredentialCache, accountCredentialAdapter));
    }

    @Nullable
    private MsalOAuth2TokenCache getTokenCacheForClient(@Nullable BrokerApplicationMetadata metadata) {
        String methodName = ":getTokenCacheForClient(bam)";
        MsalOAuth2TokenCache targetCache = null;
        if (null != metadata) {
            boolean isFoci = null != metadata.getFoci();
            Logger.verbose(TAG + ":getTokenCacheForClient(bam)", "is Foci? [" + isFoci + "]");
            targetCache = isFoci ? this.mFociCache : this.initializeProcessUidCache(this.getComponents(), metadata.getUid());
        }
        if (null == targetCache) {
            Logger.warn(TAG + ":getTokenCacheForClient(bam)", "Could not locate a cache for this app.");
        }
        return targetCache;
    }

    @Nullable
    private MsalOAuth2TokenCache getTokenCacheForClient(@NonNull String clientId, @NonNull String environment, int uid) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        String methodName = ":getTokenCacheForClient(id, env, uid)";
        BrokerApplicationMetadata metadata = this.mApplicationMetadataCache.getMetadata(clientId, environment, uid);
        Logger.info(TAG + ":getTokenCacheForClient(id, env, uid)", "Found metadata? " + (null != metadata));
        return this.getTokenCacheForClient(metadata);
    }

    public void setSingleSignOnState(@NonNull String uidStr, @NonNull GenericAccount account, @NonNull GenericRefreshToken refreshToken) {
        MsalOAuth2TokenCache targetCache;
        if (uidStr == null) {
            throw new NullPointerException("uidStr is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        String methodName = ":setSingleSignOnState";
        boolean isFrt = ((MicrosoftRefreshToken)refreshToken).getIsFamilyRefreshToken();
        int uid = Integer.parseInt(uidStr);
        if (isFrt) {
            Logger.verbose(TAG + ":setSingleSignOnState", "Saving tokens to foci cache.");
            targetCache = this.mFociCache;
        } else {
            targetCache = this.initializeProcessUidCache(this.getComponents(), uid);
        }
        try {
            this.targetCacheSetSingleSignOnState(account, refreshToken, targetCache);
            this.updateApplicationMetadataCache(((MicrosoftRefreshToken)refreshToken).getClientId(), ((MicrosoftRefreshToken)refreshToken).getEnvironment(), ((MicrosoftRefreshToken)refreshToken).getFamilyId(), uid);
        }
        catch (ClientException e) {
            Logger.warn(TAG + ":setSingleSignOnState", "Failed to save account/refresh token. Skipping.");
        }
    }

    private void targetCacheSetSingleSignOnState(@NonNull GenericAccount account, @NonNull GenericRefreshToken refreshToken, MsalOAuth2TokenCache targetCache) throws ClientException {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        targetCache.setSingleSignOnState(account, refreshToken);
    }

    public static interface ProcessUidCacheFactory {
        public MsalOAuth2TokenCache getTokenCache(IPlatformComponents var1, int var2);
    }
}

