/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeWithClientKeyInternal;
import com.microsoft.identity.common.java.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccount;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.DateUtilities;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MicrosoftStsAccountCredentialAdapter
implements IAccountCredentialAdapter<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> {
    private static final String TAG = MicrosoftStsAccountCredentialAdapter.class.getSimpleName();

    @Override
    public AccountRecord createAccount(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        Logger.verbose(TAG, "Creating Account");
        return new AccountRecord(strategy.createAccount(response));
    }

    @Override
    public AccessTokenRecord createAccessToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            long cachedAt = this.getCachedAt();
            long expiresOn = this.getExpiresOn(response);
            long refreshOn = this.getRefreshOn(response);
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            AccessTokenRecord accessToken = new AccessTokenRecord();
            accessToken.setCredentialType(this.getCredentialType(StringUtil.sanitizeNull(response.getTokenType())));
            accessToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            accessToken.setRealm(this.getRealm(strategy, response));
            accessToken.setEnvironment(strategy.getIssuerCacheIdentifierFromTokenEndpoint());
            accessToken.setClientId(request.getClientId());
            accessToken.setTarget(this.getTarget(request.getScope(), response.getScope()));
            accessToken.setCachedAt(String.valueOf(cachedAt));
            accessToken.setExpiresOn(String.valueOf(expiresOn));
            accessToken.setRefreshOn(String.valueOf(refreshOn));
            accessToken.setSecret(response.getAccessToken());
            accessToken.setExtendedExpiresOn(this.getExtendedExpiresOn(response));
            accessToken.setAuthority(strategy.getAuthorityFromTokenEndpoint());
            accessToken.setAccessTokenType(response.getTokenType());
            accessToken.setApplicationIdentifier(request.getApplicationIdentifier());
            accessToken.setMamEnrollmentIdentifier(request.getMamEnrollmentIdentifier());
            if ("pop".equalsIgnoreCase(response.getTokenType())) {
                accessToken.setKid(strategy.getDeviceAtPopThumbprint());
            }
            return accessToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private String getCredentialType(@NonNull String tokenType) {
        if (tokenType == null) {
            throw new NullPointerException("tokenType is marked non-null but is null");
        }
        String type = CredentialType.AccessToken.name();
        if ("pop".equalsIgnoreCase(tokenType)) {
            return CredentialType.AccessToken_With_AuthScheme.name();
        }
        return type;
    }

    private String getTarget(@Nullable String requestScope, @Nullable String responseScope) {
        if (StringUtil.isNullOrEmpty(responseScope)) {
            StringBuilder scopesToCache = new StringBuilder();
            String[] requestScopes = requestScope.split("\\s+");
            HashSet<String> requestScopeSet = new HashSet<String>(Arrays.asList(requestScopes));
            requestScopeSet.removeAll(AuthenticationConstants.DEFAULT_SCOPES);
            for (String scope : requestScopeSet) {
                scopesToCache.append(scope).append(' ');
            }
            return scopesToCache.toString().trim();
        }
        return responseScope;
    }

    @Override
    public RefreshTokenRecord createRefreshToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            long cachedAt = this.getCachedAt();
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            RefreshTokenRecord refreshToken = new RefreshTokenRecord();
            refreshToken.setCredentialType(CredentialType.RefreshToken.name());
            refreshToken.setEnvironment(strategy.getIssuerCacheIdentifierFromTokenEndpoint());
            refreshToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            refreshToken.setClientId(request.getClientId());
            refreshToken.setSecret(response.getRefreshToken());
            refreshToken.setFamilyId(response.getFamilyId());
            refreshToken.setTarget(this.getTarget(request.getScope(), response.getScope()));
            refreshToken.setCachedAt(String.valueOf(cachedAt));
            return refreshToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IdTokenRecord createIdToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            IdTokenRecord idToken = new IdTokenRecord();
            idToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            idToken.setEnvironment(strategy.getIssuerCacheIdentifierFromTokenEndpoint());
            idToken.setRealm(this.getRealm(strategy, response));
            idToken.setCredentialType(SchemaUtil.getCredentialTypeFromVersion(response.getIdToken()));
            idToken.setClientId(request.getClientId());
            idToken.setSecret(response.getIdToken());
            idToken.setAuthority(strategy.getAuthorityFromTokenEndpoint());
            return idToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RefreshTokenRecord asRefreshToken(@NonNull MicrosoftRefreshToken refreshTokenIn) {
        if (refreshTokenIn == null) {
            throw new NullPointerException("refreshTokenIn is marked non-null but is null");
        }
        RefreshTokenRecord refreshTokenOut = new RefreshTokenRecord();
        refreshTokenOut.setHomeAccountId(refreshTokenIn.getHomeAccountId());
        refreshTokenOut.setEnvironment(refreshTokenIn.getEnvironment());
        refreshTokenOut.setCredentialType(CredentialType.RefreshToken.name());
        refreshTokenOut.setClientId(refreshTokenIn.getClientId());
        refreshTokenOut.setSecret(refreshTokenIn.getSecret());
        refreshTokenOut.setTarget(refreshTokenIn.getTarget());
        refreshTokenOut.setCachedAt(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        refreshTokenOut.setFamilyId(refreshTokenIn.getFamilyId());
        return refreshTokenOut;
    }

    @Override
    public AccountRecord asAccount(MicrosoftAccount account) {
        AccountRecord acct = new AccountRecord(account);
        return acct;
    }

    @Override
    public IdTokenRecord asIdToken(MicrosoftAccount msAccount, MicrosoftRefreshToken refreshToken) {
        long cachedAt = this.getCachedAt();
        IDToken msIdToken = msAccount.getIDToken();
        IdTokenRecord idToken = new IdTokenRecord();
        idToken.setHomeAccountId(refreshToken.getHomeAccountId());
        idToken.setEnvironment(refreshToken.getEnvironment());
        idToken.setRealm(msAccount.getRealm());
        idToken.setCredentialType(CredentialType.IdToken.name());
        idToken.setClientId(refreshToken.getClientId());
        idToken.setSecret(msIdToken.getRawIDToken());
        idToken.setCachedAt(String.valueOf(cachedAt));
        idToken.setAuthority(SchemaUtil.getAuthority(msIdToken));
        return idToken;
    }

    @Override
    public AccountRecord createAccountRecord(@NonNull TokenCommandParameters parameters, SdkType sdkType, @NonNull MicrosoftStsTokenResponse microsoftStsTokenResponse) throws ServiceException {
        AzureActiveDirectoryCloud cloudEnv;
        AccountRecord accountRecord;
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (microsoftStsTokenResponse == null) {
            throw new NullPointerException("microsoftStsTokenResponse is marked non-null but is null");
        }
        String methodTag = TAG + ":createAccountRecord";
        ClientInfo clientInfo = new ClientInfo(microsoftStsTokenResponse.getClientInfo());
        if (sdkType.equals((Object)SdkType.ADAL)) {
            AzureActiveDirectoryAccount azureActiveDirectoryAccount = new AzureActiveDirectoryAccount(new IDToken(microsoftStsTokenResponse.getIdToken()), clientInfo);
            accountRecord = new AccountRecord(azureActiveDirectoryAccount);
        } else {
            MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(microsoftStsTokenResponse.getIdToken()), clientInfo);
            accountRecord = new AccountRecord(microsoftStsAccount);
        }
        URL authority = parameters.getAuthority().getAuthorityURL();
        if (!microsoftStsTokenResponse.getAuthority().isEmpty()) {
            try {
                authority = new URL(microsoftStsTokenResponse.getAuthority());
            }
            catch (MalformedURLException e) {
                Logger.error(methodTag, "Authority url construction failed, setting request authority to result", e);
            }
        }
        if ((cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(authority)) != null) {
            Logger.info(methodTag, "Using preferred cache host name...");
            accountRecord.setEnvironment(cloudEnv.getPreferredCacheHostName());
        } else {
            accountRecord.setEnvironment(authority.getHost());
        }
        return accountRecord;
    }

    @Override
    public AccessTokenRecord createAccessTokenRecord(@NonNull TokenCommandParameters parameters, @NonNull AccountRecord accountRecord, @NonNull MicrosoftStsTokenResponse tokenResponse) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (tokenResponse == null) {
            throw new NullPointerException("tokenResponse is marked non-null but is null");
        }
        String methodTag = TAG + ":createAccessTokenRecord";
        AccessTokenRecord accessTokenRecord = new AccessTokenRecord();
        accessTokenRecord.setHomeAccountId(accountRecord.getHomeAccountId());
        accessTokenRecord.setRealm(accountRecord.getRealm());
        AbstractAuthenticationScheme authenticationScheme = parameters.getAuthenticationScheme();
        if (authenticationScheme instanceof PopAuthenticationSchemeInternal) {
            IDevicePopManager devicePopManager = parameters.getPlatformComponents().getDefaultDevicePopManager();
            accessTokenRecord.setCredentialType(CredentialType.AccessToken_With_AuthScheme.name());
            accessTokenRecord.setKid(devicePopManager.getAsymmetricKeyThumbprint());
        } else if (authenticationScheme instanceof PopAuthenticationSchemeWithClientKeyInternal) {
            accessTokenRecord.setCredentialType(CredentialType.AccessToken_With_AuthScheme.name());
            accessTokenRecord.setKid(((PopAuthenticationSchemeWithClientKeyInternal)authenticationScheme).getKid());
        } else {
            accessTokenRecord.setCredentialType(CredentialType.AccessToken.name());
        }
        accessTokenRecord.setClientId(parameters.getClientId());
        accessTokenRecord.setApplicationIdentifier(parameters.getApplicationIdentifier());
        accessTokenRecord.setSecret(tokenResponse.getAccessToken());
        accessTokenRecord.setAccessTokenType(tokenResponse.getTokenType());
        accessTokenRecord.setTarget(this.getTarget(StringUtil.join(" ", parameters.getScopes()), tokenResponse.getScope()));
        this.setCredentialEnvironment(accessTokenRecord, parameters.getAuthority(), tokenResponse, methodTag);
        if (tokenResponse.getExpiresIn() != null) {
            accessTokenRecord.setExpiresOn(String.valueOf(DateUtilities.getExpiresOn(tokenResponse.getExpiresIn())));
        }
        if (tokenResponse.getExtExpiresIn() != null) {
            accessTokenRecord.setExtendedExpiresOn(String.valueOf(DateUtilities.getExpiresOn(tokenResponse.getExtExpiresIn())));
        }
        accessTokenRecord.setCachedAt(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        return accessTokenRecord;
    }

    @Override
    public RefreshTokenRecord createRefreshTokenRecord(@NonNull TokenCommandParameters parameters, @NonNull AccountRecord accountRecord, @NonNull MicrosoftStsTokenResponse tokenResponse) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (tokenResponse == null) {
            throw new NullPointerException("tokenResponse is marked non-null but is null");
        }
        String methodTag = TAG + ":createRefreshTokenRecord";
        RefreshTokenRecord refreshToken = new RefreshTokenRecord();
        refreshToken.setHomeAccountId(accountRecord.getHomeAccountId());
        refreshToken.setCredentialType(CredentialType.RefreshToken.name());
        this.setCredentialEnvironment(refreshToken, parameters.getAuthority(), tokenResponse, methodTag);
        refreshToken.setClientId(parameters.getClientId());
        refreshToken.setSecret(tokenResponse.getRefreshToken());
        refreshToken.setFamilyId(tokenResponse.getFamilyId());
        refreshToken.setTarget(this.getTarget(StringUtil.join(" ", parameters.getScopes()), tokenResponse.getScope()));
        refreshToken.setCachedAt(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        return refreshToken;
    }

    @Override
    public IdTokenRecord createIdTokenRecord(@NonNull TokenCommandParameters parameters, @NonNull AccountRecord accountRecord, @NonNull MicrosoftStsTokenResponse tokenResponse) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (tokenResponse == null) {
            throw new NullPointerException("tokenResponse is marked non-null but is null");
        }
        String methodTag = TAG + ":createIdTokenRecord";
        IdTokenRecord idToken = new IdTokenRecord();
        idToken.setHomeAccountId(accountRecord.getHomeAccountId());
        idToken.setRealm(accountRecord.getRealm());
        idToken.setCredentialType(SchemaUtil.getCredentialTypeFromVersion(tokenResponse.getIdToken()));
        idToken.setClientId(parameters.getClientId());
        idToken.setSecret(tokenResponse.getIdToken());
        this.setCredentialEnvironment(idToken, parameters.getAuthority(), tokenResponse, methodTag);
        return idToken;
    }

    private void setCredentialEnvironment(@NonNull Credential credential, @NonNull Authority requestAuthority, @NonNull MicrosoftTokenResponse tokenResponse, @NonNull String callingMethodTag) {
        AzureActiveDirectoryCloud cloudEnv;
        if (credential == null) {
            throw new NullPointerException("credential is marked non-null but is null");
        }
        if (requestAuthority == null) {
            throw new NullPointerException("requestAuthority is marked non-null but is null");
        }
        if (tokenResponse == null) {
            throw new NullPointerException("tokenResponse is marked non-null but is null");
        }
        if (callingMethodTag == null) {
            throw new NullPointerException("callingMethodTag is marked non-null but is null");
        }
        String methodTag = callingMethodTag + ":setCredentialEnvironment";
        URL authority = requestAuthority.getAuthorityURL();
        if (!tokenResponse.getAuthority().isEmpty()) {
            try {
                authority = new URL(tokenResponse.getAuthority());
            }
            catch (MalformedURLException e) {
                Logger.error(methodTag, "Authority url construction failed, setting request authority to result", e);
            }
        }
        if ((cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(authority)) != null) {
            Logger.info(methodTag, "Using preferred cache host name...");
            credential.setEnvironment(cloudEnv.getPreferredCacheHostName());
        } else {
            credential.setEnvironment(authority.getHost());
        }
        if (credential instanceof IdTokenRecord) {
            ((IdTokenRecord)credential).setAuthority(authority.toString());
        }
        if (credential instanceof AccessTokenRecord) {
            ((AccessTokenRecord)credential).setAuthority(authority.toString());
        }
    }

    private String getExtendedExpiresOn(MicrosoftStsTokenResponse response) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSecs = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        long extExpiresIn = null == response.getExtExpiresIn() ? 0L : response.getExtExpiresIn();
        return String.valueOf(currentTimeSecs + extExpiresIn);
    }

    private String getRealm(MicrosoftStsOAuth2Strategy msStrategy, MicrosoftStsTokenResponse msTokenResponse) {
        MicrosoftStsAccount msAccount = msStrategy.createAccount(msTokenResponse);
        return msAccount.getRealm();
    }

    private long getCachedAt() {
        long currentTimeMillis = System.currentTimeMillis();
        return TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
    }

    private long getExpiresOn(MicrosoftStsTokenResponse msTokenResponse) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSecs = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        long expiresIn = msTokenResponse.getExpiresIn();
        return currentTimeSecs + expiresIn;
    }

    private long getRefreshOn(MicrosoftStsTokenResponse msTokenResponse) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSecs = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        long refreshIn = msTokenResponse.getRefreshIn() == null ? msTokenResponse.getExpiresIn() : msTokenResponse.getRefreshIn();
        return currentTimeSecs + refreshIn;
    }
}

