/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.TokenCommand;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.controllers.IControllerFactory;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.UiRequiredException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.List;
import lombok.NonNull;

public class SilentTokenCommand
extends TokenCommand {
    public static final int ACQUIRE_TOKEN_SILENT_DEFAULT_TIMEOUT_MILLISECONDS = 30000;
    private static final String TAG = SilentTokenCommand.class.getSimpleName();

    public SilentTokenCommand(@NonNull SilentTokenCommandParameters parameters, @NonNull IControllerFactory controllerFactory, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super(parameters, controllerFactory, callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controllerFactory == null) {
            throw new NullPointerException("controllerFactory is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AcquireTokenResult execute() throws Exception {
        AcquireTokenResult result = null;
        String methodName = ":execute";
        Span span = SpanExtension.current();
        span.setAttribute(AttributeName.application_name.name(), this.getParameters().getApplicationName());
        span.setAttribute(AttributeName.public_api_id.name(), this.getPublicApiId());
        List<BaseController> controllers = this.getControllerFactory().getAllControllers();
        try (Scope scope = SpanExtension.makeCurrentSpan(span);){
            BaseException exceptionFromFirstController = null;
            for (int ii = 0; ii < controllers.size(); ++ii) {
                BaseController controller = controllers.get(ii);
                span.setAttribute(AttributeName.controller_name.name(), controller.getClass().getSimpleName());
                try {
                    Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
                    result = controller.acquireTokenSilent((SilentTokenCommandParameters)this.getParameters());
                    if (!result.getSucceeded().booleanValue()) continue;
                    Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName() + ": Succeeded");
                    span.setAttribute(AttributeName.is_serviced_from_cache.name(), result.getLocalAuthenticationResult().isServicedFromCache());
                    span.setStatus(StatusCode.OK);
                    AcquireTokenResult acquireTokenResult = result;
                    return acquireTokenResult;
                }
                catch (ClientException | UiRequiredException e) {
                    if (ii == 0) {
                        exceptionFromFirstController = e;
                    }
                    if (ii + 1 >= controllers.size()) throw exceptionFromFirstController;
                    if ("invalid_grant".equals(e.getErrorCode()) || "no_tokens_found".equals(e.getErrorCode()) || "no_account_found".equals(e.getErrorCode())) continue;
                    throw exceptionFromFirstController;
                }
                catch (Throwable e) {
                    if (exceptionFromFirstController == null) throw e;
                    throw exceptionFromFirstController;
                }
            }
            if (result == null) {
                span.setStatus(StatusCode.ERROR, "empty result");
            } else if (result.getSucceeded().booleanValue()) {
                span.setStatus(StatusCode.OK);
            } else {
                BaseException exception = ExceptionAdapter.exceptionFromAcquireTokenResult(result, this.getParameters());
                if (exception != null) {
                    span.recordException((Throwable)exception);
                    span.setStatus(StatusCode.ERROR);
                } else {
                    span.setStatus(StatusCode.ERROR, "empty exception");
                }
            }
            AcquireTokenResult acquireTokenResult = result;
            return acquireTokenResult;
        }
        catch (Throwable throwable) {
            span.setStatus(StatusCode.ERROR);
            span.recordException(throwable);
            throw throwable;
        }
    }

    @Override
    public boolean isEligibleForCaching() {
        return true;
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SilentTokenCommand)) {
            return false;
        }
        SilentTokenCommand other = (SilentTokenCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SilentTokenCommand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

