/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands.parameters;

import com.google.gson.annotations.Expose;
import com.microsoft.identity.common.java.broker.IBrokerAccount;
import com.microsoft.identity.common.java.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.IBrokerTokenCommandParameters;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.request.BrokerRequestType;
import com.microsoft.identity.common.java.util.StringUtil;

public class BrokerDeviceCodeFlowCommandParameters
extends DeviceCodeFlowCommandParameters
implements IBrokerTokenCommandParameters {
    @Expose
    private final String callerAppVersion;
    @Expose
    private final String brokerVersion;
    @Expose
    private final String negotiatedBrokerProtocolVersion;
    @Expose
    private final boolean pKeyAuthHeaderAllowed;
    @Expose
    private final BrokerRequestType requestType;
    @Expose
    private final String homeTenantId;
    private final IBrokerAccount brokerAccount;
    private final String homeAccountId;
    private final String localAccountId;
    private final int sleepTimeBeforePrtAcquisition;
    private final int callerUid;

    @Override
    public void validate() throws ArgumentException {
        super.validate();
        if (this.getAuthority() == null) {
            throw new ArgumentException("acquireTokenWithDeviceCode", "mAuthority", "Authority Url is not set");
        }
        if (this.getScopes() == null || this.getScopes().isEmpty()) {
            throw new ArgumentException("acquireTokenWithDeviceCode", "mScopes", "Scope or resource is not set");
        }
        if (StringUtil.isNullOrEmpty(this.getClientId())) {
            throw new ArgumentException("acquireTokenWithDeviceCode", "mClientId", "Client Id is not set");
        }
        if (!(this.getOAuth2TokenCache() instanceof BrokerOAuth2TokenCache)) {
            throw new ArgumentException("acquireTokenWithDeviceCode", "BrokerDeviceCodeFlowCommandParameters", "OAuth2Cache not an instance of BrokerOAuth2TokenCache");
        }
    }

    protected BrokerDeviceCodeFlowCommandParameters(BrokerDeviceCodeFlowCommandParametersBuilder<?, ?> b) {
        super((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder<?, ?>)b);
        this.callerAppVersion = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).callerAppVersion;
        this.brokerVersion = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).brokerVersion;
        this.negotiatedBrokerProtocolVersion = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).negotiatedBrokerProtocolVersion;
        this.pKeyAuthHeaderAllowed = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).pKeyAuthHeaderAllowed;
        this.requestType = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).requestType;
        this.homeTenantId = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).homeTenantId;
        this.brokerAccount = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).brokerAccount;
        this.homeAccountId = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).homeAccountId;
        this.localAccountId = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).localAccountId;
        this.sleepTimeBeforePrtAcquisition = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).sleepTimeBeforePrtAcquisition;
        this.callerUid = ((BrokerDeviceCodeFlowCommandParametersBuilder)b).callerUid;
    }

    public static BrokerDeviceCodeFlowCommandParametersBuilder<?, ?> builder() {
        return new BrokerDeviceCodeFlowCommandParametersBuilderImpl();
    }

    @Override
    public BrokerDeviceCodeFlowCommandParametersBuilder<?, ?> toBuilder() {
        return new BrokerDeviceCodeFlowCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public String getCallerAppVersion() {
        return this.callerAppVersion;
    }

    @Override
    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    @Override
    public String getNegotiatedBrokerProtocolVersion() {
        return this.negotiatedBrokerProtocolVersion;
    }

    public boolean isPKeyAuthHeaderAllowed() {
        return this.pKeyAuthHeaderAllowed;
    }

    @Override
    public BrokerRequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public String getHomeTenantId() {
        return this.homeTenantId;
    }

    @Override
    public IBrokerAccount getBrokerAccount() {
        return this.brokerAccount;
    }

    @Override
    public String getHomeAccountId() {
        return this.homeAccountId;
    }

    @Override
    public String getLocalAccountId() {
        return this.localAccountId;
    }

    public int getSleepTimeBeforePrtAcquisition() {
        return this.sleepTimeBeforePrtAcquisition;
    }

    @Override
    public int getCallerUid() {
        return this.callerUid;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerDeviceCodeFlowCommandParameters)) {
            return false;
        }
        BrokerDeviceCodeFlowCommandParameters other = (BrokerDeviceCodeFlowCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPKeyAuthHeaderAllowed() != other.isPKeyAuthHeaderAllowed()) {
            return false;
        }
        if (this.getSleepTimeBeforePrtAcquisition() != other.getSleepTimeBeforePrtAcquisition()) {
            return false;
        }
        if (this.getCallerUid() != other.getCallerUid()) {
            return false;
        }
        String this$callerAppVersion = this.getCallerAppVersion();
        String other$callerAppVersion = other.getCallerAppVersion();
        if (this$callerAppVersion == null ? other$callerAppVersion != null : !this$callerAppVersion.equals(other$callerAppVersion)) {
            return false;
        }
        String this$brokerVersion = this.getBrokerVersion();
        String other$brokerVersion = other.getBrokerVersion();
        if (this$brokerVersion == null ? other$brokerVersion != null : !this$brokerVersion.equals(other$brokerVersion)) {
            return false;
        }
        String this$negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        String other$negotiatedBrokerProtocolVersion = other.getNegotiatedBrokerProtocolVersion();
        if (this$negotiatedBrokerProtocolVersion == null ? other$negotiatedBrokerProtocolVersion != null : !this$negotiatedBrokerProtocolVersion.equals(other$negotiatedBrokerProtocolVersion)) {
            return false;
        }
        BrokerRequestType this$requestType = this.getRequestType();
        BrokerRequestType other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !((Object)((Object)this$requestType)).equals((Object)other$requestType)) {
            return false;
        }
        String this$homeTenantId = this.getHomeTenantId();
        String other$homeTenantId = other.getHomeTenantId();
        if (this$homeTenantId == null ? other$homeTenantId != null : !this$homeTenantId.equals(other$homeTenantId)) {
            return false;
        }
        IBrokerAccount this$brokerAccount = this.getBrokerAccount();
        IBrokerAccount other$brokerAccount = other.getBrokerAccount();
        if (this$brokerAccount == null ? other$brokerAccount != null : !this$brokerAccount.equals(other$brokerAccount)) {
            return false;
        }
        String this$homeAccountId = this.getHomeAccountId();
        String other$homeAccountId = other.getHomeAccountId();
        if (this$homeAccountId == null ? other$homeAccountId != null : !this$homeAccountId.equals(other$homeAccountId)) {
            return false;
        }
        String this$localAccountId = this.getLocalAccountId();
        String other$localAccountId = other.getLocalAccountId();
        return !(this$localAccountId == null ? other$localAccountId != null : !this$localAccountId.equals(other$localAccountId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BrokerDeviceCodeFlowCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPKeyAuthHeaderAllowed() ? 79 : 97);
        result = result * 59 + this.getSleepTimeBeforePrtAcquisition();
        result = result * 59 + this.getCallerUid();
        String $callerAppVersion = this.getCallerAppVersion();
        result = result * 59 + ($callerAppVersion == null ? 43 : $callerAppVersion.hashCode());
        String $brokerVersion = this.getBrokerVersion();
        result = result * 59 + ($brokerVersion == null ? 43 : $brokerVersion.hashCode());
        String $negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        result = result * 59 + ($negotiatedBrokerProtocolVersion == null ? 43 : $negotiatedBrokerProtocolVersion.hashCode());
        BrokerRequestType $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : ((Object)((Object)$requestType)).hashCode());
        String $homeTenantId = this.getHomeTenantId();
        result = result * 59 + ($homeTenantId == null ? 43 : $homeTenantId.hashCode());
        IBrokerAccount $brokerAccount = this.getBrokerAccount();
        result = result * 59 + ($brokerAccount == null ? 43 : $brokerAccount.hashCode());
        String $homeAccountId = this.getHomeAccountId();
        result = result * 59 + ($homeAccountId == null ? 43 : $homeAccountId.hashCode());
        String $localAccountId = this.getLocalAccountId();
        result = result * 59 + ($localAccountId == null ? 43 : $localAccountId.hashCode());
        return result;
    }

    private static final class BrokerDeviceCodeFlowCommandParametersBuilderImpl
    extends BrokerDeviceCodeFlowCommandParametersBuilder<BrokerDeviceCodeFlowCommandParameters, BrokerDeviceCodeFlowCommandParametersBuilderImpl> {
        private BrokerDeviceCodeFlowCommandParametersBuilderImpl() {
        }

        @Override
        protected BrokerDeviceCodeFlowCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public BrokerDeviceCodeFlowCommandParameters build() {
            return new BrokerDeviceCodeFlowCommandParameters(this);
        }
    }

    public static abstract class BrokerDeviceCodeFlowCommandParametersBuilder<C extends BrokerDeviceCodeFlowCommandParameters, B extends BrokerDeviceCodeFlowCommandParametersBuilder<C, B>>
    extends DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder<C, B> {
        private String callerAppVersion;
        private String brokerVersion;
        private String negotiatedBrokerProtocolVersion;
        private boolean pKeyAuthHeaderAllowed;
        private BrokerRequestType requestType;
        private String homeTenantId;
        private IBrokerAccount brokerAccount;
        private String homeAccountId;
        private String localAccountId;
        private int sleepTimeBeforePrtAcquisition;
        private int callerUid;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrokerDeviceCodeFlowCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrokerDeviceCodeFlowCommandParameters instance, BrokerDeviceCodeFlowCommandParametersBuilder<?, ?> b) {
            b.callerAppVersion(instance.callerAppVersion);
            b.brokerVersion(instance.brokerVersion);
            b.negotiatedBrokerProtocolVersion(instance.negotiatedBrokerProtocolVersion);
            b.pKeyAuthHeaderAllowed(instance.pKeyAuthHeaderAllowed);
            b.requestType(instance.requestType);
            b.homeTenantId(instance.homeTenantId);
            b.brokerAccount(instance.brokerAccount);
            b.homeAccountId(instance.homeAccountId);
            b.localAccountId(instance.localAccountId);
            b.sleepTimeBeforePrtAcquisition(instance.sleepTimeBeforePrtAcquisition);
            b.callerUid(instance.callerUid);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B callerAppVersion(String callerAppVersion) {
            this.callerAppVersion = callerAppVersion;
            return (B)this.self();
        }

        public B brokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
            return (B)this.self();
        }

        public B negotiatedBrokerProtocolVersion(String negotiatedBrokerProtocolVersion) {
            this.negotiatedBrokerProtocolVersion = negotiatedBrokerProtocolVersion;
            return (B)this.self();
        }

        public B pKeyAuthHeaderAllowed(boolean pKeyAuthHeaderAllowed) {
            this.pKeyAuthHeaderAllowed = pKeyAuthHeaderAllowed;
            return (B)this.self();
        }

        public B requestType(BrokerRequestType requestType) {
            this.requestType = requestType;
            return (B)this.self();
        }

        public B homeTenantId(String homeTenantId) {
            this.homeTenantId = homeTenantId;
            return (B)this.self();
        }

        public B brokerAccount(IBrokerAccount brokerAccount) {
            this.brokerAccount = brokerAccount;
            return (B)this.self();
        }

        public B homeAccountId(String homeAccountId) {
            this.homeAccountId = homeAccountId;
            return (B)this.self();
        }

        public B localAccountId(String localAccountId) {
            this.localAccountId = localAccountId;
            return (B)this.self();
        }

        public B sleepTimeBeforePrtAcquisition(int sleepTimeBeforePrtAcquisition) {
            this.sleepTimeBeforePrtAcquisition = sleepTimeBeforePrtAcquisition;
            return (B)this.self();
        }

        public B callerUid(int callerUid) {
            this.callerUid = callerUid;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrokerDeviceCodeFlowCommandParameters.BrokerDeviceCodeFlowCommandParametersBuilder(super=" + super.toString() + ", callerAppVersion=" + this.callerAppVersion + ", brokerVersion=" + this.brokerVersion + ", negotiatedBrokerProtocolVersion=" + this.negotiatedBrokerProtocolVersion + ", pKeyAuthHeaderAllowed=" + this.pKeyAuthHeaderAllowed + ", requestType=" + (Object)((Object)this.requestType) + ", homeTenantId=" + this.homeTenantId + ", brokerAccount=" + this.brokerAccount + ", homeAccountId=" + this.homeAccountId + ", localAccountId=" + this.localAccountId + ", sleepTimeBeforePrtAcquisition=" + this.sleepTimeBeforePrtAcquisition + ", callerUid=" + this.callerUid + ")";
        }
    }
}

