/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.dto;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum CredentialType {
    RefreshToken,
    AccessToken,
    IdToken,
    V1IdToken,
    Password,
    Cookie,
    Certificate,
    AccessToken_With_AuthScheme,
    PrimaryRefreshToken;

    public static final Collection<CredentialType> ID_TOKEN_TYPES;

    public static Set<String> valueSet() {
        HashSet<String> strTypes = new HashSet<String>();
        for (CredentialType type : CredentialType.values()) {
            strTypes.add(type.name());
        }
        return Collections.unmodifiableSet(strTypes);
    }

    @Nullable
    public static CredentialType fromString(@Nullable String name) {
        for (CredentialType credentialType : CredentialType.values()) {
            if (!credentialType.name().equalsIgnoreCase(name)) continue;
            return credentialType;
        }
        return null;
    }

    static {
        ID_TOKEN_TYPES = Collections.unmodifiableList(Arrays.asList(IdToken, V1IdToken));
    }
}

