/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.eststelemetry;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.eststelemetry.FailedRequest;
import com.microsoft.identity.common.java.eststelemetry.IRequestTelemetry;
import com.microsoft.identity.common.java.eststelemetry.RequestTelemetry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class LastRequestTelemetry
extends RequestTelemetry {
    static final int FAILED_REQUEST_CAP = 100;
    @SerializedName(value="silent_successful_count")
    private int silentSuccessfulCount;
    @SerializedName(value="failed_requests")
    private List<FailedRequest> failedRequests;

    LastRequestTelemetry(@NonNull String schemaVersion) {
        super(schemaVersion);
        if (schemaVersion == null) {
            throw new NullPointerException("schemaVersion is marked non-null but is null");
        }
        this.silentSuccessfulCount = 0;
        this.failedRequests = new ArrayList<FailedRequest>();
    }

    List<FailedRequest> getFailedRequests() {
        return Collections.unmodifiableList(this.failedRequests);
    }

    @Override
    public String getHeaderStringForFields() {
        Map.Entry<String, String> headerSegments = this.getHeaderStringForFailedRequests();
        StringBuilder sb = new StringBuilder();
        sb.append(this.silentSuccessfulCount).append("|").append(headerSegments.getKey()).append("|").append(headerSegments.getValue());
        return sb.toString();
    }

    void incrementSilentSuccessCount() {
        ++this.silentSuccessfulCount;
    }

    void resetSilentSuccessCount() {
        this.silentSuccessfulCount = 0;
    }

    void appendFailedRequest(String apiId, String correlationId, String error) {
        this.appendFailedRequest(new FailedRequest(apiId, correlationId, error));
    }

    void appendFailedRequest(FailedRequest failedRequest) {
        if (this.failedRequests.size() >= 100) {
            int beginIndex = this.failedRequests.size() - 100 + 1;
            int endIndex = this.failedRequests.size();
            this.failedRequests = this.failedRequests.subList(beginIndex, endIndex);
        }
        this.failedRequests.add(failedRequest);
    }

    void wipeFailedRequestAndErrorForSubList(Collection<FailedRequest> failedRequestsToRemove) {
        if (failedRequestsToRemove != null) {
            this.failedRequests.removeAll(failedRequestsToRemove);
        }
    }

    @Override
    public IRequestTelemetry copySharedValues(@NonNull IRequestTelemetry requestTelemetry) {
        if (requestTelemetry == null) {
            throw new NullPointerException("requestTelemetry is marked non-null but is null");
        }
        if (requestTelemetry instanceof LastRequestTelemetry) {
            this.silentSuccessfulCount = ((LastRequestTelemetry)requestTelemetry).silentSuccessfulCount;
        }
        return super.copySharedValues(requestTelemetry);
    }

    private Map.Entry<String, String> getHeaderStringForFailedRequests() {
        if (this.failedRequests == null) {
            return new AbstractMap.SimpleEntry<String, String>("", "");
        }
        FailedRequest[] failedRequestsArray = this.failedRequests.toArray(new FailedRequest[0]);
        if (failedRequestsArray == null) {
            return new AbstractMap.SimpleEntry<String, String>("", "");
        }
        StringBuilder apiIdCorrelationIdSegmentBuilder = new StringBuilder();
        StringBuilder errorSegmentBuilder = new StringBuilder();
        for (int i = 0; i < failedRequestsArray.length; ++i) {
            FailedRequest failedRequest = failedRequestsArray[i];
            apiIdCorrelationIdSegmentBuilder.append(failedRequest.toApiIdCorrelationString());
            errorSegmentBuilder.append(failedRequest.toErrorCodeString());
            if (i == failedRequestsArray.length - 1) continue;
            apiIdCorrelationIdSegmentBuilder.append(',');
            errorSegmentBuilder.append(',');
        }
        return new AbstractMap.SimpleEntry<String, String>(apiIdCorrelationIdSegmentBuilder.toString(), errorSegmentBuilder.toString());
    }
}

