/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.authorities;

import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.CIAMAuthority;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Configuration;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Strategy;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2StrategyFactory;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/authorities/NativeAuthCIAMAuthority;", "Lcom/microsoft/identity/common/java/authorities/CIAMAuthority;", "authorityUrl", "", "clientId", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "createNativeAuthOAuth2Configuration", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;", "challengeTypes", "", "createOAuth2Strategy", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Strategy;", "parameters", "Lcom/microsoft/identity/common/java/providers/oauth2/OAuth2StrategyParameters;", "getChallengeTypesWithDefault", "Companion", "common4j"})
public final class NativeAuthCIAMAuthority
extends CIAMAuthority {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String authorityUrl;
    @NotNull
    private final String clientId;
    private static final String TAG = NativeAuthCIAMAuthority.class.getSimpleName();
    private static final boolean NATIVE_AUTH_USE_OPENID_CONFIGURATION = false;

    public NativeAuthCIAMAuthority(@NotNull String authorityUrl, @NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)authorityUrl, (String)"authorityUrl");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        super(authorityUrl);
        this.authorityUrl = authorityUrl;
        this.clientId = clientId;
        this.mAuthorityTypeString = "AAD_NA";
        this.mAuthorityUrlString = this.authorityUrl;
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    private final NativeAuthOAuth2Configuration createNativeAuthOAuth2Configuration(List<String> challengeTypes) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".createNativeAuthOAuth2Configuration");
        URL uRL = this.getAuthorityURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"this.authorityURL");
        return new NativeAuthOAuth2Configuration(uRL, this.clientId, this.getChallengeTypesWithDefault(challengeTypes), false, null, 24, null);
    }

    private final String getChallengeTypesWithDefault(List<String> challengeTypes) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".getChallengeTypesWithDefault");
        List list = challengeTypes;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        String challengeTypesWithDefault = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)list, (Iterable)CollectionsKt.listOf((Object)"redirect"))), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        Logger.info(TAG, "Challenge Types used = " + challengeTypesWithDefault);
        return challengeTypesWithDefault;
    }

    @Override
    @NotNull
    public NativeAuthOAuth2Strategy createOAuth2Strategy(@NotNull OAuth2StrategyParameters parameters) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        NativeAuthOAuth2Configuration config = this.createNativeAuthOAuth2Configuration(parameters.mChallengeTypes);
        parameters.setUsingOpenIdConfiguration(false);
        return NativeAuthOAuth2StrategyFactory.Companion.createStrategy(config, parameters);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/authorities/NativeAuthCIAMAuthority$Companion;", "", "()V", "NATIVE_AUTH_USE_OPENID_CONFIGURATION", "", "TAG", "", "kotlin.jvm.PlatformType", "getAuthorityFromAuthorityUrl", "Lcom/microsoft/identity/common/java/nativeauth/authorities/NativeAuthCIAMAuthority;", "authorityUrl", "clientId", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeAuthCIAMAuthority getAuthorityFromAuthorityUrl(@NotNull String authorityUrl, @NotNull String clientId) throws Exception {
            Intrinsics.checkNotNullParameter((Object)authorityUrl, (String)"authorityUrl");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Authority authority = Authority.getAuthorityFromAuthorityUrl(authorityUrl);
            if (authority instanceof NativeAuthCIAMAuthority) {
                return (NativeAuthCIAMAuthority)authority;
            }
            if (authority instanceof CIAMAuthority) {
                String string = ((CIAMAuthority)authority).getAuthorityUri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authority.authorityUri.toString()");
                return new NativeAuthCIAMAuthority(string, clientId);
            }
            throw new ClientException("native_auth_invalid_ciam_authority");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

