/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.commands.parameters;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.TerminalException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.BaseNativeAuthCommandParameters;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import java.io.IOException;
import java.net.URISyntaxException;
import lombok.NonNull;

public class AcquireTokenNoFixedScopesCommandParameters
extends BaseNativeAuthCommandParameters {
    private static final String TAG = AcquireTokenNoFixedScopesCommandParameters.class.getSimpleName();
    private static final Object sLock = new Object();
    private final IAccountRecord account;
    @NonNull
    private final AbstractAuthenticationScheme authenticationScheme;
    private final boolean forceRefresh;

    @Override
    @NonNull
    public String toUnsanitizedString() {
        return "AcquireTokenNoFixedScopesCommandParameters(account=" + this.account + ", authenticationScheme=" + this.getAuthenticationScheme() + ", forceRefresh=" + this.forceRefresh + ", authority=" + this.authority + ", challengeTypes=" + this.challengeType + ")";
    }

    @Override
    public boolean containsPii() {
        return !this.toString().equals(this.toUnsanitizedString());
    }

    @Override
    @NonNull
    public String toString() {
        return "AcquireTokenNoFixedScopesCommandParameters(authenticationScheme=" + this.getAuthenticationScheme() + ", forceRefresh=" + this.forceRefresh + ", authority=" + this.authority + ", challengeTypes=" + this.challengeType + ")";
    }

    public void validate() throws ArgumentException {
        String methodName = ":validate";
        Logger.verbose(TAG + ":validate", "Validating operation params...");
        if (null == this.authenticationScheme) {
            throw new ArgumentException("acquireTokenNoFixedScope", "authentication_scheme", "authentication scheme is undefined");
        }
        if (this.getAccount() == null) {
            Logger.warn(TAG, "The account set on silent operation parameters is NULL.");
        }
    }

    private boolean authorityMatchesAccountEnvironment() {
        String errorCode;
        Exception cause;
        String methodName = ":authorityMatchesAccountEnvironment";
        try {
            AzureActiveDirectoryCloud cloud;
            if (!AzureActiveDirectory.isInitialized()) {
                AcquireTokenNoFixedScopesCommandParameters.performCloudDiscovery();
            }
            return (cloud = AzureActiveDirectory.getAzureActiveDirectoryCloudFromHostName(this.getAccount().getEnvironment())) != null && cloud.getPreferredNetworkHostName().equals(this.getAuthority().getAuthorityURL().getAuthority());
        }
        catch (IOException e) {
            cause = e;
            errorCode = "io_error";
        }
        catch (URISyntaxException e) {
            cause = e;
            errorCode = "malformed_url";
        }
        Logger.error(TAG + ":authorityMatchesAccountEnvironment", "Unable to perform cloud discovery", cause);
        throw new TerminalException("Unable to perform cloud discovery in order to validate request authority", cause, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCloudDiscovery() throws IOException, URISyntaxException {
        String methodName = ":performCloudDiscovery";
        Logger.verbose(TAG + ":performCloudDiscovery", "Performing cloud discovery...");
        Object object = sLock;
        synchronized (object) {
            AzureActiveDirectory.performCloudDiscovery();
        }
    }

    protected AcquireTokenNoFixedScopesCommandParameters(AcquireTokenNoFixedScopesCommandParametersBuilder<?, ?> b) {
        super((BaseNativeAuthCommandParameters.BaseNativeAuthCommandParametersBuilder<?, ?>)b);
        this.account = ((AcquireTokenNoFixedScopesCommandParametersBuilder)b).account;
        this.authenticationScheme = ((AcquireTokenNoFixedScopesCommandParametersBuilder)b).authenticationScheme;
        if (this.authenticationScheme == null) {
            throw new NullPointerException("authenticationScheme is marked non-null but is null");
        }
        this.forceRefresh = ((AcquireTokenNoFixedScopesCommandParametersBuilder)b).forceRefresh;
    }

    public static AcquireTokenNoFixedScopesCommandParametersBuilder<?, ?> builder() {
        return new AcquireTokenNoFixedScopesCommandParametersBuilderImpl();
    }

    public AcquireTokenNoFixedScopesCommandParametersBuilder<?, ?> toBuilder() {
        return new AcquireTokenNoFixedScopesCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    public IAccountRecord getAccount() {
        return this.account;
    }

    @NonNull
    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public boolean isForceRefresh() {
        return this.forceRefresh;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcquireTokenNoFixedScopesCommandParameters)) {
            return false;
        }
        AcquireTokenNoFixedScopesCommandParameters other = (AcquireTokenNoFixedScopesCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isForceRefresh() != other.isForceRefresh()) {
            return false;
        }
        IAccountRecord this$account = this.getAccount();
        IAccountRecord other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        AbstractAuthenticationScheme this$authenticationScheme = this.getAuthenticationScheme();
        AbstractAuthenticationScheme other$authenticationScheme = other.getAuthenticationScheme();
        return !(this$authenticationScheme == null ? other$authenticationScheme != null : !((Object)this$authenticationScheme).equals(other$authenticationScheme));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AcquireTokenNoFixedScopesCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isForceRefresh() ? 79 : 97);
        IAccountRecord $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        AbstractAuthenticationScheme $authenticationScheme = this.getAuthenticationScheme();
        result = result * 59 + ($authenticationScheme == null ? 43 : ((Object)$authenticationScheme).hashCode());
        return result;
    }

    private static final class AcquireTokenNoFixedScopesCommandParametersBuilderImpl
    extends AcquireTokenNoFixedScopesCommandParametersBuilder<AcquireTokenNoFixedScopesCommandParameters, AcquireTokenNoFixedScopesCommandParametersBuilderImpl> {
        private AcquireTokenNoFixedScopesCommandParametersBuilderImpl() {
        }

        @Override
        protected AcquireTokenNoFixedScopesCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public AcquireTokenNoFixedScopesCommandParameters build() {
            return new AcquireTokenNoFixedScopesCommandParameters(this);
        }
    }

    public static abstract class AcquireTokenNoFixedScopesCommandParametersBuilder<C extends AcquireTokenNoFixedScopesCommandParameters, B extends AcquireTokenNoFixedScopesCommandParametersBuilder<C, B>>
    extends BaseNativeAuthCommandParameters.BaseNativeAuthCommandParametersBuilder<C, B> {
        private IAccountRecord account;
        private AbstractAuthenticationScheme authenticationScheme;
        private boolean forceRefresh;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AcquireTokenNoFixedScopesCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AcquireTokenNoFixedScopesCommandParameters instance, AcquireTokenNoFixedScopesCommandParametersBuilder<?, ?> b) {
            b.account(instance.account);
            b.authenticationScheme(instance.authenticationScheme);
            b.forceRefresh(instance.forceRefresh);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B account(IAccountRecord account) {
            this.account = account;
            return (B)this.self();
        }

        public B authenticationScheme(@NonNull AbstractAuthenticationScheme authenticationScheme) {
            if (authenticationScheme == null) {
                throw new NullPointerException("authenticationScheme is marked non-null but is null");
            }
            this.authenticationScheme = authenticationScheme;
            return (B)this.self();
        }

        public B forceRefresh(boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder(super=" + super.toString() + ", account=" + this.account + ", authenticationScheme=" + this.authenticationScheme + ", forceRefresh=" + this.forceRefresh + ")";
        }
    }
}

