/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.commands.parameters;

import com.microsoft.identity.common.java.nativeauth.commands.parameters.BaseSignInTokenCommandParameters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.annotation.Nullable;
import lombok.NonNull;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class SignInStartCommandParameters
extends BaseSignInTokenCommandParameters {
    private static final String TAG = SignInStartCommandParameters.class.getSimpleName();
    @NonNull
    public final String username;
    @Nullable
    public final char[] password;

    @Override
    @NonNull
    public String toUnsanitizedString() {
        return "SignInStartCommandParameters(scopes=" + this.scopes + ", authenticationScheme=" + this.getAuthenticationScheme() + ", username=" + this.username + ", authority=" + this.authority + ", challengeTypes=" + this.challengeType + ")";
    }

    @Override
    public boolean containsPii() {
        return !this.toString().equals(this.toUnsanitizedString());
    }

    @Override
    @NonNull
    public String toString() {
        return "SignInStartCommandParameters(scopes=" + this.scopes + ", authenticationScheme=" + this.getAuthenticationScheme() + ", authority=" + this.authority + ", challengeTypes=" + this.challengeType + ")";
    }

    protected SignInStartCommandParameters(SignInStartCommandParametersBuilder<?, ?> b) {
        super((BaseSignInTokenCommandParameters.BaseSignInTokenCommandParametersBuilder<?, ?>)b);
        this.username = ((SignInStartCommandParametersBuilder)b).username;
        if (this.username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.password = ((SignInStartCommandParametersBuilder)b).password;
    }

    public static SignInStartCommandParametersBuilder<?, ?> builder() {
        return new SignInStartCommandParametersBuilderImpl();
    }

    public SignInStartCommandParametersBuilder<?, ?> toBuilder() {
        return new SignInStartCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignInStartCommandParameters)) {
            return false;
        }
        SignInStartCommandParameters other = (SignInStartCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        return Arrays.equals(this.getPassword(), other.getPassword());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SignInStartCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        return result;
    }

    private static final class SignInStartCommandParametersBuilderImpl
    extends SignInStartCommandParametersBuilder<SignInStartCommandParameters, SignInStartCommandParametersBuilderImpl> {
        private SignInStartCommandParametersBuilderImpl() {
        }

        @Override
        protected SignInStartCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public SignInStartCommandParameters build() {
            return new SignInStartCommandParameters(this);
        }
    }

    public static abstract class SignInStartCommandParametersBuilder<C extends SignInStartCommandParameters, B extends SignInStartCommandParametersBuilder<C, B>>
    extends BaseSignInTokenCommandParameters.BaseSignInTokenCommandParametersBuilder<C, B> {
        private String username;
        private char[] password;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SignInStartCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SignInStartCommandParameters instance, SignInStartCommandParametersBuilder<?, ?> b) {
            b.username(instance.username);
            b.password(instance.password);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return (B)this.self();
        }

        public B password(@Nullable char[] password) {
            this.password = password;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SignInStartCommandParameters.SignInStartCommandParametersBuilder(super=" + super.toString() + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ")";
        }
    }
}

