/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.commands.parameters;

import com.microsoft.identity.common.java.nativeauth.commands.parameters.BaseNativeAuthCommandParameters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class SignUpStartCommandParameters
extends BaseNativeAuthCommandParameters {
    private static final String TAG = SignUpStartCommandParameters.class.getSimpleName();
    @NonNull
    public final String username;
    @Nullable
    public final Map<String, String> userAttributes;
    @Nullable
    public final char[] password;

    @Override
    @NonNull
    public String toUnsanitizedString() {
        return "SignUpStartCommandParameters(username=" + this.username + ", userAttributes=" + this.userAttributes + ", authority=" + this.authority + ", challengeTypes=" + this.challengeType + ")";
    }

    @Override
    public boolean containsPii() {
        return !this.toString().equals(this.toUnsanitizedString());
    }

    @Override
    @NonNull
    public String toString() {
        return "SignUpStartCommandParameters(authority=" + this.authority + ", challengeTypes=" + this.challengeType + ")";
    }

    protected SignUpStartCommandParameters(SignUpStartCommandParametersBuilder<?, ?> b) {
        super((BaseNativeAuthCommandParameters.BaseNativeAuthCommandParametersBuilder<?, ?>)b);
        this.username = ((SignUpStartCommandParametersBuilder)b).username;
        if (this.username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.userAttributes = ((SignUpStartCommandParametersBuilder)b).userAttributes;
        this.password = ((SignUpStartCommandParametersBuilder)b).password;
    }

    public static SignUpStartCommandParametersBuilder<?, ?> builder() {
        return new SignUpStartCommandParametersBuilderImpl();
    }

    public SignUpStartCommandParametersBuilder<?, ?> toBuilder() {
        return new SignUpStartCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public Map<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    @Nullable
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignUpStartCommandParameters)) {
            return false;
        }
        SignUpStartCommandParameters other = (SignUpStartCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        return Arrays.equals(this.getPassword(), other.getPassword());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SignUpStartCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        return result;
    }

    private static final class SignUpStartCommandParametersBuilderImpl
    extends SignUpStartCommandParametersBuilder<SignUpStartCommandParameters, SignUpStartCommandParametersBuilderImpl> {
        private SignUpStartCommandParametersBuilderImpl() {
        }

        @Override
        protected SignUpStartCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public SignUpStartCommandParameters build() {
            return new SignUpStartCommandParameters(this);
        }
    }

    public static abstract class SignUpStartCommandParametersBuilder<C extends SignUpStartCommandParameters, B extends SignUpStartCommandParametersBuilder<C, B>>
    extends BaseNativeAuthCommandParameters.BaseNativeAuthCommandParametersBuilder<C, B> {
        private String username;
        private Map<String, String> userAttributes;
        private char[] password;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SignUpStartCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SignUpStartCommandParameters instance, SignUpStartCommandParametersBuilder<?, ?> b) {
            b.username(instance.username);
            b.userAttributes(instance.userAttributes);
            b.password(instance.password);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return (B)this.self();
        }

        public B userAttributes(@Nullable Map<String, String> userAttributes) {
            this.userAttributes = userAttributes;
            return (B)this.self();
        }

        public B password(@Nullable char[] password) {
            this.password = password;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SignUpStartCommandParameters.SignUpStartCommandParametersBuilder(super=" + super.toString() + ", username=" + this.username + ", userAttributes=" + this.userAttributes + ", password=" + Arrays.toString(this.password) + ")";
        }
    }
}

