/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.BuildValues;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.util.UrlUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001a\u0018\u0000 !2\u00020\u0001:\u0001!B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0003R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;", "Lcom/microsoft/identity/common/java/providers/microsoft/microsoftsts/MicrosoftStsOAuth2Configuration;", "authorityUrl", "Ljava/net/URL;", "clientId", "", "challengeType", "useMockApiForNativeAuth", "", "MOCK_API_URL_WITH_NATIVE_AUTH_TENANT", "(Ljava/net/URL;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "TAG", "kotlin.jvm.PlatformType", "getChallengeType", "()Ljava/lang/String;", "getClientId", "getUseMockApiForNativeAuth", "()Z", "getAuthorityUrl", "getEndpointUrlFromRootAndTenantAndSuffix", "root", "endpointSuffix", "getResetPasswordChallengeEndpoint", "getResetPasswordContinueEndpoint", "getResetPasswordPollCompletionEndpoint", "getResetPasswordStartEndpoint", "getResetPasswordSubmitEndpoint", "getSignInChallengeEndpoint", "getSignInInitiateEndpoint", "getSignInTokenEndpoint", "getSignUpChallengeEndpoint", "getSignUpContinueEndpoint", "getSignUpStartEndpoint", "Companion", "common4j"})
public final class NativeAuthOAuth2Configuration
extends MicrosoftStsOAuth2Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL authorityUrl;
    @NotNull
    private final String clientId;
    @NotNull
    private final String challengeType;
    private final boolean useMockApiForNativeAuth;
    @NotNull
    private final String MOCK_API_URL_WITH_NATIVE_AUTH_TENANT;
    private final String TAG;
    @NotNull
    private static final String SIGNUP_START_ENDPOINT_SUFFIX = "/signup/v1.0/start";
    @NotNull
    private static final String SIGNUP_CHALLENGE_ENDPOINT_SUFFIX = "/signup/v1.0/challenge";
    @NotNull
    private static final String SIGNUP_CONTINUE_ENDPOINT_SUFFIX = "/signup/v1.0/continue";
    @NotNull
    private static final String RESET_PASSWORD_START_ENDPOINT_SUFFIX = "/resetpassword/v1.0/start";
    @NotNull
    private static final String RESET_PASSWORD_CHALLENGE_ENDPOINT_SUFFIX = "/resetpassword/v1.0/challenge";
    @NotNull
    private static final String RESET_PASSWORD_CONTINUE_ENDPOINT_SUFFIX = "/resetpassword/v1.0/continue";
    @NotNull
    private static final String RESET_PASSWORD_SUBMIT_ENDPOINT_SUFFIX = "/resetpassword/v1.0/submit";
    @NotNull
    private static final String RESET_PASSWORD_COMPLETE_ENDPOINT_SUFFIX = "/resetpassword/v1.0/poll_completion";
    @NotNull
    private static final String SIGN_IN_INITIATE_ENDPOINT_SUFFIX = "/oauth2/v2.0/initiate";
    @NotNull
    private static final String SIGN_IN_CHALLENGE_ENDPOINT_SUFFIX = "/oauth2/v2.0/challenge";
    @NotNull
    private static final String SIGN_IN_TOKEN_ENDPOINT_SUFFIX = "/oauth2/v2.0/token";

    public NativeAuthOAuth2Configuration(@NotNull URL authorityUrl, @NotNull String clientId, @NotNull String challengeType, boolean useMockApiForNativeAuth, @NotNull String MOCK_API_URL_WITH_NATIVE_AUTH_TENANT) {
        Intrinsics.checkNotNullParameter((Object)authorityUrl, (String)"authorityUrl");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)challengeType, (String)"challengeType");
        Intrinsics.checkNotNullParameter((Object)MOCK_API_URL_WITH_NATIVE_AUTH_TENANT, (String)"MOCK_API_URL_WITH_NATIVE_AUTH_TENANT");
        this.authorityUrl = authorityUrl;
        this.clientId = clientId;
        this.challengeType = challengeType;
        this.useMockApiForNativeAuth = useMockApiForNativeAuth;
        this.MOCK_API_URL_WITH_NATIVE_AUTH_TENANT = MOCK_API_URL_WITH_NATIVE_AUTH_TENANT;
        this.TAG = NativeAuthOAuth2Configuration.class.getSimpleName();
    }

    public /* synthetic */ NativeAuthOAuth2Configuration(URL uRL, String string, String string2, boolean bl, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Boolean bl2 = BuildValues.shouldUseMockApiForNativeAuth();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"shouldUseMockApiForNativeAuth()");
            bl = bl2;
        }
        if ((n & 0x10) != 0) {
            string3 = BuildValues.getMockApiUrl() + "lumonconvergedps.onmicrosoft.com";
        }
        this(uRL, string, string2, bl, string3);
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    @NotNull
    public final String getChallengeType() {
        return this.challengeType;
    }

    public final boolean getUseMockApiForNativeAuth() {
        return this.useMockApiForNativeAuth;
    }

    @Override
    @NotNull
    public URL getAuthorityUrl() {
        return this.useMockApiForNativeAuth ? new URL(this.MOCK_API_URL_WITH_NATIVE_AUTH_TENANT) : this.authorityUrl;
    }

    @NotNull
    public final URL getSignUpStartEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), SIGNUP_START_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getSignUpChallengeEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), SIGNUP_CHALLENGE_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getSignUpContinueEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), SIGNUP_CONTINUE_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getResetPasswordStartEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), RESET_PASSWORD_START_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getResetPasswordChallengeEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), RESET_PASSWORD_CHALLENGE_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getResetPasswordContinueEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), RESET_PASSWORD_CONTINUE_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getResetPasswordSubmitEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), RESET_PASSWORD_SUBMIT_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getResetPasswordPollCompletionEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), RESET_PASSWORD_COMPLETE_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getSignInInitiateEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), SIGN_IN_INITIATE_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getSignInChallengeEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), SIGN_IN_CHALLENGE_ENDPOINT_SUFFIX);
    }

    @NotNull
    public final URL getSignInTokenEndpoint() {
        return this.getEndpointUrlFromRootAndTenantAndSuffix(this.getAuthorityUrl(), SIGN_IN_TOKEN_ENDPOINT_SUFFIX);
    }

    private final URL getEndpointUrlFromRootAndTenantAndSuffix(URL root, String endpointSuffix) {
        URL uRL;
        try {
            String string = BuildValues.getDC();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDC()");
            uRL = ((CharSequence)string).length() > 0 ? UrlUtil.appendPathAndQueryToURL(root, endpointSuffix, "dc=" + BuildValues.getDC()) : UrlUtil.appendPathToURL(root, endpointSuffix);
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"{\n            if (BuildV\u2026)\n            }\n        }");
        }
        catch (URISyntaxException e) {
            Logger.error(this.TAG, "appendPathToURL failed", e);
            throw e;
        }
        catch (MalformedURLException e) {
            Logger.error(this.TAG, "appendPathToURL failed", e);
            throw e;
        }
        return uRL;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration$Companion;", "", "()V", "RESET_PASSWORD_CHALLENGE_ENDPOINT_SUFFIX", "", "RESET_PASSWORD_COMPLETE_ENDPOINT_SUFFIX", "RESET_PASSWORD_CONTINUE_ENDPOINT_SUFFIX", "RESET_PASSWORD_START_ENDPOINT_SUFFIX", "RESET_PASSWORD_SUBMIT_ENDPOINT_SUFFIX", "SIGNUP_CHALLENGE_ENDPOINT_SUFFIX", "SIGNUP_CONTINUE_ENDPOINT_SUFFIX", "SIGNUP_START_ENDPOINT_SUFFIX", "SIGN_IN_CHALLENGE_ENDPOINT_SUFFIX", "SIGN_IN_INITIATE_ENDPOINT_SUFFIX", "SIGN_IN_TOKEN_ENDPOINT_SUFFIX", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

