/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.interactors;

import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInWithContinuationTokenCommandParameters;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthRequestProvider;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthResponseHandler;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInInitiateRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInTokenRequest;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInChallengeApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInTokenApiResult;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0019H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u001eJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u001fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/SignInInteractor;", "", "httpClient", "Lcom/microsoft/identity/common/java/net/UrlConnectionHttpClient;", "nativeAuthRequestProvider", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;", "nativeAuthResponseHandler", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthResponseHandler;", "(Lcom/microsoft/identity/common/java/net/UrlConnectionHttpClient;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthResponseHandler;)V", "TAG", "", "performContinuationTokenTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResult;", "parameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInWithContinuationTokenCommandParameters;", "performGetToken", "requestCorrelationId", "request", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInTokenRequest;", "performOOBTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitCodeCommandParameters;", "performPasswordTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitPasswordCommandParameters;", "performSignInChallenge", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInChallengeApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInChallengeRequest;", "continuationToken", "correlationId", "performSignInInitiate", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInStartCommandParameters;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInInitiateRequest;", "common4j"})
public final class SignInInteractor {
    @NotNull
    private final UrlConnectionHttpClient httpClient;
    @NotNull
    private final NativeAuthRequestProvider nativeAuthRequestProvider;
    @NotNull
    private final NativeAuthResponseHandler nativeAuthResponseHandler;
    @NotNull
    private final String TAG;

    public SignInInteractor(@NotNull UrlConnectionHttpClient httpClient, @NotNull NativeAuthRequestProvider nativeAuthRequestProvider, @NotNull NativeAuthResponseHandler nativeAuthResponseHandler) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)nativeAuthRequestProvider, (String)"nativeAuthRequestProvider");
        Intrinsics.checkNotNullParameter((Object)nativeAuthResponseHandler, (String)"nativeAuthResponseHandler");
        this.httpClient = httpClient;
        this.nativeAuthRequestProvider = nativeAuthRequestProvider;
        this.nativeAuthResponseHandler = nativeAuthResponseHandler;
        String string = SignInInteractor.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SignInInteractor::class.java.simpleName");
        this.TAG = string;
    }

    @NotNull
    public final SignInInitiateApiResult performSignInInitiate(@NotNull SignInStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, parameters.getCorrelationId(), this.TAG + ".performSignInInitiate(parameters: SignInStartCommandParameters)");
        SignInInitiateRequest request = this.nativeAuthRequestProvider.createSignInInitiateRequest$common4j(parameters);
        Logger.infoWithObject(this.TAG + ".performSignInInitiate", parameters.getCorrelationId(), "request = ", request);
        String string = parameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.getCorrelationId()");
        return this.performSignInInitiate(string, request);
    }

    private final SignInInitiateApiResult performSignInInitiate(String requestCorrelationId, SignInInitiateRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, null, this.TAG + ".performSignInInitiate");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        SignInInitiateApiResponse rawApiResponse = this.nativeAuthResponseHandler.getSignInInitiateResultFromHttpResponse(requestCorrelationId, response);
        Logger.infoWithObject(this.TAG + ".rawResponseToSignInInitiateApiResult", rawApiResponse.getCorrelationId(), "rawApiResponse = ", rawApiResponse);
        SignInInitiateApiResult result = rawApiResponse.toResult();
        Logger.infoWithObject(this.TAG + ".rawResponseToSignInInitiateApiResult", result.getCorrelationId(), "result = ", result);
        return result;
    }

    @NotNull
    public final SignInChallengeApiResult performSignInChallenge(@NotNull String continuationToken, @NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)continuationToken, (String)"continuationToken");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        LogSession.Companion.logMethodCall(this.TAG, correlationId, this.TAG + ".performSignInChallenge(continuationToken: String)");
        SignInChallengeRequest request = this.nativeAuthRequestProvider.createSignInChallengeRequest$common4j(continuationToken, correlationId);
        Logger.infoWithObject(this.TAG + ".performSignInChallenge", correlationId, "request = ", request);
        return this.performSignInChallenge(correlationId, request);
    }

    private final SignInChallengeApiResult performSignInChallenge(String requestCorrelationId, SignInChallengeRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, null, this.TAG + ".performSignInChallenge");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        SignInChallengeApiResponse rawApiResponse = this.nativeAuthResponseHandler.getSignInChallengeResultFromHttpResponse(requestCorrelationId, response);
        Logger.infoWithObject(this.TAG + ".rawResponseToSignInChallengeApiResult", rawApiResponse.getCorrelationId(), "rawApiResponse = ", rawApiResponse);
        SignInChallengeApiResult result = rawApiResponse.toResult();
        Logger.infoWithObject(this.TAG + ".rawResponseToSignInChallengeApiResult", result.getCorrelationId(), "result = ", result);
        return result;
    }

    @NotNull
    public final SignInTokenApiResult performOOBTokenRequest(@NotNull SignInSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, parameters.getCorrelationId(), this.TAG + ".performOOBTokenRequest(parameters: SignInSubmitCodeCommandParameters)");
        SignInTokenRequest request = this.nativeAuthRequestProvider.createOOBTokenRequest$common4j(parameters);
        Logger.infoWithObject(this.TAG + ".performOOBTokenRequest", parameters.getCorrelationId(), "request = ", request);
        String string = parameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.getCorrelationId()");
        return this.performGetToken(string, request);
    }

    @NotNull
    public final SignInTokenApiResult performContinuationTokenTokenRequest(@NotNull SignInWithContinuationTokenCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, parameters.getCorrelationId(), this.TAG + ".performContinuationTokenTokenRequest(parameters: SignInWithContinuationTokenCommandParameters)");
        SignInTokenRequest request = this.nativeAuthRequestProvider.createContinuationTokenTokenRequest$common4j(parameters);
        Logger.infoWithObject(this.TAG + ".performContinuationTokenTokenRequest", parameters.getCorrelationId(), "request = ", request);
        String string = parameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.getCorrelationId()");
        return this.performGetToken(string, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignInTokenApiResult performPasswordTokenRequest(@NotNull SignInSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, parameters.getCorrelationId(), this.TAG + ".performPasswordTokenRequest");
        SignInTokenRequest request = this.nativeAuthRequestProvider.createPasswordTokenRequest$common4j(parameters);
        Logger.infoWithObject(this.TAG + ".performPasswordTokenRequest", parameters.getCorrelationId(), "request = ", request);
        try {
            String string = parameters.getCorrelationId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.getCorrelationId()");
            SignInTokenApiResult signInTokenApiResult = this.performGetToken(string, request);
            return signInTokenApiResult;
        }
        finally {
            StringUtil.overwriteWithNull(request.getParameters().getPassword());
        }
    }

    private final SignInTokenApiResult performGetToken(String requestCorrelationId, SignInTokenRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, requestCorrelationId, this.TAG + ".performGetToken");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        SignInTokenApiResult result = this.nativeAuthResponseHandler.getSignInTokenApiResultFromHttpResponse(requestCorrelationId, response);
        Logger.infoWithObject(this.TAG + ".rawResponseToSignInTokenApiResult", result.getCorrelationId(), "result = ", result);
        return result;
    }
}

