/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordSubmitApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u0005H\u0016R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0018\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0018\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "pollInterval", "error", "errorDescription", "errorUri", "subError", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getContinuationToken", "()Ljava/lang/String;", "getError", "getErrorDescription", "getErrorUri", "getPollInterval", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getStatusCode", "()I", "setStatusCode", "(I)V", "getSubError", "clampPollInterval", "pollIntervalInSeconds", "(Ljava/lang/Integer;)I", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class ResetPasswordSubmitApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @Expose
    @SerializedName(value="poll_interval")
    @Nullable
    private final Integer pollInterval;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="error_uri")
    @Nullable
    private final String errorUri;
    @SerializedName(value="suberror")
    @Nullable
    private final String subError;
    private static final String TAG = ResetPasswordSubmitApiResponse.class.getSimpleName();
    private static final int MINIMUM_POLL_COMPLETION_INTERVAL_IN_SECONDS = 1;
    private static final int MAXIMUM_POLL_COMPLETION_INTERVAL_IN_SECONDS = 15;
    private static final int DEFAULT_POLL_COMPLETION_INTERVAL_IN_SECONDS = 2;

    public ResetPasswordSubmitApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable Integer pollInterval, @Nullable String error, @Nullable String errorDescription, @Nullable String errorUri, @Nullable String subError) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.pollInterval = pollInterval;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
        this.subError = subError;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final Integer getPollInterval() {
        return this.pollInterval;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getErrorUri() {
        return this.errorUri;
    }

    @Nullable
    public final String getSubError() {
        return this.subError;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        return "ResetPasswordSubmitApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId() + ", pollInterval=" + this.pollInterval + ", error=" + this.error + ", errorUri=" + this.errorUri + ", errorDescription=" + this.errorDescription + ", subError=" + this.subError + ')';
    }

    @Override
    @NotNull
    public String toString() {
        return "ResetPasswordSubmitApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final ResetPasswordSubmitApiResult toResult() {
        ResetPasswordSubmitApiResult resetPasswordSubmitApiResult;
        switch (this.getStatusCode()) {
            case 400: {
                ResetPasswordSubmitApiResult resetPasswordSubmitApiResult2;
                if (ApiErrorResponseUtilKt.isPasswordBanned(this.subError) || ApiErrorResponseUtilKt.isPasswordTooShort(this.subError) || ApiErrorResponseUtilKt.isPasswordTooLong(this.subError) || ApiErrorResponseUtilKt.isPasswordRecentlyUsed(this.subError) || ApiErrorResponseUtilKt.isPasswordTooWeak(this.subError) || ApiErrorResponseUtilKt.isPasswordInvalid(this.subError)) {
                    String string;
                    String string2;
                    String string3;
                    String string4;
                    String string5 = this.error;
                    if (string5 == null) {
                        string5 = string4 = "";
                    }
                    if ((string3 = this.errorDescription) == null) {
                        string3 = string2 = "";
                    }
                    if ((string = this.subError) == null) {
                        string = "";
                    }
                    String string6 = string;
                    String string7 = this.getCorrelationId();
                    resetPasswordSubmitApiResult2 = new ResetPasswordSubmitApiResult.PasswordInvalid(string7, string4, string2, string6);
                } else if (ApiErrorResponseUtilKt.isExpiredToken(this.error)) {
                    String string;
                    String string8;
                    String string9 = this.error;
                    if (string9 == null) {
                        string9 = string8 = "";
                    }
                    if ((string = this.errorDescription) == null) {
                        string = "";
                    }
                    String string10 = string;
                    String string11 = this.getCorrelationId();
                    resetPasswordSubmitApiResult2 = new ResetPasswordSubmitApiResult.ExpiredToken(string11, string8, string10);
                } else {
                    String string;
                    String string12;
                    String string13 = this.error;
                    if (string13 == null) {
                        string13 = string12 = "";
                    }
                    if ((string = this.errorDescription) == null) {
                        string = "";
                    }
                    String string14 = string;
                    String string15 = this.getCorrelationId();
                    resetPasswordSubmitApiResult2 = new ResetPasswordSubmitApiResult.UnknownError(string15, string12, string14);
                }
                return resetPasswordSubmitApiResult2;
            }
            case 200: {
                String string = this.continuationToken;
                if (string == null) {
                    String string16 = this.getCorrelationId();
                    return new ResetPasswordSubmitApiResult.UnknownError(string16, "invalid_state", "ResetPassword /submit successful, but did not return a flow token");
                }
                resetPasswordSubmitApiResult = new ResetPasswordSubmitApiResult.SubmitSuccess(string, this.clampPollInterval(this.pollInterval), this.getCorrelationId());
                break;
            }
            default: {
                String string;
                String string17;
                String string18 = this.error;
                if (string18 == null) {
                    string18 = string17 = "";
                }
                if ((string = this.errorDescription) == null) {
                    string = "";
                }
                String string19 = string;
                String string20 = this.getCorrelationId();
                resetPasswordSubmitApiResult = new ResetPasswordSubmitApiResult.UnknownError(string20, string17, string19);
            }
        }
        return resetPasswordSubmitApiResult;
    }

    private final int clampPollInterval(Integer pollIntervalInSeconds) {
        if (pollIntervalInSeconds == null || pollIntervalInSeconds < 1 || pollIntervalInSeconds > 15) {
            return 2;
        }
        return pollIntervalInSeconds;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResponse$Companion;", "", "()V", "DEFAULT_POLL_COMPLETION_INTERVAL_IN_SECONDS", "", "MAXIMUM_POLL_COMPLETION_INTERVAL_IN_SECONDS", "MINIMUM_POLL_COMPLETION_INTERVAL_IN_SECONDS", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

