/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signup;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpStartApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u008f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\u0007\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\b\u0012\u001a\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0018\u0010\f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R*\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R*\u0010\u0007\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "unverifiedAttributes", "", "", "invalidAttributes", "challengeType", "error", "errorCodes", "errorDescription", "subError", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getChallengeType", "()Ljava/lang/String;", "getContinuationToken", "getError", "getErrorCodes", "()Ljava/util/List;", "getErrorDescription", "getInvalidAttributes", "getStatusCode", "()I", "setStatusCode", "(I)V", "getSubError", "getUnverifiedAttributes", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class SignUpStartApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @Expose
    @SerializedName(value="unverified_attributes")
    @Nullable
    private final List<Map<String, String>> unverifiedAttributes;
    @Expose
    @SerializedName(value="invalid_attributes")
    @Nullable
    private final List<Map<String, String>> invalidAttributes;
    @Expose
    @SerializedName(value="challenge_type")
    @Nullable
    private final String challengeType;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_codes")
    @Nullable
    private final List<Integer> errorCodes;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="suberror")
    @Nullable
    private final String subError;
    private static final String TAG = SignUpStartApiResponse.class.getSimpleName();

    public SignUpStartApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable List<? extends Map<String, String>> unverifiedAttributes, @Nullable List<? extends Map<String, String>> invalidAttributes, @Nullable String challengeType, @Nullable String error, @Nullable List<Integer> errorCodes, @Nullable String errorDescription, @Nullable String subError) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.unverifiedAttributes = unverifiedAttributes;
        this.invalidAttributes = invalidAttributes;
        this.challengeType = challengeType;
        this.error = error;
        this.errorCodes = errorCodes;
        this.errorDescription = errorDescription;
        this.subError = subError;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final List<Map<String, String>> getUnverifiedAttributes() {
        return this.unverifiedAttributes;
    }

    @Nullable
    public final List<Map<String, String>> getInvalidAttributes() {
        return this.invalidAttributes;
    }

    @Nullable
    public final String getChallengeType() {
        return this.challengeType;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getSubError() {
        return this.subError;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        return "SignUpStartApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId() + ", challengeType=" + this.challengeType + "error=" + this.error + ", errorCodes=" + this.errorCodes + ", errorDescription=" + this.errorDescription + ", subError=" + this.subError + ')';
    }

    @Override
    @NotNull
    public String toString() {
        return "SignUpContinueApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final SignUpStartApiResult toResult() {
        SignUpStartApiResult signUpStartApiResult;
        switch (this.getStatusCode()) {
            case 400: {
                ApiResult apiResult;
                if (ApiErrorResponseUtilKt.isUserAlreadyExists(this.error)) {
                    String string;
                    String string2 = this.error;
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = this.errorDescription) == null) {
                        string = "";
                    }
                    apiResult = new SignUpStartApiResult.UsernameAlreadyExists(string2, string, this.getCorrelationId());
                } else {
                    List<Integer> list = this.errorCodes;
                    boolean bl = ApiErrorResponseUtilKt.isInvalidParameter(list != null ? list.get(0) : null);
                    String string = this.errorDescription;
                    boolean bl2 = string != null ? ApiErrorResponseUtilKt.isInvalidUsername(string) : false;
                    if (bl & bl2) {
                        String string3;
                        String string4 = this.error;
                        if (string4 == null) {
                            string4 = "";
                        }
                        if ((string3 = this.errorDescription) == null) {
                            string3 = "";
                        }
                        apiResult = new SignUpStartApiResult.InvalidUsername(string4, string3, this.getCorrelationId());
                    } else if (ApiErrorResponseUtilKt.isAuthNotSupported(this.error)) {
                        String string5;
                        String string6 = this.error;
                        if (string6 == null) {
                            string6 = "";
                        }
                        if ((string5 = this.errorDescription) == null) {
                            string5 = "";
                        }
                        apiResult = new SignUpStartApiResult.AuthNotSupported(string6, string5, this.getCorrelationId());
                    } else if (ApiErrorResponseUtilKt.isAttributeValidationFailed(this.subError)) {
                        List<Object> list2;
                        String string7;
                        String string8;
                        String string9;
                        String string10 = this.error;
                        if (string10 == null) {
                            string10 = string9 = "";
                        }
                        if ((string8 = this.errorDescription) == null) {
                            string8 = string7 = "";
                        }
                        if ((list2 = this.invalidAttributes) == null || (list2 = ApiErrorResponseUtilKt.toAttributeList(list2)) == null) {
                            return new SignUpStartApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /start did not return a invalid_attributes with validation_failed error", this.getCorrelationId());
                        }
                        List<Object> list3 = list2;
                        String string11 = this.subError;
                        if (string11 == null) {
                            string11 = "";
                        }
                        String string12 = string11;
                        String string13 = this.getCorrelationId();
                        apiResult = new SignUpStartApiResult.InvalidAttributes(string13, string9, string7, list3, string12);
                    } else if (ApiErrorResponseUtilKt.isUnsupportedChallengeType(this.error)) {
                        String string14;
                        String string15 = this.error;
                        if (string15 == null) {
                            string15 = "";
                        }
                        if ((string14 = this.errorDescription) == null) {
                            string14 = "";
                        }
                        apiResult = new SignUpStartApiResult.UnsupportedChallengeType(string15, string14, this.getCorrelationId());
                    } else if (ApiErrorResponseUtilKt.isPasswordTooWeak(this.subError) || ApiErrorResponseUtilKt.isPasswordTooLong(this.subError) || ApiErrorResponseUtilKt.isPasswordTooShort(this.subError) || ApiErrorResponseUtilKt.isPasswordBanned(this.subError) || ApiErrorResponseUtilKt.isPasswordRecentlyUsed(this.subError) || ApiErrorResponseUtilKt.isPasswordInvalid(this.subError)) {
                        String string16;
                        String string17;
                        String string18;
                        String string19;
                        String string20 = this.error;
                        if (string20 == null) {
                            string20 = string19 = "";
                        }
                        if ((string18 = this.errorDescription) == null) {
                            string18 = string17 = "";
                        }
                        if ((string16 = this.subError) == null) {
                            string16 = "";
                        }
                        String string21 = string16;
                        String string22 = this.getCorrelationId();
                        apiResult = new SignUpStartApiResult.InvalidPassword(string22, string19, string17, string21);
                    } else {
                        String string23;
                        String string24 = this.error;
                        if (string24 == null) {
                            string24 = "";
                        }
                        if ((string23 = this.errorDescription) == null) {
                            string23 = "";
                        }
                        apiResult = new SignUpStartApiResult.UnknownError(string24, string23, this.getCorrelationId());
                    }
                }
                signUpStartApiResult = (SignUpStartApiResult)apiResult;
                break;
            }
            case 200: {
                if (ApiErrorResponseUtilKt.isRedirect(this.challengeType)) {
                    signUpStartApiResult = new SignUpStartApiResult.Redirect(this.getCorrelationId());
                    break;
                }
                String string = this.continuationToken;
                if (string == null) {
                    return new SignUpStartApiResult.UnknownError("invalid_state", "Sign up /start did not return a continuation token", this.getCorrelationId());
                }
                signUpStartApiResult = new SignUpStartApiResult.Success(string, this.getCorrelationId());
                break;
            }
            default: {
                String string;
                String string25 = this.error;
                if (string25 == null) {
                    string25 = "";
                }
                if ((string = this.errorDescription) == null) {
                    string = "";
                }
                signUpStartApiResult = new SignUpStartApiResult.UnknownError(string25, string, this.getCorrelationId());
            }
        }
        return signUpStartApiResult;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

