/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.util;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.util.ObjectMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0002J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/util/ApiResultUtil;", "", "()V", "logExposedFieldsOfObject", "", "tag", "", "object", "logResponse", "response", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "common4j"})
public final class ApiResultUtil {
    @NotNull
    public static final ApiResultUtil INSTANCE = new ApiResultUtil();

    private ApiResultUtil() {
    }

    public final void logResponse(@NotNull String tag, @NotNull IApiResponse response) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String TAG = tag + ':' + response.getClass().getSimpleName();
        if (response.getStatusCode() == 200) {
            Logger.info(TAG, "Success Result");
        } else {
            int code = response.getStatusCode();
            Logger.warn(TAG, "Failure Result (Status Code: " + code + ')');
        }
        this.logExposedFieldsOfObject(TAG, response);
    }

    private final void logExposedFieldsOfObject(String tag, Object object) {
        String TAG = tag + ':' + object.getClass().getSimpleName();
        Logger.warn(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(object));
    }
}

