/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.opentelemetry;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OpenTelemetryHolder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import javax.annotation.Nullable;
import lombok.NonNull;

public class OTelUtility {
    private static final String TAG = OTelUtility.class.getSimpleName();

    @NonNull
    public static Span createSpan(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Tracer tracer = OpenTelemetryHolder.getTracer(TAG);
        return tracer.spanBuilder(name).startSpan();
    }

    @NonNull
    public static Span createSpan(@NonNull String name, @NonNull String callingPackageName) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (callingPackageName == null) {
            throw new NullPointerException("callingPackageName is marked non-null but is null");
        }
        Tracer tracer = OpenTelemetryHolder.getTracer(TAG);
        return tracer.spanBuilder(name).setAttribute(AttributeName.calling_package_name.name(), callingPackageName).startSpan();
    }

    @NonNull
    public static Span createSpanFromParent(@NonNull String name, @Nullable SpanContext parentSpanContext) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String methodTag = TAG + ":createSpanFromParent";
        if (parentSpanContext == null) {
            Logger.verbose(methodTag, "parentSpanContext is NULL. Creating span without parent.");
            return OTelUtility.createSpan(name);
        }
        if (!parentSpanContext.isValid()) {
            Logger.warn(methodTag, "parentSpanContext is INVALID. Creating span without parent.");
            return OTelUtility.createSpan(name);
        }
        Tracer tracer = OpenTelemetryHolder.getTracer(TAG);
        return tracer.spanBuilder(name).setParent(Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)parentSpanContext))).startSpan();
    }

    @NonNull
    public static Span createSpanFromParent(@NonNull String name, @Nullable SpanContext parentSpanContext, @NonNull String callingPackageName) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (callingPackageName == null) {
            throw new NullPointerException("callingPackageName is marked non-null but is null");
        }
        String methodTag = TAG + ":createSpanFromParent";
        if (parentSpanContext == null) {
            Logger.verbose(methodTag, "parentSpanContext is NULL. Creating span without parent.");
            return OTelUtility.createSpan(name, callingPackageName);
        }
        if (!parentSpanContext.isValid()) {
            Logger.warn(methodTag, "parentSpanContext is INVALID. Creating span without parent.");
            return OTelUtility.createSpan(name, callingPackageName);
        }
        Tracer tracer = OpenTelemetryHolder.getTracer(TAG);
        return tracer.spanBuilder(name).setParent(Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)parentSpanContext))).setAttribute(AttributeName.calling_package_name.name(), callingPackageName).startSpan();
    }

    @NonNull
    public static LongCounter createLongCounter(@NonNull String name, @NonNull String description) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        Meter meter = OpenTelemetryHolder.getMeter(TAG);
        return meter.counterBuilder(name).setDescription(description).setUnit("count").build();
    }
}

