/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;

public class AccessToken {
    private static final long TOKEN_EXPIRED_BUFFER = 600000L;
    private static final int SECONDS_MS = 1000;
    private long mExpiresIn;
    private String mTokenType;
    private long mTokenReceivedTime;
    private String mRawAccessToken;

    public AccessToken(TokenResponse response) {
        this.mExpiresIn = response.getExpiresIn();
        this.mTokenReceivedTime = response.getResponseReceivedTime();
        this.mTokenType = response.getTokenType();
        this.mRawAccessToken = response.getAccessToken();
    }

    public String getAccessToken() {
        return this.mRawAccessToken;
    }

    public boolean isExpired() {
        long expiresOn = this.mTokenReceivedTime + this.mExpiresIn * 1000L;
        long currentTime = System.currentTimeMillis();
        long currentTimeWithBuffer = currentTime + 600000L;
        return expiresOn > currentTimeWithBuffer;
    }

    public long getTokenExpiredBuffer() {
        return 600000L;
    }

    public long getExpiresIn() {
        return this.mExpiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.mExpiresIn = expiresIn;
    }

    public String getTokenType() {
        return this.mTokenType;
    }

    public void setTokenType(String tokenType) {
        this.mTokenType = tokenType;
    }

    public long getTokenReceivedTime() {
        return this.mTokenReceivedTime;
    }

    public void setTokenReceivedTime(long tokenReceivedTime) {
        this.mTokenReceivedTime = tokenReceivedTime;
    }

    public String getRawAccessToken() {
        return this.mRawAccessToken;
    }

    public void setRawAccessToken(String rawAccessToken) {
        this.mRawAccessToken = rawAccessToken;
    }
}

