/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.util.BiConsumer;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="get() invokes await and is a blocking call. making it synchronized will create a deadlock.")
public class ResultFuture<T>
implements Future<T> {
    private final CountDownLatch mCountDownLatch = new CountDownLatch(1);
    private T mResult = null;
    private Throwable mException = null;
    private final List<BiConsumer<T, Throwable>> mConsumers = new ArrayList<BiConsumer<T, Throwable>>();

    @Override
    public boolean cancel(boolean b) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.mCountDownLatch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.mCountDownLatch.await();
        if (null != this.mException) {
            throw new ExecutionException(this.mException);
        }
        return this.mResult;
    }

    @Override
    public T get(long l, @NonNull TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        if (this.mCountDownLatch.await(l, timeUnit)) {
            if (null != this.mException) {
                throw new ExecutionException(this.mException);
            }
            return this.mResult;
        }
        throw new TimeoutException("Timed out waiting for: " + l + timeUnit.name());
    }

    public synchronized void setException(@NonNull Throwable exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.mException = exception;
        this.mCountDownLatch.countDown();
        for (BiConsumer<T, Throwable> consumer : this.mConsumers) {
            consumer.accept(this.mResult, exception);
        }
    }

    public synchronized void setResult(@Nullable T result) {
        this.mResult = result;
        this.mCountDownLatch.countDown();
        for (BiConsumer<T, Throwable> consumer : this.mConsumers) {
            consumer.accept(result, this.mException);
        }
        this.mConsumers.clear();
    }

    public synchronized void whenComplete(@NonNull BiConsumer<T, Throwable> consumerToAdd) {
        if (consumerToAdd == null) {
            throw new NullPointerException("consumerToAdd is marked non-null but is null");
        }
        if (this.isDone()) {
            consumerToAdd.accept(this.mResult, this.mException);
            return;
        }
        this.mConsumers.add(consumerToAdd);
    }
}

