/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import lombok.NonNull;

public final class SchemaUtil {
    private static final String TAG = SchemaUtil.class.getSimpleName();
    private static final String EXCEPTION_CONSTRUCTING_IDTOKEN = "Exception constructing IDToken. ";
    public static final String MISSING_FROM_THE_TOKEN_RESPONSE = "Missing from the token response";

    private SchemaUtil() {
    }

    public static String getAuthority(IDToken idToken) {
        String methodName = "getAuthority";
        String issuer = null;
        if (null != idToken) {
            Map<String, ?> idTokenClaims = idToken.getTokenClaims();
            issuer = (String)idTokenClaims.get("iss");
            Logger.verbosePII(TAG + ":" + "getAuthority", "Issuer: " + issuer);
            if (null == issuer) {
                Logger.warn(TAG + ":" + "getAuthority", "Environment was null or could not be parsed.");
            }
        } else {
            Logger.warn(TAG + ":" + "getAuthority", "IDToken was null");
        }
        return issuer;
    }

    public static String getAvatarUrl(IDToken idToken) {
        String methodName = "getAvatarUrl";
        String avatarUrl = null;
        if (null != idToken) {
            Map<String, ?> idTokenClaims = idToken.getTokenClaims();
            avatarUrl = (String)idTokenClaims.get("picture");
            Logger.verbosePII(TAG + ":" + "getAvatarUrl", "Avatar URL: " + avatarUrl);
            if (null == avatarUrl) {
                Logger.warn(TAG + ":" + "getAvatarUrl", "Avatar URL was null.");
            }
        } else {
            Logger.warn(TAG + ":" + "getAvatarUrl", "IDToken was null.");
        }
        return avatarUrl;
    }

    public static String getAlternativeAccountId(IDToken idToken) {
        String methodName = "getAlternativeAccountId";
        String alternativeAccountId = null;
        if (null != idToken) {
            Map<String, ?> idTokenClaims = idToken.getTokenClaims();
            alternativeAccountId = (String)idTokenClaims.get("altsecid");
            Logger.verbosePII(TAG + ":" + "getAlternativeAccountId", "alternative_account_id: " + alternativeAccountId);
            if (null == alternativeAccountId) {
                Logger.warn(TAG + ":" + "getAlternativeAccountId", "alternative_account_id was null.");
            }
        } else {
            Logger.warn(TAG + ":" + "getAlternativeAccountId", "IDToken was null.");
        }
        return alternativeAccountId;
    }

    public static String getCredentialTypeFromVersion(@Nullable String idTokenString) {
        String methodName = "getCredentialTypeFromVersion";
        String idTokenVersion = CredentialType.IdToken.name();
        if (!StringUtil.isNullOrEmpty(idTokenString)) {
            try {
                IDToken idToken = new IDToken(idTokenString);
                Map<String, ?> idTokenClaims = idToken.getTokenClaims();
                String aadVersion = (String)idTokenClaims.get("ver");
                if ("1.0".equalsIgnoreCase(aadVersion)) {
                    idTokenVersion = CredentialType.V1IdToken.name();
                }
            }
            catch (ServiceException e) {
                Logger.warn(TAG + ":" + "getCredentialTypeFromVersion", EXCEPTION_CONSTRUCTING_IDTOKEN + e.getMessage());
            }
        }
        return idTokenVersion;
    }

    public static String getIdentityProvider(String idTokenString) {
        String methodName = "getIdentityProvider";
        String idp = null;
        if (null != idTokenString) {
            try {
                IDToken idToken = new IDToken(idTokenString);
                Map<String, ?> idTokenClaims = idToken.getTokenClaims();
                idp = (String)idTokenClaims.get("idp");
                Logger.verbosePII(TAG + ":" + "getIdentityProvider", "idp: " + idp);
                if (null == idp) {
                    Logger.info(TAG + ":" + "getIdentityProvider", "idp claim was null.");
                }
            }
            catch (ServiceException e) {
                Logger.warn(TAG + ":" + "getIdentityProvider", EXCEPTION_CONSTRUCTING_IDTOKEN + e.getMessage());
            }
        } else {
            Logger.warn(TAG + ":" + "getIdentityProvider", "IDToken was null.");
        }
        return idp;
    }

    public static String getHomeAccountId(ClientInfo clientInfo) {
        String methodName = ":getHomeAccountId";
        String homeAccountId = null;
        if (null != clientInfo) {
            String uid = clientInfo.getUid();
            String utid = clientInfo.getUtid();
            if (StringUtil.isNullOrEmpty(uid)) {
                Logger.warn(TAG + ":" + ":getHomeAccountId", "uid was null/blank");
            }
            if (StringUtil.isNullOrEmpty(utid)) {
                Logger.warn(TAG + ":" + ":getHomeAccountId", "utid was null/blank");
            }
            if (!StringUtil.isNullOrEmpty(uid) && !StringUtil.isNullOrEmpty(utid)) {
                homeAccountId = uid + "." + utid;
            }
            Logger.verbosePII(TAG + ":" + ":getHomeAccountId", "home_account_id: " + homeAccountId);
        } else {
            Logger.warn(TAG + ":" + ":getHomeAccountId", "ClientInfo was null.");
        }
        return homeAccountId;
    }

    @Nullable
    public static String getTenantId(@Nullable String clientInfoString, @Nullable String idTokenString) {
        String tenantId = null;
        try {
            if (!StringUtil.isNullOrEmpty(idTokenString) && !StringUtil.isNullOrEmpty(clientInfoString)) {
                IDToken idToken = new IDToken(idTokenString);
                ClientInfo clientInfo = new ClientInfo(clientInfoString);
                Map<String, ?> claims = idToken.getTokenClaims();
                if (!StringUtil.isNullOrEmpty((String)claims.get("tid"))) {
                    tenantId = (String)claims.get("tid");
                } else if (!StringUtil.isNullOrEmpty(clientInfo.getUtid())) {
                    Logger.warn(TAG, "realm is not returned from server. Use utid as realm.");
                    tenantId = clientInfo.getUtid();
                } else {
                    Logger.warn(TAG, "realm and utid is not returned from server. Using empty string as default tid.");
                }
            }
        }
        catch (ServiceException e) {
            Logger.errorPII(TAG, "Failed to construct IDToken or ClientInfo", e);
        }
        return tenantId;
    }

    public static String getDisplayableId(@NonNull Map<String, ?> claims) {
        if (claims == null) {
            throw new NullPointerException("claims is marked non-null but is null");
        }
        if (!StringUtil.isNullOrEmpty((String)claims.get("preferred_username"))) {
            return (String)claims.get("preferred_username");
        }
        if (!StringUtil.isNullOrEmpty((String)claims.get("email"))) {
            return (String)claims.get("email");
        }
        if (!StringUtil.isNullOrEmpty((String)claims.get("upn"))) {
            return (String)claims.get("upn");
        }
        Logger.warn(TAG, "The preferred username is not returned from the IdToken.");
        return MISSING_FROM_THE_TOKEN_RESPONSE;
    }
}

