/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authorities;

import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import lombok.NonNull;

public class AzureActiveDirectoryB2CAuthority
extends Authority {
    private static final String TAG = AzureActiveDirectoryB2CAuthority.class.getName();

    public AzureActiveDirectoryB2CAuthority(String authorityUrl) {
        this.mAuthorityTypeString = "B2C";
        this.mAuthorityUrlString = authorityUrl;
    }

    protected MicrosoftStsOAuth2Configuration createOAuth2Configuration() {
        String methodName = ":createOAuth2Configuration";
        Logger.verbose(TAG + ":createOAuth2Configuration", "Creating OAuth2Configuration");
        MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
        config.setMultipleCloudsSupported(false);
        config.setAuthorityUrl(this.getAuthorityURL());
        if (this.mSlice != null) {
            Logger.info(TAG + ":createOAuth2Configuration", "Setting slice parameters...");
            AzureActiveDirectorySlice slice = new AzureActiveDirectorySlice();
            slice.setSlice(this.mSlice.getSlice());
            slice.setDataCenter(this.mSlice.getDataCenter());
            config.setSlice(slice);
        }
        return config;
    }

    @Override
    public OAuth2Strategy createOAuth2Strategy(@NonNull OAuth2StrategyParameters parameters) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        MicrosoftStsOAuth2Configuration config = this.createOAuth2Configuration();
        return new MicrosoftStsOAuth2Strategy(config, parameters);
    }

    public String getB2CPolicyName() {
        String[] authorityUriParts = this.mAuthorityUrlString.split("/");
        return authorityUriParts[authorityUriParts.length - 1];
    }
}

