/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.challengehandlers;

import com.microsoft.identity.common.java.AuthenticationSettings;
import com.microsoft.identity.common.java.challengehandlers.IDeviceCertificate;
import com.microsoft.identity.common.java.challengehandlers.IDeviceCertificateLoader;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.JWSBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PKeyAuthChallenge {
    private static final String TAG = PKeyAuthChallenge.class.getSimpleName();
    private final String mNonce;
    private final String mContext;
    @Nullable
    private final List<String> mCertAuthorities;
    @Nullable
    private final String mThumbprint;
    private final String mVersion;
    private final String mSubmitUrl;
    private final JWSBuilder mJwsBuilder;
    @Nullable
    private final String mTenantId;

    public Map<String, String> getChallengeHeader() throws ClientException {
        String methodName = ":getChallengeHeader";
        if ((this.mCertAuthorities == null || this.mCertAuthorities.size() == 0) && StringUtil.isNullOrEmpty(this.mThumbprint)) {
            Logger.info(TAG + ":getChallengeHeader", "Both cert Authorities and Thumbprint are not provided.Sending a response which is equivalent to no certificate present on client.");
            return this.getChallengeHeaderWithoutSignedJwt();
        }
        IDeviceCertificateLoader certificateLoader = AuthenticationSettings.INSTANCE.getCertificateLoader();
        if (certificateLoader == null) {
            Logger.warn(TAG + ":getChallengeHeader", "Device Certificate loader is not initialized.");
            return this.getChallengeHeaderWithoutSignedJwt();
        }
        IDeviceCertificate deviceCertProxy = certificateLoader.loadCertificate(this.mTenantId);
        if (deviceCertProxy == null) {
            Logger.warn(TAG + ":getChallengeHeader", "Device Certificate not found.");
            return this.getChallengeHeaderWithoutSignedJwt();
        }
        if (deviceCertProxy.isValidIssuer(this.mCertAuthorities)) {
            Logger.info(TAG + ":getChallengeHeader", "Found a certificate matching the provided authority.");
            return this.getChallengeHeaderWithSignedJwt(deviceCertProxy);
        }
        if (StringUtil.equalsIgnoreCase(deviceCertProxy.getThumbPrint(), this.mThumbprint)) {
            Logger.info(TAG + ":getChallengeHeader", "Found a certificate matching the provided thumbprint.");
            return this.getChallengeHeaderWithSignedJwt(deviceCertProxy);
        }
        return this.getChallengeHeaderWithoutSignedJwt();
    }

    private Map<String, String> getChallengeHeaderWithoutSignedJwt() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.format("%s Context=\"%s\",Version=\"%s\"", "PKeyAuth", this.mContext, "1.0"));
        return headers;
    }

    private Map<String, String> getChallengeHeaderWithSignedJwt(@NonNull IDeviceCertificate deviceCertProxy) throws ClientException {
        String methodName = ":getChallengeHeaderWithSignedJwt";
        if (!StringUtil.equalsIgnoreCase(this.mVersion, "1.0")) {
            Logger.warn(TAG + ":getChallengeHeaderWithSignedJwt", "PKeyAuth version mismatch, server provides: " + this.mVersion + "We support: " + "1.0" + "Proceed anyway with " + "1.0");
        }
        String jwt = this.mJwsBuilder.generateSignedJWT(this.mNonce, this.mSubmitUrl, deviceCertProxy);
        Logger.info(TAG + ":getChallengeHeaderWithSignedJwt", "Generated a signed challenge response.");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.format("%s AuthToken=\"%s\",Context=\"%s\",Version=\"%s\"", "PKeyAuth", jwt, this.mContext, "1.0"));
        return headers;
    }

    private static JWSBuilder $default$jwsBuilder() {
        return new JWSBuilder();
    }

    PKeyAuthChallenge(String nonce, String context, @Nullable List<String> certAuthorities, @Nullable String thumbprint, String version, String submitUrl, JWSBuilder jwsBuilder, @Nullable String tenantId) {
        this.mNonce = nonce;
        this.mContext = context;
        this.mCertAuthorities = certAuthorities;
        this.mThumbprint = thumbprint;
        this.mVersion = version;
        this.mSubmitUrl = submitUrl;
        this.mJwsBuilder = jwsBuilder;
        this.mTenantId = tenantId;
    }

    public static PKeyAuthChallengeBuilder builder() {
        return new PKeyAuthChallengeBuilder();
    }

    public String getNonce() {
        return this.mNonce;
    }

    public String getContext() {
        return this.mContext;
    }

    @Nullable
    public List<String> getCertAuthorities() {
        return this.mCertAuthorities;
    }

    @Nullable
    public String getThumbprint() {
        return this.mThumbprint;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getSubmitUrl() {
        return this.mSubmitUrl;
    }

    public JWSBuilder getJwsBuilder() {
        return this.mJwsBuilder;
    }

    @Nullable
    public String getTenantId() {
        return this.mTenantId;
    }

    public static class PKeyAuthChallengeBuilder {
        private String nonce;
        private String context;
        private List<String> certAuthorities;
        private String thumbprint;
        private String version;
        private String submitUrl;
        private boolean jwsBuilder$set;
        private JWSBuilder jwsBuilder$value;
        private String tenantId;

        PKeyAuthChallengeBuilder() {
        }

        public PKeyAuthChallengeBuilder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public PKeyAuthChallengeBuilder context(String context) {
            this.context = context;
            return this;
        }

        public PKeyAuthChallengeBuilder certAuthorities(@Nullable List<String> certAuthorities) {
            this.certAuthorities = certAuthorities;
            return this;
        }

        public PKeyAuthChallengeBuilder thumbprint(@Nullable String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public PKeyAuthChallengeBuilder version(String version) {
            this.version = version;
            return this;
        }

        public PKeyAuthChallengeBuilder submitUrl(String submitUrl) {
            this.submitUrl = submitUrl;
            return this;
        }

        public PKeyAuthChallengeBuilder jwsBuilder(JWSBuilder jwsBuilder) {
            this.jwsBuilder$value = jwsBuilder;
            this.jwsBuilder$set = true;
            return this;
        }

        public PKeyAuthChallengeBuilder tenantId(@Nullable String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public PKeyAuthChallenge build() {
            JWSBuilder jwsBuilder$value = this.jwsBuilder$value;
            if (!this.jwsBuilder$set) {
                jwsBuilder$value = PKeyAuthChallenge.$default$jwsBuilder();
            }
            return new PKeyAuthChallenge(this.nonce, this.context, this.certAuthorities, this.thumbprint, this.version, this.submitUrl, jwsBuilder$value, this.tenantId);
        }

        public String toString() {
            return "PKeyAuthChallenge.PKeyAuthChallengeBuilder(nonce=" + this.nonce + ", context=" + this.context + ", certAuthorities=" + this.certAuthorities + ", thumbprint=" + this.thumbprint + ", version=" + this.version + ", submitUrl=" + this.submitUrl + ", jwsBuilder$value=" + this.jwsBuilder$value + ", tenantId=" + this.tenantId + ")";
        }
    }

    static enum RequestField {
        Nonce,
        CertAuthorities,
        Version,
        SubmitUrl,
        Context,
        CertThumbprint,
        TenantId;

    }
}

