/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.controllers;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.ITokenAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.commands.parameters.BrokerSilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.IHasExtraParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RopcTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.foci.FociQueryUtilities;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenRequest;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.IResult;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.java.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.TokenResult;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.telemetry.CliTelemInfo;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.telemetry.events.CacheEndEvent;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.ResultUtil;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.NonNull;

public abstract class BaseController {
    private static final String TAG = BaseController.class.getSimpleName();

    public static String getDelimitedDefaultScopeString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String scope : AuthenticationConstants.DEFAULT_SCOPES) {
            stringBuilder.append(scope);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString().trim();
    }

    public abstract AcquireTokenResult acquireToken(InteractiveTokenCommandParameters var1) throws Exception;

    public abstract void onFinishAuthorizationSession(int var1, int var2, @NonNull PropertyBag var3);

    public abstract AcquireTokenResult acquireTokenSilent(SilentTokenCommandParameters var1) throws Exception;

    public abstract List<ICacheRecord> getAccounts(CommandParameters var1) throws Exception;

    public abstract boolean removeAccount(RemoveAccountCommandParameters var1) throws Exception;

    public abstract boolean getDeviceMode(CommandParameters var1) throws Exception;

    public abstract List<ICacheRecord> getCurrentAccount(CommandParameters var1) throws Exception;

    public abstract boolean removeCurrentAccount(RemoveAccountCommandParameters var1) throws Exception;

    public abstract AuthorizationResult deviceCodeFlowAuthRequest(DeviceCodeFlowCommandParameters var1) throws Exception;

    public abstract AcquireTokenResult acquireDeviceCodeFlowToken(AuthorizationResult var1, DeviceCodeFlowCommandParameters var2) throws Exception;

    public AcquireTokenResult acquireTokenWithPassword(@NonNull RopcTokenCommandParameters parameters) throws Exception {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String methodName = ":acquireToken";
        Logger.verbose(TAG + ":acquireToken", "Acquiring token...");
        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
        parameters.validate();
        Set<String> mergedScopes = this.addDefaultScopes(parameters);
        TokenCommandParameters parametersWithScopes = ((RopcTokenCommandParameters.RopcTokenCommandParametersBuilder)parameters.toBuilder().scopes(mergedScopes)).build();
        this.logParameters(TAG, parametersWithScopes);
        parametersWithScopes.getPlatformComponents().getPlatformUtil().throwIfNetworkNotAvailable(parametersWithScopes.isPowerOptCheckEnabled());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult(parametersWithScopes.getAuthority());
        if (!authorityResult.getKnown()) {
            Logger.error(TAG + ":acquireToken", "Authority is not known.", authorityResult.getClientException());
            throw authorityResult.getClientException();
        }
        OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).build();
        OAuth2Strategy oAuth2Strategy = parametersWithScopes.getAuthority().createOAuth2Strategy(strategyParameters);
        Object ropcTokenRequest = oAuth2Strategy.createRopcTokenRequest((RopcTokenCommandParameters)parametersWithScopes);
        Object tokenResult = oAuth2Strategy.requestToken(ropcTokenRequest);
        acquireTokenResult.setTokenResult((TokenResult)tokenResult);
        OAuth2TokenCache tokenCache = parameters.getOAuth2TokenCache();
        if (tokenResult != null && ((TokenResult)tokenResult).getSuccess()) {
            List<ICacheRecord> savedRecords = tokenCache.saveAndLoadAggregatedAccountData(oAuth2Strategy, this.getAuthorizationRequest(oAuth2Strategy, parameters), ((TokenResult)tokenResult).getTokenResponse());
            ICacheRecord savedRecord = savedRecords.get(0);
            LocalAuthenticationResult authenticationResult = new LocalAuthenticationResult(this.finalizeCacheRecordForResult(savedRecord, parameters.getAuthenticationScheme()), savedRecords, parameters.getSdkType(), false);
            if (null != ((TokenResult)tokenResult).getCliTelemInfo()) {
                CliTelemInfo cliTelemInfo = ((TokenResult)tokenResult).getCliTelemInfo();
                authenticationResult.setSpeRing(cliTelemInfo.getSpeRing());
                authenticationResult.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
                Telemetry.emit(new CacheEndEvent().putSpeInfo(((TokenResult)tokenResult).getCliTelemInfo().getSpeRing()));
            } else {
                Telemetry.emit(new CacheEndEvent());
            }
            acquireTokenResult.setLocalAuthenticationResult(authenticationResult);
        }
        return acquireTokenResult;
    }

    protected final AuthorizationRequest.Builder initializeAuthorizationRequestBuilder(@NonNull AuthorizationRequest.Builder builder, @NonNull TokenCommandParameters parameters) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        UUID correlationId = null;
        try {
            correlationId = UUID.fromString((String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id"));
        }
        catch (IllegalArgumentException ex) {
            Logger.error(TAG, "correlation id from diagnostic context is not a UUID", ex);
        }
        ((AuthorizationRequest.Builder)builder.setClientId(parameters.getClientId())).setRedirectUri(parameters.getRedirectUri());
        if (builder instanceof MicrosoftAuthorizationRequest.Builder) {
            ((MicrosoftAuthorizationRequest.Builder)builder).setCorrelationId(correlationId);
        }
        Set<String> scopes = parameters.getScopes();
        if (parameters instanceof InteractiveTokenCommandParameters) {
            InteractiveTokenCommandParameters interactiveTokenCommandParameters = (InteractiveTokenCommandParameters)parameters;
            if (builder instanceof MicrosoftAuthorizationRequest.Builder) {
                ((MicrosoftStsAuthorizationRequest.Builder)builder).setTokenScope(StringUtil.join(" ", parameters.getScopes()));
                if (interactiveTokenCommandParameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
                    AzureActiveDirectoryAuthority requestAuthority = (AzureActiveDirectoryAuthority)interactiveTokenCommandParameters.getAuthority();
                    ((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)builder).setAuthority(requestAuthority.getAuthorityURL())).setMultipleCloudAware(requestAuthority.isMultipleCloudsSupported())).setState(interactiveTokenCommandParameters.getPlatformComponents().getStateGenerator().generate())).setSlice(requestAuthority.mSlice);
                }
            }
            if (interactiveTokenCommandParameters.getExtraScopesToConsent() != null) {
                scopes.addAll(interactiveTokenCommandParameters.getExtraScopesToConsent());
            }
            HashMap<String, String> completeRequestHeaders = new HashMap<String, String>();
            if (interactiveTokenCommandParameters.getRequestHeaders() != null) {
                completeRequestHeaders.putAll(interactiveTokenCommandParameters.getRequestHeaders());
            }
            completeRequestHeaders.put("x-app-name", parameters.getApplicationName());
            completeRequestHeaders.put("x-app-ver", parameters.getApplicationVersion());
            completeRequestHeaders.put("x-ms-PKeyAuth", "1.0");
            this.setBuilderProperties(builder, parameters, interactiveTokenCommandParameters, completeRequestHeaders);
            if (!StringUtil.isNullOrEmpty(interactiveTokenCommandParameters.getLoginHint()) && interactiveTokenCommandParameters.getPrompt() == OpenIdConnectPromptParameter.SELECT_ACCOUNT && builder instanceof MicrosoftStsAuthorizationRequest.Builder) {
                ((MicrosoftStsAuthorizationRequest.Builder)builder).setPrompt(null);
            }
        }
        builder.setScope(StringUtil.join(" ", scopes));
        return builder;
    }

    private void setBuilderProperties(@NonNull AuthorizationRequest.Builder builder, @NonNull TokenCommandParameters parameters, InteractiveTokenCommandParameters interactiveTokenCommandParameters, HashMap<String, String> completeRequestHeaders) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        ((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)builder.setExtraQueryParams(interactiveTokenCommandParameters.getExtraQueryStringParameters())).setClaims(parameters.getClaimsRequestJson())).setRequestHeaders(completeRequestHeaders)).setWebViewZoomEnabled(interactiveTokenCommandParameters.isWebViewZoomEnabled())).setWebViewZoomControlsEnabled(interactiveTokenCommandParameters.isWebViewZoomControlsEnabled());
        if (builder instanceof MicrosoftStsAuthorizationRequest.Builder) {
            MicrosoftStsAuthorizationRequest.Builder msBuilder = (MicrosoftStsAuthorizationRequest.Builder)builder;
            ((MicrosoftStsAuthorizationRequest.Builder)msBuilder.setLoginHint(interactiveTokenCommandParameters.getLoginHint())).setPrompt(interactiveTokenCommandParameters.getPrompt().toString());
            String installedCompanyPortalVersion = parameters.getPlatformComponents().getPlatformUtil().getInstalledCompanyPortalVersion();
            if (!StringUtil.isNullOrEmpty(installedCompanyPortalVersion)) {
                msBuilder.setInstalledCompanyPortalVersion(installedCompanyPortalVersion);
            }
        }
    }

    protected AuthorizationRequest getAuthorizationRequest(@NonNull OAuth2Strategy strategy, @NonNull TokenCommandParameters parameters) {
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        Object builder = strategy.createAuthorizationRequestBuilder(parameters.getAccount());
        this.initializeAuthorizationRequestBuilder((AuthorizationRequest.Builder)builder, parameters);
        return ((AuthorizationRequest.Builder)builder).build();
    }

    protected TokenResult performTokenRequest(@NonNull OAuth2Strategy strategy, @NonNull AuthorizationRequest request, @NonNull AuthorizationResponse response, @NonNull InteractiveTokenCommandParameters parameters) throws IOException, ClientException {
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String methodName = ":performTokenRequest";
        parameters.getPlatformComponents().getPlatformUtil().throwIfNetworkNotAvailable(parameters.isPowerOptCheckEnabled());
        Object tokenRequest = strategy.createTokenRequest(request, response, parameters.getAuthenticationScheme());
        if (tokenRequest instanceof MicrosoftTokenRequest) {
            ((MicrosoftTokenRequest)tokenRequest).setClientAppName(parameters.getApplicationName());
            ((MicrosoftTokenRequest)tokenRequest).setClientAppVersion(parameters.getApplicationVersion());
        }
        if (parameters instanceof IHasExtraParameters) {
            tokenRequest.setExtraParameters(((IHasExtraParameters)((Object)parameters)).getExtraParameters());
        }
        ResultUtil.logExposedFieldsOfObject(TAG + ":performTokenRequest", tokenRequest);
        Object tokenResult = strategy.requestToken(tokenRequest);
        ResultUtil.logResult(TAG, tokenResult);
        return tokenResult;
    }

    protected void renewAccessToken(@NonNull SilentTokenCommandParameters parameters, @NonNull AcquireTokenResult acquireTokenSilentResult, @NonNull OAuth2TokenCache tokenCache, @NonNull OAuth2Strategy strategy, @NonNull ICacheRecord cacheRecord) throws IOException, ClientException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (acquireTokenSilentResult == null) {
            throw new NullPointerException("acquireTokenSilentResult is marked non-null but is null");
        }
        if (tokenCache == null) {
            throw new NullPointerException("tokenCache is marked non-null but is null");
        }
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        String methodTag = TAG + ":renewAccessToken";
        Logger.info(methodTag, "Renewing access token...");
        RefreshTokenRecord refreshTokenRecord = cacheRecord.getRefreshToken();
        this.logParameters(methodTag, parameters);
        TokenResult tokenResult = this.performSilentTokenRequest(strategy, refreshTokenRecord, parameters);
        acquireTokenSilentResult.setTokenResult(tokenResult);
        ResultUtil.logResult(methodTag, tokenResult);
        if (tokenResult.getSuccess()) {
            Logger.info(methodTag, "Token request was successful");
            List<ICacheRecord> savedRecords = tokenCache.saveAndLoadAggregatedAccountData(strategy, this.getAuthorizationRequest(strategy, parameters), tokenResult.getTokenResponse());
            ICacheRecord savedRecord = savedRecords.get(0);
            LocalAuthenticationResult authenticationResult = new LocalAuthenticationResult(this.finalizeCacheRecordForResult(savedRecord, parameters.getAuthenticationScheme()), savedRecords, parameters.getSdkType(), false);
            if (null != tokenResult.getCliTelemInfo()) {
                CliTelemInfo cliTelemInfo = tokenResult.getCliTelemInfo();
                authenticationResult.setSpeRing(cliTelemInfo.getSpeRing());
                authenticationResult.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
                Telemetry.emit(new CacheEndEvent().putSpeInfo(tokenResult.getCliTelemInfo().getSpeRing()));
            } else {
                Telemetry.emit(new CacheEndEvent());
            }
            acquireTokenSilentResult.setLocalAuthenticationResult(authenticationResult);
        } else if (tokenResult.getErrorResponse() != null) {
            String errorCode = tokenResult.getErrorResponse().getError();
            String subErrorCode = tokenResult.getErrorResponse().getSubError();
            Logger.info(methodTag, "Error: " + errorCode + " Suberror: " + subErrorCode);
            if ("invalid_grant".equals(errorCode) && "bad_token".equals(subErrorCode)) {
                boolean isRemoved = tokenCache.removeCredential(cacheRecord.getRefreshToken());
                Logger.info(methodTag, "Refresh token is invalid, attempting to delete the RT from cache, result:" + isRemoved);
            }
            if ("service_not_available".equals(errorCode)) {
                throw new ServiceException("service_not_available", "AAD is not available.", tokenResult.getErrorResponse().getStatusCode(), null);
            }
        } else {
            Logger.warn(methodTag, "Invalid state, No token success or error response on the token result");
        }
    }

    public TokenResult renewAccessToken(@NonNull SilentTokenCommandParameters parameters) throws IOException, ClientException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String methodTag = TAG + ":renewAccessToken";
        Logger.info(methodTag, "Renewing access token...");
        OAuth2Strategy strategy = this.getStrategy(parameters);
        OAuth2TokenCache cache = this.getTokenCache(parameters);
        ICacheRecord cacheRecord = this.getCacheRecord(parameters);
        Logger.info(methodTag, "Attempting renewal of Access Token because it's refresh-expired. RefreshIn was expired at " + cacheRecord.getAccessToken().getRefreshOn() + ". Regular expiry is at " + cacheRecord.getAccessToken().getExpiresOn() + ".Currently executing acquireTokenSilent(..), SilentTokenCommand with CorrelationId: " + parameters.getCorrelationId());
        RefreshTokenRecord refreshTokenRecord = cacheRecord.getRefreshToken();
        this.logParameters(TAG, parameters);
        TokenResult tokenResult = this.performSilentTokenRequest(strategy, refreshTokenRecord, parameters);
        BaseController.logResult(methodTag, tokenResult);
        if (tokenResult.getSuccess()) {
            Logger.info(methodTag, "Token request was successful");
            Logger.info(methodTag, "Access token is refresh-expired. Removing from cache...");
            AccessTokenRecord accessTokenRecord = cacheRecord.getAccessToken();
            cache.removeCredential(accessTokenRecord);
            List<ICacheRecord> savedRecords = cache.saveAndLoadAggregatedAccountData(strategy, this.getAuthorizationRequest(strategy, parameters), tokenResult.getTokenResponse());
            ICacheRecord savedRecord = savedRecords.get(0);
            this.finalizeCacheRecordForResult(savedRecord, parameters.getAuthenticationScheme());
            if (null != tokenResult.getCliTelemInfo()) {
                Telemetry.emit(new CacheEndEvent().putSpeInfo(tokenResult.getCliTelemInfo().getSpeRing()));
            } else {
                Telemetry.emit(new CacheEndEvent());
            }
        } else if (tokenResult.getErrorResponse() != null) {
            String errorCode = tokenResult.getErrorResponse().getError();
            String subErrorCode = tokenResult.getErrorResponse().getSubError();
            Logger.warn(methodTag, "Error: " + errorCode + " Suberror: " + subErrorCode);
            if ("invalid_grant".equals(errorCode) && "bad_token".equals(subErrorCode)) {
                boolean isRemoved = cache.removeCredential(cacheRecord.getRefreshToken());
                Logger.info(methodTag, "Refresh token is invalid, attempting to delete the RT from cache, result:" + isRemoved);
            }
            if ("service_not_available".equals(errorCode)) {
                throw new ServiceException("service_not_available", "AAD is not available.", tokenResult.getErrorResponse().getStatusCode(), null);
            }
        } else {
            Logger.warn(methodTag, "Invalid state, No token success or error response on the token result");
        }
        return tokenResult;
    }

    public OAuth2Strategy getStrategy(@NonNull SilentTokenCommandParameters parameters) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).build();
        return parameters.getAuthority().createOAuth2Strategy(strategyParameters);
    }

    public ICacheRecord getCacheRecord(@NonNull SilentTokenCommandParameters parameters) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        AccountRecord targetAccount = this.getCachedAccountRecord(parameters);
        AbstractAuthenticationScheme authScheme = parameters.getAuthenticationScheme();
        OAuth2TokenCache cache = parameters.getOAuth2TokenCache();
        List<ICacheRecord> cacheRecords = cache.loadWithAggregatedAccountData(parameters.getClientId(), StringUtil.join(" ", parameters.getScopes()), targetAccount, authScheme);
        return cacheRecords.get(0);
    }

    public OAuth2TokenCache getTokenCache(@NonNull SilentTokenCommandParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        return parameters.getOAuth2TokenCache();
    }

    public static void logResult(@NonNull String tag, @NonNull IResult result) {
        AuthorizationResult authResult;
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        String TAG = tag + ":" + result.getClass().getSimpleName();
        if (result.getSuccess()) {
            Logger.info(TAG, "Success Result");
            ResultUtil.logExposedFieldsOfObject(TAG, result.getSuccessResponse());
        } else {
            Logger.warn(TAG, "Failure Result");
            if (result.getErrorResponse() != null) {
                if (result.getErrorResponse().getError() != null) {
                    Logger.warn(TAG, "Error: " + result.getErrorResponse().getError());
                }
                if (result.getErrorResponse().getErrorDescription() != null) {
                    Logger.warnPII(TAG, "Description: " + result.getErrorResponse().getErrorDescription());
                }
                ResultUtil.logExposedFieldsOfObject(TAG, result.getErrorResponse());
            }
        }
        if (result instanceof AuthorizationResult && (authResult = (AuthorizationResult)result).getAuthorizationStatus() != null) {
            Logger.info(TAG, "Authorization Status: " + authResult.getAuthorizationStatus().toString());
        }
    }

    protected void logParameters(String tag, Object parameters) {
        String TAG = tag + ":" + parameters.getClass().getSimpleName();
        if (Logger.isAllowPii()) {
            Logger.infoPII(TAG, ObjectMapper.serializeObjectToJsonString(parameters));
        } else {
            Logger.info(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(parameters));
        }
    }

    protected TokenResult performSilentTokenRequest(@NonNull OAuth2Strategy strategy, @NonNull RefreshTokenRecord refreshToken, @NonNull SilentTokenCommandParameters parameters) throws ClientException, IOException {
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String methodName = ":performSilentTokenRequest";
        Logger.info(TAG + ":performSilentTokenRequest", "Requesting tokens...");
        parameters.getPlatformComponents().getPlatformUtil().throwIfNetworkNotAvailable(parameters.isPowerOptCheckEnabled());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult(parameters.getAuthority());
        if (!authorityResult.getKnown()) {
            throw authorityResult.getClientException();
        }
        Object refreshTokenRequest = strategy.createRefreshTokenRequest(parameters.getAuthenticationScheme());
        ((TokenRequest)refreshTokenRequest).setClientId(parameters.getClientId());
        ((TokenRequest)refreshTokenRequest).setScope(StringUtil.join(" ", parameters.getScopes()));
        ((TokenRequest)refreshTokenRequest).setRefreshToken(refreshToken.getSecret());
        if (refreshTokenRequest instanceof MicrosoftTokenRequest) {
            ((MicrosoftTokenRequest)refreshTokenRequest).setClaims(parameters.getClaimsRequestJson());
            ((MicrosoftTokenRequest)refreshTokenRequest).setClientAppName(parameters.getApplicationName());
            ((MicrosoftTokenRequest)refreshTokenRequest).setClientAppVersion(parameters.getApplicationVersion());
            if (parameters.getSdkType() == SdkType.ADAL) {
                ((MicrosoftTokenRequest)refreshTokenRequest).setIdTokenVersion("1");
            }
            if (parameters instanceof BrokerSilentTokenCommandParameters) {
                ((MicrosoftTokenRequest)refreshTokenRequest).setBrokerVersion(((BrokerSilentTokenCommandParameters)parameters).getBrokerVersion());
                ((MicrosoftTokenRequest)refreshTokenRequest).setPKeyAuthHeaderAllowed(((BrokerSilentTokenCommandParameters)parameters).isPKeyAuthHeaderAllowed());
            }
        }
        if (!StringUtil.isNullOrEmpty(((TokenRequest)refreshTokenRequest).getScope())) {
            Logger.infoPII(TAG + ":performSilentTokenRequest", "Scopes: [" + ((TokenRequest)refreshTokenRequest).getScope() + "]");
        }
        return this.strategyRequestToken(strategy, (TokenRequest)refreshTokenRequest);
    }

    private TokenResult strategyRequestToken(@NonNull OAuth2Strategy strategy, TokenRequest refreshTokenRequest) throws IOException, ClientException {
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        return strategy.requestToken(refreshTokenRequest);
    }

    protected List<ICacheRecord> saveTokens(@NonNull OAuth2Strategy strategy, @NonNull AuthorizationRequest request, @NonNull TokenResponse tokenResponse, @NonNull OAuth2TokenCache tokenCache) throws ClientException {
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (tokenResponse == null) {
            throw new NullPointerException("tokenResponse is marked non-null but is null");
        }
        if (tokenCache == null) {
            throw new NullPointerException("tokenCache is marked non-null but is null");
        }
        String methodName = ":saveTokens";
        Logger.info(TAG + ":saveTokens", "Saving tokens...");
        List<ICacheRecord> cacheRecords = tokenCache.saveAndLoadAggregatedAccountData(strategy, request, tokenResponse);
        return cacheRecords;
    }

    protected boolean refreshTokenIsNull(@NonNull ICacheRecord cacheRecord) {
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        return null == cacheRecord.getRefreshToken();
    }

    protected boolean accessTokenIsNull(@NonNull ICacheRecord cacheRecord) {
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        return null == cacheRecord.getAccessToken();
    }

    protected boolean idTokenIsNull(@NonNull ICacheRecord cacheRecord, @NonNull SdkType sdkType) {
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        if (sdkType == null) {
            throw new NullPointerException("sdkType is marked non-null but is null");
        }
        IdTokenRecord idTokenRecord = sdkType == SdkType.ADAL ? cacheRecord.getV1IdToken() : cacheRecord.getIdToken();
        return null == idTokenRecord;
    }

    protected Set<String> addDefaultScopes(@NonNull TokenCommandParameters commandParameters) {
        if (commandParameters == null) {
            throw new NullPointerException("commandParameters is marked non-null but is null");
        }
        Set<String> requestScopes = commandParameters.getScopes();
        requestScopes.addAll(AuthenticationConstants.DEFAULT_SCOPES);
        requestScopes.removeAll(Arrays.asList("", null));
        return requestScopes;
    }

    protected AccountRecord getCachedAccountRecord(@NonNull SilentTokenCommandParameters parameters) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String methodTag = TAG + ":getCachedAccountRecord";
        if (parameters.getAccount() == null) {
            throw new ClientException("no_account_found", "No cached accounts found for the supplied homeAccountId and clientId");
        }
        boolean isB2CAuthority = "B2C".equalsIgnoreCase(parameters.getAuthority().getAuthorityTypeString());
        AccountRecord targetAccount = this.getCachedAccountRecordFromCallingAppCache(parameters);
        if (targetAccount != null) {
            return targetAccount;
        }
        Logger.info(methodTag, "Account not found in app cache..");
        targetAccount = this.getCachedAccountRecordFromAllCaches(parameters);
        if (null == targetAccount) {
            String clientId = parameters.getClientId();
            String homeAccountId = parameters.getAccount().getHomeAccountId();
            if (Logger.isAllowPii()) {
                Logger.errorPII(methodTag, "No accounts found for clientId [" + clientId + "], homeAccountId [" + homeAccountId + "]", null);
            } else {
                Logger.error(methodTag, "No accounts found for clientId [" + clientId + "]", null);
            }
            throw new ClientException("no_account_found", "No cached accounts found for the supplied " + (isB2CAuthority ? "homeAccountId" : "localAccountId"));
        }
        return targetAccount;
    }

    @Nullable
    private AccountRecord getCachedAccountRecordFromCallingAppCache(@NonNull SilentTokenCommandParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        boolean isB2CAuthority = "B2C".equalsIgnoreCase(parameters.getAuthority().getAuthorityTypeString());
        String clientId = parameters.getClientId();
        String homeAccountId = parameters.getAccount().getHomeAccountId();
        String localAccountId = parameters.getAccount().getLocalAccountId();
        String environment = parameters.getAccount().getEnvironment();
        AccountRecord targetAccount = isB2CAuthority ? parameters.getOAuth2TokenCache().getAccountByHomeAccountId(null, clientId, homeAccountId) : parameters.getOAuth2TokenCache().getAccountByLocalAccountId(environment, clientId, localAccountId);
        return targetAccount;
    }

    @Nullable
    protected AccountRecord getCachedAccountRecordFromAllCaches(@NonNull SilentTokenCommandParameters parameters) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (parameters.getOAuth2TokenCache() instanceof MsalOAuth2TokenCache) {
            return this.getAccountWithFRTIfAvailable(parameters, (MsalOAuth2TokenCache)parameters.getOAuth2TokenCache());
        }
        return null;
    }

    @Nullable
    private AccountRecord getAccountWithFRTIfAvailable(@NonNull SilentTokenCommandParameters parameters, @NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (msalOAuth2TokenCache == null) {
            throw new NullPointerException("msalOAuth2TokenCache is marked non-null but is null");
        }
        String methodTag = TAG + ":getAccountWithFRTIfAvailable";
        String homeAccountId = parameters.getAccount().getHomeAccountId();
        String clientId = parameters.getClientId();
        RefreshTokenRecord refreshTokenRecord = msalOAuth2TokenCache.getFamilyRefreshTokenForHomeAccountId(homeAccountId);
        if (refreshTokenRecord != null) {
            try {
                FociQueryUtilities.tryFociTokenWithGivenClientId(parameters.getOAuth2TokenCache(), clientId, parameters.getRedirectUri(), refreshTokenRecord, parameters.getAccount());
                return parameters.getOAuth2TokenCache().getAccountByLocalAccountId(null, clientId, parameters.getAccount().getLocalAccountId());
            }
            catch (ClientException | IOException e) {
                Logger.warn(methodTag, "Error while attempting to validate client: " + clientId + " is part of family " + e.getMessage());
            }
        } else {
            Logger.info(methodTag, "No Foci tokens found for homeAccountId " + homeAccountId);
        }
        return null;
    }

    protected boolean isRequestAuthorityRealmSameAsATRealm(@NonNull Authority requestAuthority, @NonNull AccessTokenRecord accessTokenRecord) throws ServiceException, ClientException {
        if (requestAuthority == null) {
            throw new NullPointerException("requestAuthority is marked non-null but is null");
        }
        if (accessTokenRecord == null) {
            throw new NullPointerException("accessTokenRecord is marked non-null but is null");
        }
        if (requestAuthority instanceof AzureActiveDirectoryAuthority) {
            String tenantId = ((AzureActiveDirectoryAuthority)requestAuthority).getAudience().getTenantId();
            if (AzureActiveDirectoryAudience.isHomeTenantAlias(tenantId)) {
                String utidFromHomeAccountId = accessTokenRecord.getHomeAccountId().split(Pattern.quote("."))[1];
                return utidFromHomeAccountId.equalsIgnoreCase(accessTokenRecord.getRealm());
            }
            tenantId = ((AzureActiveDirectoryAuthority)requestAuthority).getAudience().getTenantUuidForAlias(requestAuthority.getAuthorityURL().toString());
            return tenantId.equalsIgnoreCase(accessTokenRecord.getRealm());
        }
        return true;
    }

    protected boolean isMsaAccount(MicrosoftTokenResponse microsoftTokenResponse) {
        String tenantId = SchemaUtil.getTenantId(microsoftTokenResponse.getClientInfo(), microsoftTokenResponse.getIdToken());
        return "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(tenantId);
    }

    public ICacheRecord finalizeCacheRecordForResult(@NonNull ICacheRecord cacheRecord, @NonNull AbstractAuthenticationScheme scheme) throws ClientException {
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        if (scheme instanceof ITokenAuthenticationSchemeInternal && !StringUtil.isNullOrEmpty(cacheRecord.getAccessToken().getSecret())) {
            ITokenAuthenticationSchemeInternal tokenAuthScheme = (ITokenAuthenticationSchemeInternal)((Object)scheme);
            cacheRecord.getAccessToken().setSecret(tokenAuthScheme.getAccessTokenForScheme(cacheRecord.getAccessToken().getSecret()));
        }
        return cacheRecord;
    }

    public abstract GenerateShrResult generateSignedHttpRequest(GenerateShrCommandParameters var1) throws Exception;

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseController)) {
            return false;
        }
        BaseController other = (BaseController)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseController;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

