/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.ICryptoFactory;
import com.microsoft.identity.common.java.crypto.IDecryptor;
import com.microsoft.identity.common.java.exception.ClientException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import lombok.NonNull;

public class BasicDecryptor
implements IDecryptor {
    private final ICryptoFactory mCryptoFactory;

    @Override
    public byte[] decrypt(@NonNull Key key, @NonNull String decryptAlgorithm, byte[] iv, byte[] dataToBeDecrypted) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (decryptAlgorithm == null) {
            throw new NullPointerException("decryptAlgorithm is marked non-null but is null");
        }
        try {
            Cipher cipher = this.mCryptoFactory.getCipher(decryptAlgorithm);
            if (iv != null && iv.length > 0) {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(2, key, ivSpec);
            } else {
                cipher.init(2, key);
            }
            return cipher.doFinal(dataToBeDecrypted);
        }
        catch (BadPaddingException e) {
            throw new ClientException("bad_padding", e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ClientException("invalid_block_size", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ClientException("invalid_algorithm_parameter", e.getMessage(), e);
        }
    }

    public BasicDecryptor(ICryptoFactory mCryptoFactory) {
        this.mCryptoFactory = mCryptoFactory;
    }
}

