/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.ICryptoFactory;
import com.microsoft.identity.common.java.crypto.IHMacSigner;
import com.microsoft.identity.common.java.exception.ClientException;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public class BasicHMacSigner
implements IHMacSigner {
    private final ICryptoFactory mCryptoFactory;

    @Override
    public byte[] sign(byte[] keyData, @NonNull String hmacAlgorithm, byte[] dataToBeSigned) throws ClientException {
        if (hmacAlgorithm == null) {
            throw new NullPointerException("hmacAlgorithm is marked non-null but is null");
        }
        try {
            Mac sha256HMAC = this.mCryptoFactory.getMac(hmacAlgorithm);
            SecretKeySpec secretKey = new SecretKeySpec(keyData, hmacAlgorithm);
            sha256HMAC.init(secretKey);
            return sha256HMAC.doFinal(dataToBeSigned);
        }
        catch (IllegalStateException e) {
            throw new ClientException("encryption_error", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
    }

    public BasicHMacSigner(ICryptoFactory cryptoFactory) {
        this.mCryptoFactory = cryptoFactory;
    }
}

