/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.ICryptoFactory;
import com.microsoft.identity.common.java.crypto.ProviderFactory;
import com.microsoft.identity.common.java.exception.ClientException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import lombok.NonNull;

public class DefaultCryptoFactory
implements ICryptoFactory {
    @Override
    @NonNull
    public Signature getSignature(@NonNull String algorithm) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return ProviderFactory.getSignature(algorithm, null);
    }

    @Override
    @NonNull
    public Cipher getCipher(@NonNull String algorithm) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return ProviderFactory.getCipher(algorithm, null);
    }

    @Override
    @NonNull
    public Mac getMac(@NonNull String algorithm) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return ProviderFactory.getMac(algorithm, null);
    }

    @Override
    @NonNull
    public KeyPairGenerator getKeyPairGenerator(@NonNull String algorithm) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return ProviderFactory.getKeyPairGenerator(algorithm, null);
    }

    @Override
    @NonNull
    public KeyFactory getKeyFactory(@NonNull String algorithm) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return ProviderFactory.getKeyFactory(algorithm, null);
    }
}

