/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.ICryptoFactory;
import com.microsoft.identity.common.java.exception.ClientException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SP800108KeyGen {
    static final byte[] BIG_ENDIAN_INT_256 = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(256).array();
    private final ICryptoFactory mCryptoFactory;

    public byte[] generateDerivedKey(byte[] key, byte[] label, byte[] ctx) throws IOException, InvalidKeyException, NoSuchAlgorithmException, ClientException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(label);
        stream.write(0);
        stream.write(ctx);
        stream.write(BIG_ENDIAN_INT_256);
        byte[] pbDerivedKey = this.constructNewKey(key, stream.toByteArray());
        return Arrays.copyOf(pbDerivedKey, 32);
    }

    private byte[] constructNewKey(byte[] keyDerivationKey, byte[] fixedInput) throws IOException, InvalidKeyException, ClientException {
        int len;
        int outputSizeBit = 256;
        int numCurrentElements = 0;
        byte ctr = 1;
        byte[] keyDerivated = new byte[outputSizeBit / 8];
        SecretKeySpec keySpec = new SecretKeySpec(keyDerivationKey, "HmacSHA256");
        Mac hmacSHA256 = this.mCryptoFactory.getMac("HmacSHA256");
        do {
            byte[] dataInput = SP800108KeyGen.updateDataInput(ctr, fixedInput);
            hmacSHA256.reset();
            hmacSHA256.init(keySpec);
            hmacSHA256.update(dataInput);
            byte[] cHMAC = hmacSHA256.doFinal();
            len = 256 >= outputSizeBit ? outputSizeBit : Math.min(256, outputSizeBit - numCurrentElements);
            int numCurrentElementsBytes = numCurrentElements / 8;
            System.arraycopy(cHMAC, 0, keyDerivated, numCurrentElementsBytes, 32);
            ctr = (byte)(ctr + 1);
        } while ((numCurrentElements += len) < outputSizeBit);
        return keyDerivated;
    }

    private static byte[] updateDataInput(byte ctr, byte[] fixedInput) throws IOException {
        ByteArrayOutputStream tmpFixedInput = new ByteArrayOutputStream(fixedInput.length + 4);
        tmpFixedInput.write(ctr >>> 24);
        tmpFixedInput.write(ctr >>> 16);
        tmpFixedInput.write(ctr >>> 8);
        tmpFixedInput.write(ctr);
        tmpFixedInput.write(fixedInput);
        return tmpFixedInput.toByteArray();
    }

    public SP800108KeyGen(ICryptoFactory cryptoFactory) {
        this.mCryptoFactory = cryptoFactory;
    }
}

