/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.marker;

import java.util.LinkedHashMap;

public class CodeMarker {
    private static final String csvNoValue = "NA";
    private static final char csvSeparator = ',';
    private final String marker;
    private final long timeInMilliseconds;
    private final String timeStamp;
    private final long threadId;
    private String cpuUsed = null;
    private String cpuTotal = null;
    private String residentSize = null;
    private String virtualSize = null;
    private String wifiSent = null;
    private String wifiRecv = null;
    private String wwanSent = null;
    private String wwanRecv = null;
    private String appSent = null;
    private String appRecv = null;
    private String battery = null;
    private String systemDiskRead = null;
    private String systemDiskWrite = null;

    public CodeMarker(String marker, long timeInMilliseconds, String timeStamp, long threadId) {
        this.marker = marker;
        this.timeInMilliseconds = timeInMilliseconds;
        this.timeStamp = timeStamp;
        this.threadId = threadId;
    }

    private LinkedHashMap<String, String> getKeyValuePairsOfCodeMarker() {
        LinkedHashMap<String, String> csvKeyValuePairs = new LinkedHashMap<String, String>();
        csvKeyValuePairs.put("TimeStamp", this.timeStamp == null ? csvNoValue : this.timeStamp);
        csvKeyValuePairs.put("Marker", this.marker == null ? csvNoValue : this.marker);
        csvKeyValuePairs.put("Time", Long.toString(this.timeInMilliseconds));
        csvKeyValuePairs.put("Thread", Long.toString(this.threadId));
        csvKeyValuePairs.put("CpuUsed", this.cpuUsed == null ? csvNoValue : this.cpuUsed);
        csvKeyValuePairs.put("CpuTotal", this.cpuTotal == null ? csvNoValue : this.cpuTotal);
        csvKeyValuePairs.put("ResidentSize", this.residentSize == null ? csvNoValue : this.residentSize);
        csvKeyValuePairs.put("VirtualSize", this.virtualSize == null ? csvNoValue : this.virtualSize);
        csvKeyValuePairs.put("WifiSent", this.wifiSent == null ? csvNoValue : this.wifiSent);
        csvKeyValuePairs.put("WifiRecv", this.wifiRecv == null ? csvNoValue : this.wifiRecv);
        csvKeyValuePairs.put("WwanSent", this.wwanSent == null ? csvNoValue : this.wwanSent);
        csvKeyValuePairs.put("WwanRecv", this.wwanRecv == null ? csvNoValue : this.wwanRecv);
        csvKeyValuePairs.put("AppSent", this.appSent == null ? csvNoValue : this.appSent);
        csvKeyValuePairs.put("AppRecv", this.appRecv == null ? csvNoValue : this.appRecv);
        csvKeyValuePairs.put("Battery", this.battery == null ? csvNoValue : this.battery);
        csvKeyValuePairs.put("SystemDiskRead", this.systemDiskRead == null ? csvNoValue : this.systemDiskRead);
        csvKeyValuePairs.put("SystemDiskWrite", this.systemDiskWrite == null ? csvNoValue : this.systemDiskWrite);
        return csvKeyValuePairs;
    }

    public String getCsvHeader() {
        StringBuilder csvStringBuilder = new StringBuilder();
        LinkedHashMap<String, String> csvKeyValuePairs = this.getKeyValuePairsOfCodeMarker();
        int index = 0;
        for (String key : csvKeyValuePairs.keySet()) {
            if (index != 0) {
                csvStringBuilder.append(',');
            }
            csvStringBuilder.append(key);
            ++index;
        }
        return csvStringBuilder.toString();
    }

    public String getCsvLine() {
        StringBuilder csvStringBuilder = new StringBuilder();
        LinkedHashMap<String, String> csvKeyValuePairs = this.getKeyValuePairsOfCodeMarker();
        int index = 0;
        for (String value : csvKeyValuePairs.values()) {
            if (index != 0) {
                csvStringBuilder.append(',');
            }
            csvStringBuilder.append(value);
            ++index;
        }
        return csvStringBuilder.toString();
    }
}

