/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.platform;

import com.microsoft.identity.common.java.crypto.IKeyStoreKeyManager;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import lombok.NonNull;

public abstract class AbstractKeyStoreKeyManager<K extends KeyStore.Entry>
implements IKeyStoreKeyManager<K> {
    private static final String TAG = AbstractKeyStoreKeyManager.class.getSimpleName();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected final KeyStore mKeyStore;
    private final String mKeyAlias;
    private final KeyStore.PasswordProtection mPasswordProtection;

    public AbstractKeyStoreKeyManager(@NonNull KeyStore keyStore, @NonNull String keyAlias, @Nullable KeyStore.PasswordProtection passwordProtection) throws KeyStoreException {
        if (keyStore == null) {
            throw new NullPointerException("keyStore is marked non-null but is null");
        }
        if (keyAlias == null) {
            throw new NullPointerException("keyAlias is marked non-null but is null");
        }
        this.mKeyAlias = keyAlias;
        this.mKeyStore = keyStore;
        this.mPasswordProtection = passwordProtection;
    }

    @Override
    public boolean exists() {
        boolean exists = false;
        try {
            exists = this.mKeyStore.containsAlias(this.mKeyAlias);
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while querying KeyStore", e);
        }
        return exists;
    }

    @Override
    public boolean hasThumbprint(byte[] thumbprint) {
        try {
            return Arrays.equals(thumbprint, this.getThumbprint());
        }
        catch (ClientException e) {
            return false;
        }
    }

    @Override
    public Date getCreationDate() throws ClientException {
        try {
            return this.mKeyStore.getCreationDate(this.mKeyAlias);
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while getting creation date for alias " + this.mKeyAlias, e);
            throw new ClientException("keystore_not_initialized", e.getMessage(), e);
        }
    }

    @Override
    public boolean clear() {
        boolean deleted = false;
        try {
            this.mKeyStore.deleteEntry(this.mKeyAlias);
            deleted = true;
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while clearing KeyStore", e);
        }
        return deleted;
    }

    @Override
    public K getEntry() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        return (K)this.mKeyStore.getEntry(this.mKeyAlias, this.mPasswordProtection);
    }

    @Override
    public void importKey(@NonNull byte[] jwk, @NonNull String algorithm) throws ClientException {
        if (jwk == null) {
            throw new NullPointerException("jwk is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        throw new UnsupportedOperationException("This is not currently supported");
    }

    @Override
    public byte[] getThumbprint() throws ClientException {
        String errCode;
        Throwable exception;
        try {
            K entry = this.getEntry();
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                return AbstractKeyStoreKeyManager.getRsaThumbprint((KeyStore.PrivateKeyEntry)entry).getBytes(UTF8);
            }
            if (entry instanceof KeyStore.SecretKeyEntry) {
                return AbstractKeyStoreKeyManager.getSecretKeyThumbprint((KeyStore.SecretKeyEntry)entry);
            }
            throw new UnsupportedOperationException("Get thumbprint currently not supported for key of type: " + entry.getClass().getCanonicalName());
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    public Certificate[] getCertificateChain() throws ClientException {
        try {
            return this.mKeyStore.getCertificateChain(this.mKeyAlias);
        }
        catch (KeyStoreException e) {
            KeyStoreException exception = e;
            String errCode = "keystore_not_initialized";
            ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
            Logger.error(TAG, clientException.getMessage(), clientException);
            throw clientException;
        }
    }

    public static String getRsaThumbprint(@NonNull KeyStore.PrivateKeyEntry entry) throws JOSEException {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        KeyPair rsaKeyPair = AbstractKeyStoreKeyManager.getKeyPairForEntry(entry);
        RSAKey rsaKey = AbstractKeyStoreKeyManager.getRsaKeyForKeyPair(rsaKeyPair);
        return AbstractKeyStoreKeyManager.getThumbprintForRsaKey(rsaKey);
    }

    public static byte[] getSecretKeyThumbprint(@NonNull KeyStore.SecretKeyEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        try {
            SecretKey key = entry.getSecretKey();
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            MessageDigest digest = MessageDigest.getInstance("SHA256");
            return digest.digest(cipher.doFinal((key.getAlgorithm() + cipher.getBlockSize() + cipher.getParameters()).getBytes(UTF8)));
        }
        catch (NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            Logger.error("KeyAccessor:newInstance", null, "Exception while getting key entry", e);
            return null;
        }
    }

    public static KeyPair getKeyPairForEntry(@NonNull KeyStore.PrivateKeyEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PrivateKey privateKey = entry.getPrivateKey();
        PublicKey publicKey = entry.getCertificate().getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public static RSAKey getRsaKeyForKeyPair(@NonNull KeyPair keyPair) {
        if (keyPair == null) {
            throw new NullPointerException("keyPair is marked non-null but is null");
        }
        if (keyPair.getPublic() instanceof RSAPublicKey) {
            return new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).keyUse(null).build();
        }
        throw new UnsupportedOperationException("Cannot get RSAKey for key of type: " + keyPair.getPublic().getClass().getCanonicalName());
    }

    public static String getThumbprintForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException {
        if (rsaKey == null) {
            throw new NullPointerException("rsaKey is marked non-null but is null");
        }
        Base64URL thumbprint = rsaKey.computeThumbprint();
        return thumbprint.toString();
    }

    @Override
    public String getKeyAlias() {
        return this.mKeyAlias;
    }
}

