/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AuthorizationRequest<T extends AuthorizationRequest<T>>
implements Serializable {
    private static final String TAG = AuthorizationRequest.class.getSimpleName();
    private static final long serialVersionUID = 6171895895590170062L;
    @Expose
    @SerializedName(value="response_type")
    private final String mResponseType;
    @Expose
    @SerializedName(value="client_id")
    private final String mClientId;
    @SerializedName(value="redirect_uri")
    private final String mRedirectUri;
    @Expose
    @SerializedName(value="state")
    private final String mState;
    @Expose
    @SerializedName(value="scope")
    private final String mScope;
    @Expose
    @SerializedName(value="claims")
    private final String mClaims;
    @Expose
    private final transient boolean mWebViewZoomControlsEnabled;
    @Expose
    private final transient boolean mWebViewZoomEnabled;
    private final transient HashMap<String, String> mRequestHeaders;
    private final transient List<Map.Entry<String, String>> mExtraQueryParams;

    protected AuthorizationRequest(Builder builder) {
        HashMap requestHeaders;
        this.mResponseType = builder.mResponseType;
        this.mClientId = builder.mClientId;
        this.mRedirectUri = builder.mRedirectUri;
        this.mState = builder.mState == null ? null : StringUtil.encodeUrlSafeString(builder.mState);
        this.mScope = builder.mScope;
        List<Map.Entry<String, String>> extraQueryParams = builder.mExtraQueryParams;
        this.mExtraQueryParams = extraQueryParams;
        this.mRequestHeaders = requestHeaders = builder.mRequestHeaders;
        this.mClaims = builder.mClaims;
        this.mWebViewZoomEnabled = builder.mWebViewZoomEnabled;
        this.mWebViewZoomControlsEnabled = builder.mWebViewZoomControlsEnabled;
    }

    public String toString() {
        return "AuthorizationRequest{mResponseType='" + this.mResponseType + '\'' + ", mClientId='" + this.mClientId + '\'' + ", mRedirectUri='" + this.mRedirectUri + '\'' + ", mScope='" + this.mScope + '\'' + ", mState='" + this.mState + '\'' + '}';
    }

    public abstract String getAuthorizationEndpoint() throws ClientException;

    public URI getAuthorizationRequestAsHttpRequest() throws ClientException {
        try {
            CommonURIBuilder builder = new CommonURIBuilder(this.getAuthorizationEndpoint());
            builder.addParametersIfAbsent(ObjectMapper.serializeObjectHashMap(this));
            builder.addParametersIfAbsent(this.mExtraQueryParams);
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new ClientException("malformed_url", e.getMessage(), e);
        }
    }

    public String getResponseType() {
        return this.mResponseType;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public String getState() {
        return this.mState;
    }

    public String getScope() {
        return this.mScope;
    }

    public String getClaims() {
        return this.mClaims;
    }

    public boolean isWebViewZoomControlsEnabled() {
        return this.mWebViewZoomControlsEnabled;
    }

    public boolean isWebViewZoomEnabled() {
        return this.mWebViewZoomEnabled;
    }

    public HashMap<String, String> getRequestHeaders() {
        return this.mRequestHeaders;
    }

    public List<Map.Entry<String, String>> getExtraQueryParams() {
        return this.mExtraQueryParams;
    }

    public static abstract class Builder<B extends Builder<B>> {
        private String mResponseType = "code";
        private String mClientId;
        private String mRedirectUri;
        private String mState;
        private String mScope;
        private String mClaims;
        private HashMap<String, String> mRequestHeaders;
        private boolean mWebViewZoomControlsEnabled = false;
        private boolean mWebViewZoomEnabled = false;
        public List<Map.Entry<String, String>> mExtraQueryParams;

        public B setResponseType(String responseType) {
            this.mResponseType = responseType;
            return this.self();
        }

        public B setClientId(String clientId) {
            this.mClientId = clientId;
            return this.self();
        }

        public B setRedirectUri(String redirectUri) {
            this.mRedirectUri = redirectUri;
            return this.self();
        }

        public B setState(String state) {
            this.mState = state;
            return this.self();
        }

        public B setScope(String scope) {
            this.mScope = scope;
            return this.self();
        }

        public B setExtraQueryParams(List<Map.Entry<String, String>> extraQueryParams) {
            this.mExtraQueryParams = extraQueryParams;
            return this.self();
        }

        public B setClaims(String claims) {
            this.mClaims = claims;
            return this.self();
        }

        public B setRequestHeaders(HashMap<String, String> requestHeaders) {
            this.mRequestHeaders = requestHeaders;
            return this.self();
        }

        public B setWebViewZoomEnabled(boolean webViewZoomEnabled) {
            this.mWebViewZoomEnabled = webViewZoomEnabled;
            return this.self();
        }

        public B setWebViewZoomControlsEnabled(boolean webViewZoomControlsEnabled) {
            this.mWebViewZoomControlsEnabled = webViewZoomControlsEnabled;
            return this.self();
        }

        public abstract B self();

        public abstract AuthorizationRequest build();
    }

    public static final class ResponseType {
        public static final String CODE = "code";
    }
}

