/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.cache.AccountDeletionRecord;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public abstract class OAuth2TokenCache<T extends OAuth2Strategy, U extends AuthorizationRequest, V extends TokenResponse> {
    public static final String ERR_UNSUPPORTED_OPERATION = "This method is unsupported.";
    @NonNull
    private final IPlatformComponents mPlatformComponents;

    public abstract ICacheRecord save(T var1, U var2, V var3) throws ClientException;

    public abstract List<ICacheRecord> saveAndLoadAggregatedAccountData(T var1, U var2, V var3) throws ClientException;

    public abstract ICacheRecord save(AccountRecord var1, IdTokenRecord var2);

    public abstract ICacheRecord load(String var1, String var2, AccountRecord var3, AbstractAuthenticationScheme var4);

    public abstract List<ICacheRecord> loadWithAggregatedAccountData(String var1, String var2, AccountRecord var3, AbstractAuthenticationScheme var4);

    public abstract boolean removeCredential(Credential var1);

    public abstract AccountRecord getAccount(String var1, String var2, String var3, String var4);

    public abstract List<ICacheRecord> getAccountsWithAggregatedAccountData(String var1, String var2, String var3);

    public abstract AccountRecord getAccountByLocalAccountId(String var1, String var2, String var3);

    public abstract ICacheRecord getAccountWithAggregatedAccountDataByLocalAccountId(String var1, String var2, String var3);

    public abstract List<AccountRecord> getAccounts(String var1, String var2);

    public abstract List<AccountRecord> getAllTenantAccountsForAccountByClientId(String var1, AccountRecord var2);

    public abstract List<ICacheRecord> getAccountsWithAggregatedAccountData(String var1, String var2);

    public abstract List<IdTokenRecord> getIdTokensForAccountRecord(String var1, AccountRecord var2);

    public abstract AccountDeletionRecord removeAccount(String var1, String var2, String var3, String var4);

    public abstract AccountDeletionRecord removeAccount(String var1, String var2, String var3, String var4, CredentialType ... var5);

    public abstract void clearAll();

    protected abstract Set<String> getAllClientIds();

    protected final IPlatformComponents getComponents() {
        return this.mPlatformComponents;
    }

    public abstract AccountRecord getAccountByHomeAccountId(@Nullable String var1, @NonNull String var2, @NonNull String var3);

    public OAuth2TokenCache(@NonNull IPlatformComponents mPlatformComponents) {
        if (mPlatformComponents == null) {
            throw new NullPointerException("mPlatformComponents is marked non-null but is null");
        }
        this.mPlatformComponents = mPlatformComponents;
    }
}

