/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.storage;

import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.storage.IGenericTypeStringAdapter;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.Predicate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;

public class MultiTypeNameValueStorage
implements IMultiTypeNameValueStorage {
    private final INameValueStorage<String> mNameValueStringStorage;

    @Override
    public void putString(@NonNull String key, @Nullable String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.mNameValueStringStorage.put(key, value);
    }

    @Override
    public String getString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.mNameValueStringStorage.get(key);
    }

    @Override
    public void putLong(@NonNull String key, long value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.mNameValueStringStorage.put(key, IGenericTypeStringAdapter.LongStringAdapter.adapt(value));
    }

    @Override
    public long getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String val = this.mNameValueStringStorage.get(key);
        if (StringUtil.isNullOrEmpty(val)) {
            return 0L;
        }
        return IGenericTypeStringAdapter.LongStringAdapter.adapt(val);
    }

    @Override
    public Map<String, String> getAll() {
        return this.mNameValueStringStorage.getAll();
    }

    @Override
    public Iterator<Map.Entry<String, String>> getAllFilteredByKey(@NonNull Predicate<String> keyFilter) {
        if (keyFilter == null) {
            throw new NullPointerException("keyFilter is marked non-null but is null");
        }
        return this.mNameValueStringStorage.getAllFilteredByKey(keyFilter);
    }

    @Override
    public boolean contains(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return !StringUtil.isNullOrEmpty(this.getString(key));
    }

    @Override
    public void clear() {
        this.mNameValueStringStorage.clear();
    }

    @Override
    public void remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.mNameValueStringStorage.remove(key);
    }

    public MultiTypeNameValueStorage(INameValueStorage<String> mNameValueStringStorage) {
        this.mNameValueStringStorage = mNameValueStringStorage;
    }
}

