/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.adapter;

import com.microsoft.identity.common.java.telemetry.adapter.TelemetryAggregationAdapter;
import com.microsoft.identity.common.java.telemetry.observers.IBrokerTelemetryObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class BrokerTelemetryAdapter
extends TelemetryAggregationAdapter {
    public BrokerTelemetryAdapter(@NonNull IBrokerTelemetryObserver observer) {
        super(observer);
        if (observer == null) {
            throw new NullPointerException("observer is marked non-null but is null");
        }
    }

    @Override
    public void process(@NonNull List<Map<String, String>> rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData is marked non-null but is null");
        }
        Map<String, String> aggregatedMap = this.aggregateEvent(rawData);
        List<Map<String, String>> errorEvents = this.filterErrorEvents(rawData, aggregatedMap);
        List<Map<String, String>> countedErrors = this.countErrors(errorEvents);
        for (Map<String, String> errorEvent : countedErrors) {
            this.getObserver().onReceived(errorEvent);
        }
        this.getObserver().onReceived(aggregatedMap);
    }

    private List<Map<String, String>> filterErrorEvents(@NonNull List<Map<String, String>> rawData, @NonNull Map<String, String> aggregatedMap) {
        if (rawData == null) {
            throw new NullPointerException("rawData is marked non-null but is null");
        }
        if (aggregatedMap == null) {
            throw new NullPointerException("aggregatedMap is marked non-null but is null");
        }
        ArrayList<Map<String, String>> errorEvents = new ArrayList<Map<String, String>>();
        for (Map<String, String> event : rawData) {
            if (!"Microsoft.MSAL.error_event".equals(event.get("Microsoft.MSAL.event_type"))) continue;
            HashMap<String, String> errorEvent = new HashMap<String, String>(aggregatedMap);
            errorEvent.putAll(event);
            errorEvent.put("Microsoft.MSAL.is_error_event", "true");
            errorEvents.add(errorEvent);
        }
        return errorEvents;
    }

    private List<Map<String, String>> countErrors(@NonNull List<Map<String, String>> errorEvents) {
        if (errorEvents == null) {
            throw new NullPointerException("errorEvents is marked non-null but is null");
        }
        HashMap<String, Map> countedErrors = new HashMap<String, Map>();
        for (Map<String, String> errorEvent : errorEvents) {
            Map errorProperties;
            String errorTag = errorEvent.get("Microsoft.MSAL.error_tag");
            int errorCount = 1;
            Map map = errorProperties = countedErrors.containsKey(errorTag) ? (Map)countedErrors.get(errorTag) : this.applyAggregationRule(errorEvent);
            if (countedErrors.containsKey(errorTag)) {
                errorCount += Integer.parseInt((String)errorProperties.get("Microsoft.MSAL.error_count"));
            } else {
                countedErrors.put(errorTag, errorProperties);
            }
            errorProperties.put("Microsoft.MSAL.error_count", String.valueOf(errorCount));
        }
        return new ArrayList<Map<String, String>>(countedErrors.values());
    }
}

