/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.util.StringUtil;
import io.opentelemetry.api.trace.Span;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class HashMapExtensions {
    public static HashMap<String, String> getJsonResponse(HttpResponse webResponse) throws JSONException {
        if (webResponse != null && !StringUtil.isNullOrEmpty(webResponse.getBody())) {
            return HashMapExtensions.getJsonResponseFromResponseBody(webResponse.getBody());
        }
        return new HashMap<String, String>();
    }

    public static HashMap<String, String> getJsonResponseFromResponseBody(String responseBody) throws JSONException {
        HashMap<String, String> response = new HashMap<String, String>();
        Span span = Span.current();
        span.setAttribute(AttributeName.response_body_length.name(), (long)responseBody.length());
        if (!StringUtil.isNullOrEmpty(responseBody)) {
            JSONObject jsonObject = new JSONObject(responseBody);
            Iterator keyIterator = jsonObject.keys();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                response.put(key, jsonObject.get(key).toString());
            }
        }
        return response;
    }
}

