/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.components;

import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.cache.MapBackedPreferencesManager;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IStorageSupplier;
import com.microsoft.identity.common.java.util.ported.InMemoryStorage;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class InMemoryStorageSupplier
implements IStorageSupplier {
    private final Map<String, INameValueStorage<?>> mStores = new ConcurrentHashMap();
    private final Map<String, IMultiTypeNameValueStorage> mEncryptedFileStores = new ConcurrentHashMap<String, IMultiTypeNameValueStorage>();
    private final Map<String, IMultiTypeNameValueStorage> mFileStores = new ConcurrentHashMap<String, IMultiTypeNameValueStorage>();

    @Override
    @NonNull
    public <T> INameValueStorage<T> getEncryptedNameValueStore(@NonNull String storeName, @Nullable IKeyAccessor helper, @NonNull Class<T> clazz) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        INameValueStorage<?> ret = this.mStores.get(storeName);
        if (ret == null) {
            this.mStores.put(storeName, new InMemoryStorage());
            ret = this.mStores.get(storeName);
        }
        return ret;
    }

    @Override
    public synchronized IMultiTypeNameValueStorage getEncryptedFileStore(@NonNull String storeName, @NonNull IKeyAccessor helper) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (helper == null) {
            throw new NullPointerException("helper is marked non-null but is null");
        }
        IMultiTypeNameValueStorage ret = this.mEncryptedFileStores.get(storeName);
        if (ret == null) {
            this.mEncryptedFileStores.put(storeName, MapBackedPreferencesManager.builder().name(storeName).build());
            ret = this.mEncryptedFileStores.get(storeName);
        }
        return ret;
    }

    @Override
    public IMultiTypeNameValueStorage getFileStore(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        IMultiTypeNameValueStorage ret = this.mFileStores.get(storeName);
        if (ret == null) {
            this.mFileStores.put(storeName, MapBackedPreferencesManager.builder().name(storeName).build());
            ret = this.mFileStores.get(storeName);
        }
        return ret;
    }

    @Override
    public INameValueStorage<String> getMultiProcessStringStore(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        INameValueStorage<String> ret = this.mStores.get(storeName);
        if (ret == null) {
            this.mStores.put(storeName, new InMemoryStorage());
            ret = this.mStores.get(storeName);
        }
        return ret;
    }
}

