/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MicrosoftStsAccountCredentialAdapter
implements IAccountCredentialAdapter<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> {
    private static final String TAG = MicrosoftStsAccountCredentialAdapter.class.getSimpleName();

    @Override
    public AccountRecord createAccount(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        Logger.verbose(TAG, "Creating Account");
        return new AccountRecord(strategy.createAccount(response));
    }

    @Override
    public AccessTokenRecord createAccessToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            long cachedAt = this.getCachedAt();
            long expiresOn = this.getExpiresOn(response);
            long refreshOn = this.getRefreshOn(response);
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            AccessTokenRecord accessToken = new AccessTokenRecord();
            accessToken.setCredentialType(this.getCredentialType(StringUtil.sanitizeNull(response.getTokenType())));
            accessToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            accessToken.setRealm(this.getRealm(strategy, response));
            accessToken.setEnvironment(strategy.getIssuerCacheIdentifierFromTokenEndpoint());
            accessToken.setClientId(request.getClientId());
            accessToken.setTarget(this.getTarget(request.getScope(), response.getScope()));
            accessToken.setCachedAt(String.valueOf(cachedAt));
            accessToken.setExpiresOn(String.valueOf(expiresOn));
            accessToken.setRefreshOn(String.valueOf(refreshOn));
            accessToken.setSecret(response.getAccessToken());
            accessToken.setExtendedExpiresOn(this.getExtendedExpiresOn(response));
            accessToken.setAuthority(strategy.getAuthorityFromTokenEndpoint());
            accessToken.setAccessTokenType(response.getTokenType());
            accessToken.setApplicationIdentifier(request.getApplicationIdentifier());
            accessToken.setMamEnrollmentIdentifier(request.getMamEnrollmentIdentifier());
            if ("pop".equalsIgnoreCase(response.getTokenType())) {
                accessToken.setKid(strategy.getDeviceAtPopThumbprint());
            }
            return accessToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private String getCredentialType(@NonNull String tokenType) {
        if (tokenType == null) {
            throw new NullPointerException("tokenType is marked non-null but is null");
        }
        String type = CredentialType.AccessToken.name();
        if ("pop".equalsIgnoreCase(tokenType)) {
            return CredentialType.AccessToken_With_AuthScheme.name();
        }
        return type;
    }

    private String getTarget(@Nullable String requestScope, @Nullable String responseScope) {
        if (StringUtil.isNullOrEmpty(responseScope)) {
            StringBuilder scopesToCache = new StringBuilder();
            String[] requestScopes = requestScope.split("\\s+");
            HashSet<String> requestScopeSet = new HashSet<String>(Arrays.asList(requestScopes));
            requestScopeSet.removeAll(AuthenticationConstants.DEFAULT_SCOPES);
            for (String scope : requestScopeSet) {
                scopesToCache.append(scope).append(' ');
            }
            return scopesToCache.toString().trim();
        }
        return responseScope;
    }

    @Override
    public RefreshTokenRecord createRefreshToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            long cachedAt = this.getCachedAt();
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            RefreshTokenRecord refreshToken = new RefreshTokenRecord();
            refreshToken.setCredentialType(CredentialType.RefreshToken.name());
            refreshToken.setEnvironment(strategy.getIssuerCacheIdentifierFromTokenEndpoint());
            refreshToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            refreshToken.setClientId(request.getClientId());
            refreshToken.setSecret(response.getRefreshToken());
            refreshToken.setFamilyId(response.getFamilyId());
            refreshToken.setTarget(this.getTarget(request.getScope(), response.getScope()));
            refreshToken.setCachedAt(String.valueOf(cachedAt));
            return refreshToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IdTokenRecord createIdToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            IdTokenRecord idToken = new IdTokenRecord();
            idToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            idToken.setEnvironment(strategy.getIssuerCacheIdentifierFromTokenEndpoint());
            idToken.setRealm(this.getRealm(strategy, response));
            idToken.setCredentialType(SchemaUtil.getCredentialTypeFromVersion(response.getIdToken()));
            idToken.setClientId(request.getClientId());
            idToken.setSecret(response.getIdToken());
            idToken.setAuthority(strategy.getAuthorityFromTokenEndpoint());
            return idToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RefreshTokenRecord asRefreshToken(@NonNull MicrosoftRefreshToken refreshTokenIn) {
        if (refreshTokenIn == null) {
            throw new NullPointerException("refreshTokenIn is marked non-null but is null");
        }
        RefreshTokenRecord refreshTokenOut = new RefreshTokenRecord();
        refreshTokenOut.setHomeAccountId(refreshTokenIn.getHomeAccountId());
        refreshTokenOut.setEnvironment(refreshTokenIn.getEnvironment());
        refreshTokenOut.setCredentialType(CredentialType.RefreshToken.name());
        refreshTokenOut.setClientId(refreshTokenIn.getClientId());
        refreshTokenOut.setSecret(refreshTokenIn.getSecret());
        refreshTokenOut.setTarget(refreshTokenIn.getTarget());
        refreshTokenOut.setCachedAt(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        refreshTokenOut.setFamilyId(refreshTokenIn.getFamilyId());
        return refreshTokenOut;
    }

    @Override
    public AccountRecord asAccount(MicrosoftAccount account) {
        AccountRecord acct = new AccountRecord(account);
        return acct;
    }

    @Override
    public IdTokenRecord asIdToken(MicrosoftAccount msAccount, MicrosoftRefreshToken refreshToken) {
        long cachedAt = this.getCachedAt();
        IDToken msIdToken = msAccount.getIDToken();
        IdTokenRecord idToken = new IdTokenRecord();
        idToken.setHomeAccountId(refreshToken.getHomeAccountId());
        idToken.setEnvironment(refreshToken.getEnvironment());
        idToken.setRealm(msAccount.getRealm());
        idToken.setCredentialType(CredentialType.IdToken.name());
        idToken.setClientId(refreshToken.getClientId());
        idToken.setSecret(msIdToken.getRawIDToken());
        idToken.setCachedAt(String.valueOf(cachedAt));
        idToken.setAuthority(SchemaUtil.getAuthority(msIdToken));
        return idToken;
    }

    private String getExtendedExpiresOn(MicrosoftStsTokenResponse response) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSecs = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        long extExpiresIn = null == response.getExtExpiresIn() ? 0L : response.getExtExpiresIn();
        return String.valueOf(currentTimeSecs + extExpiresIn);
    }

    private String getRealm(MicrosoftStsOAuth2Strategy msStrategy, MicrosoftStsTokenResponse msTokenResponse) {
        MicrosoftStsAccount msAccount = msStrategy.createAccount(msTokenResponse);
        return msAccount.getRealm();
    }

    private long getCachedAt() {
        long currentTimeMillis = System.currentTimeMillis();
        return TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
    }

    private long getExpiresOn(MicrosoftStsTokenResponse msTokenResponse) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSecs = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        long expiresIn = msTokenResponse.getExpiresIn();
        return currentTimeSecs + expiresIn;
    }

    private long getRefreshOn(MicrosoftStsTokenResponse msTokenResponse) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSecs = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        long refreshIn = msTokenResponse.getRefreshIn() == null ? msTokenResponse.getExpiresIn() : msTokenResponse.getRefreshIn();
        return currentTimeSecs + refreshIn;
    }
}

