/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.TokenCommand;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.List;
import lombok.NonNull;

public class InteractiveTokenCommand
extends TokenCommand {
    private static final String TAG = InteractiveTokenCommand.class.getSimpleName();

    public InteractiveTokenCommand(@NonNull InteractiveTokenCommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controller, callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    public InteractiveTokenCommand(@NonNull InteractiveTokenCommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controllers, callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controllers == null) {
            throw new NullPointerException("controllers is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public AcquireTokenResult execute() throws Exception {
        String methodName = ":execute";
        Span span = OTelUtility.createSpanFromParent(SpanName.AcquireTokenInteractive.name(), this.getParameters().getSpanContext());
        span.setAttribute(AttributeName.application_name.name(), this.getParameters().getApplicationName());
        span.setAttribute(AttributeName.public_api_id.name(), this.getPublicApiId());
        try {
            block18: {
                AcquireTokenResult acquireTokenResult;
                block19: {
                    Scope scope = span.makeCurrent();
                    if (!(this.getParameters() instanceof InteractiveTokenCommandParameters)) break block18;
                    Logger.info(TAG + ":execute", "Executing interactive token command...");
                    BaseController controller = this.getDefaultController();
                    span.setAttribute(AttributeName.controller_name.name(), controller.getClass().getSimpleName());
                    AcquireTokenResult result = controller.acquireToken((InteractiveTokenCommandParameters)this.getParameters());
                    if (result == null) {
                        span.setStatus(StatusCode.ERROR, "empty result");
                    } else if (result.getSucceeded().booleanValue()) {
                        span.setStatus(StatusCode.OK);
                    } else {
                        BaseException exception = ExceptionAdapter.exceptionFromAcquireTokenResult(result, this.getParameters());
                        if (exception != null) {
                            span.recordException((Throwable)exception);
                            span.setStatus(StatusCode.ERROR);
                        } else {
                            span.setStatus(StatusCode.ERROR, "empty exception");
                        }
                    }
                    acquireTokenResult = result;
                    if (scope == null) break block19;
                    {
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    scope.close();
                }
                return acquireTokenResult;
            }
            try {
                throw new IllegalArgumentException("Invalid operation parameters");
            }
            catch (Throwable throwable) {
                span.setStatus(StatusCode.ERROR);
                span.recordException(throwable);
                throw throwable;
            }
        }
        finally {
            span.end();
        }
    }

    public void onFinishAuthorizationSession(int requestCode, int resultCode, @NonNull PropertyBag data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.getDefaultController().onFinishAuthorizationSession(requestCode, resultCode, data);
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteractiveTokenCommand)) {
            return false;
        }
        InteractiveTokenCommand other = (InteractiveTokenCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InteractiveTokenCommand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

