/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands.parameters;

import com.google.gson.annotations.Expose;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.opentelemetry.SerializableSpanContext;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.request.SdkType;
import java.util.Collections;
import java.util.Map;
import lombok.NonNull;

public class CommandParameters {
    public static final String APPLICATION_IDENTIFIER_FORMAT = "%s/%s";
    @NonNull
    private transient IPlatformComponents platformComponents;
    private transient OAuth2TokenCache oAuth2TokenCache;
    private transient boolean isSharedDevice;
    @Expose
    private String applicationName;
    @Expose
    private String applicationVersion;
    @Expose
    private String requiredBrokerProtocolVersion;
    @Expose
    private SdkType sdkType;
    @Expose
    private String sdkVersion;
    @Expose
    private String clientId;
    @Expose
    private String redirectUri;
    @Expose
    private boolean powerOptCheckEnabled;
    @Expose
    private String callerPackageName;
    @Expose
    private String callerSignature;
    private transient Map<String, String> flightInformation;
    @Expose
    private String correlationId;
    @Expose
    private SerializableSpanContext spanContext;

    public String getApplicationIdentifier() {
        return String.format(APPLICATION_IDENTIFIER_FORMAT, this.callerPackageName, this.callerSignature);
    }

    private static Map<String, String> $default$flightInformation() {
        return Collections.emptyMap();
    }

    protected CommandParameters(CommandParametersBuilder<?, ?> b) {
        this.platformComponents = ((CommandParametersBuilder)b).platformComponents;
        if (this.platformComponents == null) {
            throw new NullPointerException("platformComponents is marked non-null but is null");
        }
        this.oAuth2TokenCache = ((CommandParametersBuilder)b).oAuth2TokenCache;
        this.isSharedDevice = ((CommandParametersBuilder)b).isSharedDevice;
        this.applicationName = ((CommandParametersBuilder)b).applicationName;
        this.applicationVersion = ((CommandParametersBuilder)b).applicationVersion;
        this.requiredBrokerProtocolVersion = ((CommandParametersBuilder)b).requiredBrokerProtocolVersion;
        this.sdkType = ((CommandParametersBuilder)b).sdkType;
        this.sdkVersion = ((CommandParametersBuilder)b).sdkVersion;
        this.clientId = ((CommandParametersBuilder)b).clientId;
        this.redirectUri = ((CommandParametersBuilder)b).redirectUri;
        this.powerOptCheckEnabled = ((CommandParametersBuilder)b).powerOptCheckEnabled;
        this.callerPackageName = ((CommandParametersBuilder)b).callerPackageName;
        this.callerSignature = ((CommandParametersBuilder)b).callerSignature;
        this.flightInformation = ((CommandParametersBuilder)b).flightInformation$set ? ((CommandParametersBuilder)b).flightInformation$value : CommandParameters.$default$flightInformation();
        this.correlationId = ((CommandParametersBuilder)b).correlationId;
        this.spanContext = ((CommandParametersBuilder)b).spanContext;
    }

    public static CommandParametersBuilder<?, ?> builder() {
        return new CommandParametersBuilderImpl();
    }

    public CommandParametersBuilder<?, ?> toBuilder() {
        return new CommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    public IPlatformComponents getPlatformComponents() {
        return this.platformComponents;
    }

    public OAuth2TokenCache getOAuth2TokenCache() {
        return this.oAuth2TokenCache;
    }

    public boolean isSharedDevice() {
        return this.isSharedDevice;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getRequiredBrokerProtocolVersion() {
        return this.requiredBrokerProtocolVersion;
    }

    public SdkType getSdkType() {
        return this.sdkType;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public boolean isPowerOptCheckEnabled() {
        return this.powerOptCheckEnabled;
    }

    public String getCallerPackageName() {
        return this.callerPackageName;
    }

    public String getCallerSignature() {
        return this.callerSignature;
    }

    public Map<String, String> getFlightInformation() {
        return this.flightInformation;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public SerializableSpanContext getSpanContext() {
        return this.spanContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandParameters)) {
            return false;
        }
        CommandParameters other = (CommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$applicationVersion = this.getApplicationVersion();
        String other$applicationVersion = other.getApplicationVersion();
        if (this$applicationVersion == null ? other$applicationVersion != null : !this$applicationVersion.equals(other$applicationVersion)) {
            return false;
        }
        String this$requiredBrokerProtocolVersion = this.getRequiredBrokerProtocolVersion();
        String other$requiredBrokerProtocolVersion = other.getRequiredBrokerProtocolVersion();
        if (this$requiredBrokerProtocolVersion == null ? other$requiredBrokerProtocolVersion != null : !this$requiredBrokerProtocolVersion.equals(other$requiredBrokerProtocolVersion)) {
            return false;
        }
        SdkType this$sdkType = this.getSdkType();
        SdkType other$sdkType = other.getSdkType();
        if (this$sdkType == null ? other$sdkType != null : !((Object)((Object)this$sdkType)).equals((Object)other$sdkType)) {
            return false;
        }
        String this$sdkVersion = this.getSdkVersion();
        String other$sdkVersion = other.getSdkVersion();
        if (this$sdkVersion == null ? other$sdkVersion != null : !this$sdkVersion.equals(other$sdkVersion)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        if (this.isPowerOptCheckEnabled() != other.isPowerOptCheckEnabled()) {
            return false;
        }
        String this$callerPackageName = this.getCallerPackageName();
        String other$callerPackageName = other.getCallerPackageName();
        if (this$callerPackageName == null ? other$callerPackageName != null : !this$callerPackageName.equals(other$callerPackageName)) {
            return false;
        }
        String this$callerSignature = this.getCallerSignature();
        String other$callerSignature = other.getCallerSignature();
        if (this$callerSignature == null ? other$callerSignature != null : !this$callerSignature.equals(other$callerSignature)) {
            return false;
        }
        SerializableSpanContext this$spanContext = this.getSpanContext();
        SerializableSpanContext other$spanContext = other.getSpanContext();
        return !(this$spanContext == null ? other$spanContext != null : !this$spanContext.equals(other$spanContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $applicationVersion = this.getApplicationVersion();
        result = result * 59 + ($applicationVersion == null ? 43 : $applicationVersion.hashCode());
        String $requiredBrokerProtocolVersion = this.getRequiredBrokerProtocolVersion();
        result = result * 59 + ($requiredBrokerProtocolVersion == null ? 43 : $requiredBrokerProtocolVersion.hashCode());
        SdkType $sdkType = this.getSdkType();
        result = result * 59 + ($sdkType == null ? 43 : ((Object)((Object)$sdkType)).hashCode());
        String $sdkVersion = this.getSdkVersion();
        result = result * 59 + ($sdkVersion == null ? 43 : $sdkVersion.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        result = result * 59 + (this.isPowerOptCheckEnabled() ? 79 : 97);
        String $callerPackageName = this.getCallerPackageName();
        result = result * 59 + ($callerPackageName == null ? 43 : $callerPackageName.hashCode());
        String $callerSignature = this.getCallerSignature();
        result = result * 59 + ($callerSignature == null ? 43 : $callerSignature.hashCode());
        SerializableSpanContext $spanContext = this.getSpanContext();
        result = result * 59 + ($spanContext == null ? 43 : $spanContext.hashCode());
        return result;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    private static final class CommandParametersBuilderImpl
    extends CommandParametersBuilder<CommandParameters, CommandParametersBuilderImpl> {
        private CommandParametersBuilderImpl() {
        }

        @Override
        protected CommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public CommandParameters build() {
            return new CommandParameters(this);
        }
    }

    public static abstract class CommandParametersBuilder<C extends CommandParameters, B extends CommandParametersBuilder<C, B>> {
        private IPlatformComponents platformComponents;
        private OAuth2TokenCache oAuth2TokenCache;
        private boolean isSharedDevice;
        private String applicationName;
        private String applicationVersion;
        private String requiredBrokerProtocolVersion;
        private SdkType sdkType;
        private String sdkVersion;
        private String clientId;
        private String redirectUri;
        private boolean powerOptCheckEnabled;
        private String callerPackageName;
        private String callerSignature;
        private boolean flightInformation$set;
        private Map<String, String> flightInformation$value;
        private String correlationId;
        private SerializableSpanContext spanContext;

        protected B $fillValuesFrom(C instance) {
            CommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CommandParameters instance, CommandParametersBuilder<?, ?> b) {
            b.platformComponents(instance.platformComponents);
            b.oAuth2TokenCache(instance.oAuth2TokenCache);
            b.isSharedDevice(instance.isSharedDevice);
            b.applicationName(instance.applicationName);
            b.applicationVersion(instance.applicationVersion);
            b.requiredBrokerProtocolVersion(instance.requiredBrokerProtocolVersion);
            b.sdkType(instance.sdkType);
            b.sdkVersion(instance.sdkVersion);
            b.clientId(instance.clientId);
            b.redirectUri(instance.redirectUri);
            b.powerOptCheckEnabled(instance.powerOptCheckEnabled);
            b.callerPackageName(instance.callerPackageName);
            b.callerSignature(instance.callerSignature);
            b.flightInformation(instance.flightInformation);
            b.correlationId(instance.correlationId);
            b.spanContext(instance.spanContext);
        }

        protected abstract B self();

        public abstract C build();

        public B platformComponents(@NonNull IPlatformComponents platformComponents) {
            if (platformComponents == null) {
                throw new NullPointerException("platformComponents is marked non-null but is null");
            }
            this.platformComponents = platformComponents;
            return this.self();
        }

        public B oAuth2TokenCache(OAuth2TokenCache oAuth2TokenCache) {
            this.oAuth2TokenCache = oAuth2TokenCache;
            return this.self();
        }

        public B isSharedDevice(boolean isSharedDevice) {
            this.isSharedDevice = isSharedDevice;
            return this.self();
        }

        public B applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this.self();
        }

        public B applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this.self();
        }

        public B requiredBrokerProtocolVersion(String requiredBrokerProtocolVersion) {
            this.requiredBrokerProtocolVersion = requiredBrokerProtocolVersion;
            return this.self();
        }

        public B sdkType(SdkType sdkType) {
            this.sdkType = sdkType;
            return this.self();
        }

        public B sdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this.self();
        }

        public B clientId(String clientId) {
            this.clientId = clientId;
            return this.self();
        }

        public B redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this.self();
        }

        public B powerOptCheckEnabled(boolean powerOptCheckEnabled) {
            this.powerOptCheckEnabled = powerOptCheckEnabled;
            return this.self();
        }

        public B callerPackageName(String callerPackageName) {
            this.callerPackageName = callerPackageName;
            return this.self();
        }

        public B callerSignature(String callerSignature) {
            this.callerSignature = callerSignature;
            return this.self();
        }

        public B flightInformation(Map<String, String> flightInformation) {
            this.flightInformation$value = flightInformation;
            this.flightInformation$set = true;
            return this.self();
        }

        public B correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this.self();
        }

        public B spanContext(SerializableSpanContext spanContext) {
            this.spanContext = spanContext;
            return this.self();
        }

        public String toString() {
            return "CommandParameters.CommandParametersBuilder(platformComponents=" + this.platformComponents + ", oAuth2TokenCache=" + this.oAuth2TokenCache + ", isSharedDevice=" + this.isSharedDevice + ", applicationName=" + this.applicationName + ", applicationVersion=" + this.applicationVersion + ", requiredBrokerProtocolVersion=" + this.requiredBrokerProtocolVersion + ", sdkType=" + (Object)((Object)this.sdkType) + ", sdkVersion=" + this.sdkVersion + ", clientId=" + this.clientId + ", redirectUri=" + this.redirectUri + ", powerOptCheckEnabled=" + this.powerOptCheckEnabled + ", callerPackageName=" + this.callerPackageName + ", callerSignature=" + this.callerSignature + ", flightInformation$value=" + this.flightInformation$value + ", correlationId=" + this.correlationId + ", spanContext=" + this.spanContext + ")";
        }
    }
}

