/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.controllers;

import com.microsoft.identity.common.java.commands.ICommandResult;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class CommandResult<T>
implements ICommandResult<T> {
    private final ICommandResult.ResultStatus mStatus;
    private final T mResult;
    private final String mCorrelationId;
    private final Class<T> mResultClass;
    private List<Map<String, String>> mTelemetryMap = new ArrayList<Map<String, String>>();

    @Deprecated
    public CommandResult(ICommandResult.ResultStatus status, T result) {
        this(status, result, null);
    }

    public CommandResult(@NonNull ICommandResult.ResultStatus status, @NonNull T result, @Nullable String correlationId) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.mStatus = status;
        this.mResult = result;
        this.mCorrelationId = correlationId == null ? "UNSET" : correlationId;
        Class<?> aClass = result.getClass();
        this.mResultClass = aClass;
    }

    private CommandResult(@NonNull ICommandResult.ResultStatus status, @Nullable String correlationId) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.mStatus = status;
        this.mResult = null;
        this.mCorrelationId = correlationId == null ? "UNSET" : correlationId;
        Class<Void> aClass = Void.class;
        this.mResultClass = aClass;
    }

    public static CommandResult<Void> ofNull(@NonNull ICommandResult.ResultStatus status, @Nullable String correlationId) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return new CommandResult<Void>(status, correlationId);
    }

    public static <T> CommandResult<T> of(@NonNull ICommandResult.ResultStatus status, @NonNull T result, @Nullable String correlationId) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        return new CommandResult<T>(status, result, correlationId);
    }

    @Override
    public ICommandResult.ResultStatus getStatus() {
        return this.mStatus;
    }

    @Override
    public T getResult() {
        return this.mResult;
    }

    @Override
    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public Class<T> getResultClass() {
        return this.mResultClass;
    }

    public List<Map<String, String>> getTelemetryMap() {
        return this.mTelemetryMap;
    }

    public void setTelemetryMap(List<Map<String, String>> mTelemetryMap) {
        this.mTelemetryMap = mTelemetryMap;
    }
}

