/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.Algorithm;
import com.microsoft.identity.common.java.crypto.AsymmetricAlgorithm;
import com.microsoft.identity.common.java.crypto.IKeyStoreKeyManager;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.crypto.SigningAlgorithm;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Date;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import lombok.NonNull;

public interface IDevicePopManager {
    public static final String MGF_1 = "MGF1";
    public static final String SHA_1 = "SHA-1";

    public boolean asymmetricKeyExists();

    public boolean asymmetricKeyExists(String var1);

    public String getAsymmetricKeyThumbprint() throws ClientException;

    public void generateAsymmetricKey(TaskCompletedCallbackWithError<String, ClientException> var1);

    public String generateAsymmetricKey() throws ClientException;

    public Date getAsymmetricKeyCreationDate() throws ClientException;

    public boolean clearAsymmetricKey();

    public String getRequestConfirmation() throws ClientException;

    public void getRequestConfirmation(TaskCompletedCallbackWithError<String, ClientException> var1);

    public String sign(SigningAlgorithm var1, String var2) throws ClientException;

    public byte[] sign(@NonNull SigningAlgorithm var1, byte[] var2) throws ClientException;

    public boolean verify(SigningAlgorithm var1, String var2, String var3);

    public boolean verify(@NonNull SigningAlgorithm var1, byte[] var2, byte[] var3);

    public String encrypt(Cipher var1, String var2) throws ClientException;

    public byte[] encrypt(@NonNull Cipher var1, @NonNull byte[] var2) throws ClientException;

    public String decrypt(Cipher var1, String var2) throws ClientException;

    public byte[] decrypt(@NonNull Cipher var1, byte[] var2) throws ClientException;

    public SecureHardwareState getSecureHardwareState() throws ClientException;

    public String getPublicKey(PublicKeyFormat var1) throws ClientException;

    public PublicKey getPublicKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException;

    public Certificate[] getCertificateChain() throws ClientException;

    public String mintSignedAccessToken(String var1, long var2, URL var4, String var5, String var6) throws ClientException;

    public String mintSignedAccessToken(String var1, long var2, URL var4, String var5, String var6, String var7) throws ClientException;

    public String mintSignedHttpRequest(String var1, long var2, URL var4, String var5, String var6) throws ClientException;

    public IKeyStoreKeyManager<KeyStore.PrivateKeyEntry> getKeyManager();

    public static enum Cipher implements AsymmetricAlgorithm
    {
        RSA_ECB_PKCS1_PADDING("RSA/ECB/PKCS1Padding"),
        RSA_NONE_OAEPWithSHA_1AndMGF1Padding("RSA/NONE/OAEPWithSHA-1AndMGF1Padding"){

            @Override
            public AlgorithmParameterSpec getParameters() {
                return new OAEPParameterSpec(IDevicePopManager.SHA_1, IDevicePopManager.MGF_1, new MGF1ParameterSpec(IDevicePopManager.SHA_1), PSource.PSpecified.DEFAULT);
            }
        }
        ,
        RSA_ECB_OAEPWithSHA_1AndMGF1Padding("RSA/ECB/OAEPWithSHA-1AndMGF1Padding"){

            @Override
            public AlgorithmParameterSpec getParameters() {
                return new OAEPParameterSpec(IDevicePopManager.SHA_1, IDevicePopManager.MGF_1, new MGF1ParameterSpec(IDevicePopManager.SHA_1), PSource.PSpecified.DEFAULT);
            }
        }
        ,
        RSA_ECB_OAEPWithSHA_256AndMGF1Padding("RSA/ECB/OAEPWithSHA-256AndMGF1Padding"){

            @Override
            public AlgorithmParameterSpec getParameters() {
                return new OAEPParameterSpec("SHA-256", IDevicePopManager.MGF_1, new MGF1ParameterSpec(IDevicePopManager.SHA_1), PSource.PSpecified.DEFAULT);
            }
        };

        private final String mValue;

        private Cipher(String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.mValue = value;
        }

        @NonNull
        public String toString() {
            return this.mValue;
        }

        public Algorithm cipherName() {
            return AsymmetricAlgorithm.Builder.of(this.mValue);
        }

        public AlgorithmParameterSpec getParameters() {
            return null;
        }

        public boolean supportsShr() {
            return true;
        }
    }

    public static enum PublicKeyFormat {
        X_509_SubjectPublicKeyInfo_ASN_1,
        JWK;

    }
}

