/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.foci;

import com.microsoft.identity.common.java.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.TokenResult;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.ObjectUtils;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import lombok.NonNull;

public class FociQueryUtilities {
    private static final String TAG = FociQueryUtilities.class.getSimpleName();

    public static boolean tryFociTokenWithGivenClientId(@NonNull BrokerOAuth2TokenCache brokerOAuth2TokenCache, @NonNull String clientId, @NonNull String redirectUri, @NonNull ICacheRecord cacheRecord) throws IOException, ClientException {
        if (brokerOAuth2TokenCache == null) {
            throw new NullPointerException("brokerOAuth2TokenCache is marked non-null but is null");
        }
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        return FociQueryUtilities.tryFociTokenWithGivenClientId(brokerOAuth2TokenCache, clientId, redirectUri, cacheRecord.getRefreshToken(), cacheRecord.getAccount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryFociTokenWithGivenClientId(@NonNull OAuth2TokenCache brokerOAuth2TokenCache, @NonNull String clientId, @NonNull String redirectUri, @NonNull RefreshTokenRecord refreshTokenRecord, @NonNull IAccountRecord accountRecord) throws ClientException, IOException {
        String scopes;
        String refreshToken;
        MicrosoftStsOAuth2Strategy strategy;
        block18: {
            URL authorityUrl;
            if (brokerOAuth2TokenCache == null) {
                throw new NullPointerException("brokerOAuth2TokenCache is marked non-null but is null");
            }
            if (clientId == null) {
                throw new NullPointerException("clientId is marked non-null but is null");
            }
            if (redirectUri == null) {
                throw new NullPointerException("redirectUri is marked non-null but is null");
            }
            if (refreshTokenRecord == null) {
                throw new NullPointerException("refreshTokenRecord is marked non-null but is null");
            }
            if (accountRecord == null) {
                throw new NullPointerException("accountRecord is marked non-null but is null");
            }
            String methodName = ":tryFociTokenWithGivenClientId";
            MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
            CommonURIBuilder requestUrlBuilder = new CommonURIBuilder();
            requestUrlBuilder.setScheme("https").setHost(refreshTokenRecord.getEnvironment()).setPath(StringUtil.isNullOrEmpty(accountRecord.getRealm()) ? "common" : accountRecord.getRealm());
            try {
                authorityUrl = new URL(requestUrlBuilder.build().toString());
            }
            catch (URISyntaxException e) {
                throw new ClientException("malformed_url", e.getMessage(), e);
            }
            config.setAuthorityUrl(authorityUrl);
            OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().build();
            strategy = new MicrosoftStsOAuth2Strategy(config, strategyParameters);
            refreshToken = refreshTokenRecord.getSecret();
            if (ObjectUtils.equals(clientId, "87749df4-7ccf-48f8-aa87-704bad0e0e16")) {
                Span span = OTelUtility.createSpan(SpanName.SetScopeForDMAgentForFoci.name());
                try (Scope scope = span.makeCurrent();){
                    scopes = "https://devicemgmt.teams.microsoft.com/.default " + BaseController.getDelimitedDefaultScopeString();
                    Logger.info(TAG + ":tryFociTokenWithGivenClientId", "Teams agent client ID - making a test request with teams agent resource.");
                    break block18;
                }
                finally {
                    span.end();
                }
            }
            scopes = BaseController.getDelimitedDefaultScopeString();
        }
        UUID correlationId = UUID.randomUUID();
        Logger.verbose(TAG + ":tryFociTokenWithGivenClientId", "Create the token request with correlationId [" + correlationId + "]");
        MicrosoftStsTokenRequest tokenRequest = FociQueryUtilities.createTokenRequest(clientId, scopes, refreshToken, redirectUri, strategy, correlationId, "2");
        Logger.verbose(TAG + ":tryFociTokenWithGivenClientId", "Start refreshing token (to verify foci) with correlationId [" + correlationId + "]");
        Object tokenResult = strategy.requestToken(tokenRequest);
        Logger.verbose(TAG + ":tryFociTokenWithGivenClientId", "Is the client ID able to use the foci? [" + ((TokenResult)tokenResult).getSuccess() + "] with correlationId [" + correlationId + "]");
        if (((TokenResult)tokenResult).getSuccess()) {
            MicrosoftStsAuthorizationRequest authorizationRequest = FociQueryUtilities.createAuthRequest(strategy, clientId, redirectUri, scopes, accountRecord, correlationId);
            Logger.verbose(TAG + ":tryFociTokenWithGivenClientId", "Saving records to cache with client id" + clientId);
            FociQueryUtilities.brokerOAuth2TokenCacheSave(brokerOAuth2TokenCache, strategy, tokenResult, authorizationRequest);
        }
        return ((TokenResult)tokenResult).getSuccess();
    }

    @NonNull
    public static MicrosoftStsTokenRequest createTokenRequest(@NonNull String clientId, @NonNull String scopes, @NonNull String refreshToken, @NonNull String redirectUri, @NonNull MicrosoftStsOAuth2Strategy strategy, @Nullable UUID correlationId, @NonNull String idTokenVersion) throws ClientException {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (scopes == null) {
            throw new NullPointerException("scopes is marked non-null but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        if (idTokenVersion == null) {
            throw new NullPointerException("idTokenVersion is marked non-null but is null");
        }
        MicrosoftStsTokenRequest tokenRequest = strategy.createRefreshTokenRequest(new BearerAuthenticationSchemeInternal());
        tokenRequest.setClientId(clientId);
        tokenRequest.setScope(scopes);
        tokenRequest.setCorrelationId(correlationId);
        tokenRequest.setRefreshToken(refreshToken);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setIdTokenVersion(idTokenVersion);
        return tokenRequest;
    }

    private static MicrosoftStsAuthorizationRequest createAuthRequest(@NonNull MicrosoftStsOAuth2Strategy strategy, @NonNull String clientId, @NonNull String redirectUri, @NonNull String scope, @NonNull IAccountRecord accountRecord, @Nullable UUID correlationId) {
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        MicrosoftStsAuthorizationRequest.Builder builder = strategy.createAuthorizationRequestBuilder(accountRecord);
        return ((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)builder.setClientId(clientId)).setRedirectUri(redirectUri)).setCorrelationId(correlationId)).setScope(scope)).build();
    }

    private static void brokerOAuth2TokenCacheSave(@NonNull OAuth2TokenCache brokerOAuth2TokenCache, MicrosoftStsOAuth2Strategy strategy, TokenResult tokenResult, MicrosoftStsAuthorizationRequest authorizationRequest) throws ClientException {
        if (brokerOAuth2TokenCache == null) {
            throw new NullPointerException("brokerOAuth2TokenCache is marked non-null but is null");
        }
        brokerOAuth2TokenCache.save(strategy, authorizationRequest, (MicrosoftTokenResponse)tokenResult.getTokenResponse());
    }
}

