/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.interfaces;

import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IHttpClientWrapper;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.interfaces.IPopManagerSupplier;
import com.microsoft.identity.common.java.interfaces.IStorageSupplier;
import com.microsoft.identity.common.java.providers.oauth2.IStateGenerator;
import com.microsoft.identity.common.java.strategies.IAuthorizationStrategyFactory;
import com.microsoft.identity.common.java.util.IBroadcaster;
import com.microsoft.identity.common.java.util.IClockSkewManager;
import com.microsoft.identity.common.java.util.IPlatformUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import lombok.NonNull;

public class PlatformComponents
implements IPlatformComponents {
    @NonNull
    private final IKeyAccessor mStorageEncryptionManager;
    @NonNull
    private final IClockSkewManager mClockSkewManager;
    @NonNull
    private final IBroadcaster mBroadcaster;
    @NonNull
    private final IPopManagerSupplier mPopManagerLoader;
    @NonNull
    private final IStorageSupplier mStorageLoader;
    @Nullable
    private final IAuthorizationStrategyFactory mAuthorizationStrategyFactory;
    @Nullable
    private final IStateGenerator mStateGenerator;
    @NonNull
    private final IPlatformUtil mPlatformUtil;
    @NonNull
    private final IHttpClientWrapper mHttpClientWrapper;

    @Override
    @NonNull
    public IDevicePopManager getDefaultDevicePopManager() throws ClientException {
        return this.mPopManagerLoader.getDefaultDevicePopManager();
    }

    @Override
    @NonNull
    public IDevicePopManager getDevicePopManager(@Nullable String alias) throws ClientException {
        return this.mPopManagerLoader.getDevicePopManager(alias);
    }

    @Override
    @NonNull
    public <T> INameValueStorage<T> getNameValueStore(@NonNull String storeName, @NonNull Class<T> clazz) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.mStorageLoader.getNameValueStore(storeName, clazz);
    }

    @Override
    @NonNull
    public <T> INameValueStorage<T> getEncryptedNameValueStore(@NonNull String storeName, @Nullable IKeyAccessor helper, @NonNull Class<T> clazz) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.mStorageLoader.getEncryptedNameValueStore(storeName, helper, clazz);
    }

    @Override
    @NonNull
    public IMultiTypeNameValueStorage getEncryptedFileStore(@NonNull String storeName, @NonNull IKeyAccessor helper) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (helper == null) {
            throw new NullPointerException("helper is marked non-null but is null");
        }
        return this.mStorageLoader.getEncryptedFileStore(storeName, helper);
    }

    @Override
    @NonNull
    public IMultiTypeNameValueStorage getFileStore(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        return this.mStorageLoader.getFileStore(storeName);
    }

    @Override
    @NonNull
    public INameValueStorage<String> getMultiProcessStringStore(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        return this.mStorageLoader.getMultiProcessStringStore(storeName);
    }

    protected PlatformComponents(PlatformComponentsBuilder<?, ?> b) {
        this.mStorageEncryptionManager = ((PlatformComponentsBuilder)b).storageEncryptionManager;
        if (this.mStorageEncryptionManager == null) {
            throw new NullPointerException("mStorageEncryptionManager is marked non-null but is null");
        }
        this.mClockSkewManager = ((PlatformComponentsBuilder)b).clockSkewManager;
        if (this.mClockSkewManager == null) {
            throw new NullPointerException("mClockSkewManager is marked non-null but is null");
        }
        this.mBroadcaster = ((PlatformComponentsBuilder)b).broadcaster;
        if (this.mBroadcaster == null) {
            throw new NullPointerException("mBroadcaster is marked non-null but is null");
        }
        this.mPopManagerLoader = ((PlatformComponentsBuilder)b).popManagerLoader;
        if (this.mPopManagerLoader == null) {
            throw new NullPointerException("mPopManagerLoader is marked non-null but is null");
        }
        this.mStorageLoader = ((PlatformComponentsBuilder)b).storageLoader;
        if (this.mStorageLoader == null) {
            throw new NullPointerException("mStorageLoader is marked non-null but is null");
        }
        this.mAuthorizationStrategyFactory = ((PlatformComponentsBuilder)b).authorizationStrategyFactory;
        this.mStateGenerator = ((PlatformComponentsBuilder)b).stateGenerator;
        this.mPlatformUtil = ((PlatformComponentsBuilder)b).platformUtil;
        if (this.mPlatformUtil == null) {
            throw new NullPointerException("mPlatformUtil is marked non-null but is null");
        }
        this.mHttpClientWrapper = ((PlatformComponentsBuilder)b).httpClientWrapper;
        if (this.mHttpClientWrapper == null) {
            throw new NullPointerException("mHttpClientWrapper is marked non-null but is null");
        }
    }

    public static PlatformComponentsBuilder<?, ?> builder() {
        return new PlatformComponentsBuilderImpl();
    }

    @Override
    @NonNull
    public IKeyAccessor getStorageEncryptionManager() {
        return this.mStorageEncryptionManager;
    }

    @Override
    @NonNull
    public IClockSkewManager getClockSkewManager() {
        return this.mClockSkewManager;
    }

    @Override
    @NonNull
    public IBroadcaster getBroadcaster() {
        return this.mBroadcaster;
    }

    @NonNull
    public IPopManagerSupplier getPopManagerLoader() {
        return this.mPopManagerLoader;
    }

    @NonNull
    public IStorageSupplier getStorageLoader() {
        return this.mStorageLoader;
    }

    @Override
    @Nullable
    public IAuthorizationStrategyFactory getAuthorizationStrategyFactory() {
        return this.mAuthorizationStrategyFactory;
    }

    @Override
    @Nullable
    public IStateGenerator getStateGenerator() {
        return this.mStateGenerator;
    }

    @Override
    @NonNull
    public IPlatformUtil getPlatformUtil() {
        return this.mPlatformUtil;
    }

    @Override
    @NonNull
    public IHttpClientWrapper getHttpClientWrapper() {
        return this.mHttpClientWrapper;
    }

    private static final class PlatformComponentsBuilderImpl
    extends PlatformComponentsBuilder<PlatformComponents, PlatformComponentsBuilderImpl> {
        private PlatformComponentsBuilderImpl() {
        }

        @Override
        protected PlatformComponentsBuilderImpl self() {
            return this;
        }

        @Override
        public PlatformComponents build() {
            return new PlatformComponents(this);
        }
    }

    public static abstract class PlatformComponentsBuilder<C extends PlatformComponents, B extends PlatformComponentsBuilder<C, B>> {
        private IKeyAccessor storageEncryptionManager;
        private IClockSkewManager clockSkewManager;
        private IBroadcaster broadcaster;
        private IPopManagerSupplier popManagerLoader;
        private IStorageSupplier storageLoader;
        private IAuthorizationStrategyFactory authorizationStrategyFactory;
        private IStateGenerator stateGenerator;
        private IPlatformUtil platformUtil;
        private IHttpClientWrapper httpClientWrapper;

        protected abstract B self();

        public abstract C build();

        public B storageEncryptionManager(@NonNull IKeyAccessor storageEncryptionManager) {
            if (storageEncryptionManager == null) {
                throw new NullPointerException("storageEncryptionManager is marked non-null but is null");
            }
            this.storageEncryptionManager = storageEncryptionManager;
            return this.self();
        }

        public B clockSkewManager(@NonNull IClockSkewManager clockSkewManager) {
            if (clockSkewManager == null) {
                throw new NullPointerException("clockSkewManager is marked non-null but is null");
            }
            this.clockSkewManager = clockSkewManager;
            return this.self();
        }

        public B broadcaster(@NonNull IBroadcaster broadcaster) {
            if (broadcaster == null) {
                throw new NullPointerException("broadcaster is marked non-null but is null");
            }
            this.broadcaster = broadcaster;
            return this.self();
        }

        public B popManagerLoader(@NonNull IPopManagerSupplier popManagerLoader) {
            if (popManagerLoader == null) {
                throw new NullPointerException("popManagerLoader is marked non-null but is null");
            }
            this.popManagerLoader = popManagerLoader;
            return this.self();
        }

        public B storageLoader(@NonNull IStorageSupplier storageLoader) {
            if (storageLoader == null) {
                throw new NullPointerException("storageLoader is marked non-null but is null");
            }
            this.storageLoader = storageLoader;
            return this.self();
        }

        public B authorizationStrategyFactory(@Nullable IAuthorizationStrategyFactory authorizationStrategyFactory) {
            this.authorizationStrategyFactory = authorizationStrategyFactory;
            return this.self();
        }

        public B stateGenerator(@Nullable IStateGenerator stateGenerator) {
            this.stateGenerator = stateGenerator;
            return this.self();
        }

        public B platformUtil(@NonNull IPlatformUtil platformUtil) {
            if (platformUtil == null) {
                throw new NullPointerException("platformUtil is marked non-null but is null");
            }
            this.platformUtil = platformUtil;
            return this.self();
        }

        public B httpClientWrapper(@NonNull IHttpClientWrapper httpClientWrapper) {
            if (httpClientWrapper == null) {
                throw new NullPointerException("httpClientWrapper is marked non-null but is null");
            }
            this.httpClientWrapper = httpClientWrapper;
            return this.self();
        }

        public String toString() {
            return "PlatformComponents.PlatformComponentsBuilder(storageEncryptionManager=" + this.storageEncryptionManager + ", clockSkewManager=" + this.clockSkewManager + ", broadcaster=" + this.broadcaster + ", popManagerLoader=" + this.popManagerLoader + ", storageLoader=" + this.storageLoader + ", authorizationStrategyFactory=" + this.authorizationStrategyFactory + ", stateGenerator=" + this.stateGenerator + ", platformUtil=" + this.platformUtil + ", httpClientWrapper=" + this.httpClientWrapper + ")";
        }
    }
}

