/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.platform.Device;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.DefaultStateGenerator;
import com.microsoft.identity.common.java.providers.oauth2.PkceChallenge;
import java.net.URL;
import java.util.UUID;
import lombok.NonNull;

public abstract class MicrosoftAuthorizationRequest<T extends MicrosoftAuthorizationRequest<T>>
extends AuthorizationRequest<T> {
    private static final long serialVersionUID = 6873634931996113294L;
    private static final String TAG = MicrosoftAuthorizationRequest.class.getSimpleName();
    public static final String INSTANCE_AWARE = "instance_aware";
    private final transient URL mAuthority;
    @SerializedName(value="login_hint")
    private final String mLoginHint;
    @Expose
    @SerializedName(value="client-request-id")
    private final UUID mCorrelationId;
    @SerializedName(value="code_challenge")
    private final String mPkceCodeChallenge;
    @SerializedName(value="code_challenge_method")
    private final String mPkceCodeChallengeMethod;
    private final transient String mPkceCodeVerifier;
    @Expose
    @SerializedName(value="x-client-Ver")
    private final String mLibraryVersion;
    @Expose
    @SerializedName(value="x-client-SKU")
    private final String mLibraryName;
    @Expose
    @SerializedName(value="x-client-OS")
    private final String mDiagnosticOS;
    @Expose
    @SerializedName(value="x-client-CPU")
    private final String mDiagnosticCPU;
    @Expose
    @SerializedName(value="x-client-DM")
    private final String mDiagnosticDM;
    @Expose
    @SerializedName(value="instance_aware")
    private final Boolean mMultipleCloudAware;

    protected MicrosoftAuthorizationRequest(Builder builder) {
        super(builder);
        this.mAuthority = builder.mAuthority;
        this.mLoginHint = builder.mLoginHint;
        this.mCorrelationId = builder.mCorrelationId;
        PkceChallenge challenge = builder.mPkceChallenge == null ? PkceChallenge.newPkceChallenge() : builder.mPkceChallenge;
        this.mPkceCodeChallengeMethod = challenge.getCodeChallengeMethod();
        this.mPkceCodeChallenge = challenge.getCodeChallenge();
        this.mPkceCodeVerifier = challenge.getCodeVerifier();
        this.mMultipleCloudAware = builder.mMultipleCloudAware;
        this.mLibraryVersion = builder.mLibraryVersion;
        this.mLibraryName = builder.mLibraryName;
        this.mDiagnosticOS = Device.getOsForEsts();
        this.mDiagnosticDM = Device.getModel();
        this.mDiagnosticCPU = Device.getCpu();
    }

    public URL getAuthority() {
        return this.mAuthority;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    public UUID getCorrelationId() {
        return this.mCorrelationId;
    }

    public String getPkceCodeChallenge() {
        return this.mPkceCodeChallenge;
    }

    public String getPkceCodeChallengeMethod() {
        return this.mPkceCodeChallengeMethod;
    }

    public String getPkceCodeVerifier() {
        return this.mPkceCodeVerifier;
    }

    public String getLibraryVersion() {
        return this.mLibraryVersion;
    }

    public String getLibraryName() {
        return this.mLibraryName;
    }

    public String getDiagnosticOS() {
        return this.mDiagnosticOS;
    }

    public String getDiagnosticCPU() {
        return this.mDiagnosticCPU;
    }

    public String getDiagnosticDM() {
        return this.mDiagnosticDM;
    }

    public Boolean getMultipleCloudAware() {
        return this.mMultipleCloudAware;
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AuthorizationRequest.Builder<B> {
        private URL mAuthority;
        private String mLibraryVersion;
        private String mLibraryName;
        private Boolean mMultipleCloudAware;
        private UUID mCorrelationId;
        private String mLoginHint;
        private PkceChallenge mPkceChallenge;

        public Builder() {
            this.setState(new DefaultStateGenerator().generate());
        }

        public B setAuthority(URL authority) {
            this.mAuthority = authority;
            return (B)this.self();
        }

        public B setLibraryVersion(String libraryVersion) {
            this.mLibraryVersion = libraryVersion;
            return (B)this.self();
        }

        public B setLibraryName(String libraryName) {
            this.mLibraryName = libraryName;
            return (B)this.self();
        }

        public B setMultipleCloudAware(boolean multipleCloudAware) {
            this.mMultipleCloudAware = multipleCloudAware;
            return (B)this.self();
        }

        public B setCorrelationId(UUID correlationId) {
            this.mCorrelationId = correlationId;
            return (B)this.self();
        }

        public B setLoginHint(String loginHint) {
            this.mLoginHint = loginHint;
            return (B)this.self();
        }

        public B setPkceChallenge(@NonNull PkceChallenge pkceChallenge) {
            if (pkceChallenge == null) {
                throw new NullPointerException("pkceChallenge is marked non-null but is null");
            }
            this.mPkceChallenge = pkceChallenge;
            return (B)this.self();
        }

        @Override
        public abstract B self();
    }
}

