/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.microsoftsts;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.UrlUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class MicrosoftStsAuthorizationRequest
extends MicrosoftAuthorizationRequest<MicrosoftStsAuthorizationRequest> {
    private static final Object TAG = MicrosoftStsAuthorizationRequest.class.getSimpleName();
    private static final long serialVersionUID = 6545759826515911472L;
    private static final String AUTHORIZATION_ENDPOINT = "oAuth2/v2.0/authorize";
    @Expose
    @SerializedName(value="prompt")
    private final String mPrompt;
    @SerializedName(value="login_req")
    private final String mUid;
    @SerializedName(value="domain_req")
    private final String mUtid;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient String mApplicationIdentifier;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient String mMamEnrollmentIdentifier;
    @Expose
    @SerializedName(value="cpVersion")
    private final String mCompanyPortalVersion;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient String mDisplayableId;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient String mTokenScope;
    protected transient AzureActiveDirectorySlice mSlice;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    protected transient Map<String, String> mFlightParameters;
    public static final String HIDE_SWITCH_USER_QUERY_PARAMETER = "hsu";

    protected MicrosoftStsAuthorizationRequest(Builder builder) {
        super(builder);
        this.mPrompt = builder.mPrompt;
        this.mUid = builder.mUid;
        this.mUtid = builder.mUtid;
        this.mCompanyPortalVersion = builder.mCompanyPortalVersion;
        this.mDisplayableId = builder.mDisplayableId;
        this.mTokenScope = builder.mTokenScope;
        this.mSlice = builder.mSlice;
        this.mFlightParameters = builder.mFlightParameters;
        this.mApplicationIdentifier = builder.mApplicationIdentifier;
        this.mMamEnrollmentIdentifier = builder.mMamEnrollmentIdentifier;
    }

    @Override
    public URI getAuthorizationRequestAsHttpRequest() throws ClientException {
        CommonURIBuilder builder = new CommonURIBuilder(super.getAuthorizationRequestAsHttpRequest());
        builder.addParametersIfAbsent(this.mFlightParameters);
        if (this.mSlice != null) {
            if (!StringUtil.isNullOrEmpty(this.mSlice.getSlice())) {
                builder.addParameterIfAbsent("slice", this.mSlice.getSlice());
            }
            if (!StringUtil.isNullOrEmpty(this.mSlice.getDataCenter())) {
                builder.addParameterIfAbsent("dc", this.mSlice.getDataCenter());
            }
        }
        if (!StringUtil.isNullOrEmpty(this.getLoginHint())) {
            builder.addParameterIfAbsent(HIDE_SWITCH_USER_QUERY_PARAMETER, "1");
        }
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new ClientException("malformed_url", e.getMessage(), e);
        }
    }

    @Override
    public String getAuthorizationEndpoint() throws ClientException {
        String methodName = ":getAuthorizationEndpoint";
        if (this.getAuthority() == null) {
            Logger.error(TAG + ":getAuthorizationEndpoint", "Authority is null. cannot construct authorization endpoint URL.", null);
            throw new IllegalStateException("Authority is null.");
        }
        try {
            return UrlUtil.appendPathToURL(this.getAuthority(), AUTHORIZATION_ENDPOINT).toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ClientException("malformed_url", e.getMessage(), e);
        }
    }

    public String getPrompt() {
        return this.mPrompt;
    }

    public String getUid() {
        return this.mUid;
    }

    public String getUtid() {
        return this.mUtid;
    }

    public String getApplicationIdentifier() {
        return this.mApplicationIdentifier;
    }

    public String getMamEnrollmentIdentifier() {
        return this.mMamEnrollmentIdentifier;
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    public String getTokenScope() {
        return this.mTokenScope;
    }

    public static class Builder
    extends MicrosoftAuthorizationRequest.Builder<Builder> {
        private String mUid;
        private String mUtid;
        private String mDisplayableId;
        private String mApplicationIdentifier;
        private String mMamEnrollmentIdentifier;
        private String mTokenScope;
        private String mCompanyPortalVersion;
        private String mPrompt;
        private AzureActiveDirectorySlice mSlice;
        private Map<String, String> mFlightParameters = new HashMap<String, String>();

        public Builder setUid(String uid) {
            this.mUid = uid;
            return this.self();
        }

        public Builder setUtid(String utid) {
            this.mUtid = utid;
            return this.self();
        }

        public Builder setApplicationIdentifier(String appliationIdentifier) {
            this.mApplicationIdentifier = appliationIdentifier;
            return this.self();
        }

        public Builder setMamEnrollmentIdentifier(String mamEnrollmentIdentifier) {
            this.mMamEnrollmentIdentifier = mamEnrollmentIdentifier;
            return this.self();
        }

        public Builder setDisplayableId(String displayableId) {
            this.mDisplayableId = displayableId;
            return this.self();
        }

        public Builder setTokenScope(String tokenScope) {
            this.mTokenScope = tokenScope;
            return this.self();
        }

        public Builder setInstalledCompanyPortalVersion(String companyPortalVersion) {
            this.mCompanyPortalVersion = companyPortalVersion;
            return this.self();
        }

        public Builder setPrompt(String prompt) {
            this.mPrompt = prompt;
            return this.self();
        }

        public Builder setSlice(AzureActiveDirectorySlice slice) {
            this.mSlice = slice;
            return this.self();
        }

        public Builder setFlightParameters(Map<String, String> flightParameters) {
            this.mFlightParameters = flightParameters;
            return this.self();
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public MicrosoftStsAuthorizationRequest build() {
            return new MicrosoftStsAuthorizationRequest(this);
        }
    }

    public static final class Prompt {
        public static final String SELECT_ACCOUNT = "select_account";
        public static final String FORCE_LOGIN = "login";
        public static final String CONSENT = "consent";
    }
}

