/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import edu.umd.cs.findbugs.annotations.Nullable;

public class OAuth2StrategyParameters {
    @Nullable
    private final transient IPlatformComponents mPlatformComponents;
    @Nullable
    private final transient AbstractAuthenticationScheme mAuthenticationScheme;

    OAuth2StrategyParameters(@Nullable IPlatformComponents platformComponents, @Nullable AbstractAuthenticationScheme authenticationScheme) {
        this.mPlatformComponents = platformComponents;
        this.mAuthenticationScheme = authenticationScheme;
    }

    public static OAuth2StrategyParametersBuilder builder() {
        return new OAuth2StrategyParametersBuilder();
    }

    @Nullable
    public IPlatformComponents getPlatformComponents() {
        return this.mPlatformComponents;
    }

    @Nullable
    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.mAuthenticationScheme;
    }

    public static class OAuth2StrategyParametersBuilder {
        private IPlatformComponents platformComponents;
        private AbstractAuthenticationScheme authenticationScheme;

        OAuth2StrategyParametersBuilder() {
        }

        public OAuth2StrategyParametersBuilder platformComponents(@Nullable IPlatformComponents platformComponents) {
            this.platformComponents = platformComponents;
            return this;
        }

        public OAuth2StrategyParametersBuilder authenticationScheme(@Nullable AbstractAuthenticationScheme authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        public OAuth2StrategyParameters build() {
            return new OAuth2StrategyParameters(this.platformComponents, this.authenticationScheme);
        }

        public String toString() {
            return "OAuth2StrategyParameters.OAuth2StrategyParametersBuilder(platformComponents=" + this.platformComponents + ", authenticationScheme=" + this.authenticationScheme + ")";
        }
    }
}

