/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.google.gson.Gson;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.net.HttpClient;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdProviderConfiguration;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.NonNull;

public class OpenIdProviderConfigurationClient {
    private static final String TAG = OpenIdProviderConfigurationClient.class.getSimpleName();
    private static final String sWellKnownConfig = "/.well-known/openid-configuration";
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();
    private static final Map<URI, OpenIdProviderConfiguration> sConfigCache = new HashMap<URI, OpenIdProviderConfiguration>();
    private static final HttpClient httpClient = UrlConnectionHttpClient.getDefaultInstance();
    private final String mIssuer;
    private final Gson mGson = new Gson();

    public OpenIdProviderConfigurationClient(@NonNull String issuer) throws URISyntaxException {
        if (issuer == null) {
            throw new NullPointerException("issuer is marked non-null but is null");
        }
        this.mIssuer = new URI(this.sanitize(issuer)).toString();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public OpenIdProviderConfigurationClient(@NonNull String authority, @NonNull String path) throws URISyntaxException {
        this(authority, path, "");
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    public OpenIdProviderConfigurationClient(@NonNull String authority, @NonNull String path, @NonNull String endpointVersion) throws URISyntaxException {
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (endpointVersion == null) {
            throw new NullPointerException("endpointVersion is marked non-null but is null");
        }
        this.mIssuer = new CommonURIBuilder().setScheme("https").setHost(authority).setPathSegments(new String[]{path, endpointVersion}).build().toString();
    }

    private String sanitize(@NonNull String issuer) {
        if (issuer == null) {
            throw new NullPointerException("issuer is marked non-null but is null");
        }
        String sanitizedIssuer = issuer.trim();
        if (issuer.endsWith("/")) {
            sanitizedIssuer = issuer.substring(0, sanitizedIssuer.length() - 1);
        }
        return sanitizedIssuer;
    }

    public void loadOpenIdProviderConfiguration(final @NonNull OpenIdProviderConfigurationCallback callback) {
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        sBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onTaskCompleted(OpenIdProviderConfigurationClient.this.loadOpenIdProviderConfiguration());
                }
                catch (ServiceException e) {
                    callback.onError(e);
                }
            }
        });
    }

    public synchronized OpenIdProviderConfiguration loadOpenIdProviderConfiguration() throws ServiceException {
        String methodName = ":loadOpenIdProviderConfiguration";
        try {
            URI configUrl = new URI(this.mIssuer + sWellKnownConfig);
            OpenIdProviderConfiguration cacheResult = sConfigCache.get(configUrl);
            if (null != cacheResult) {
                Logger.info(TAG + ":loadOpenIdProviderConfiguration", "Using cached metadata result.");
                return cacheResult;
            }
            Logger.verbose(TAG + ":loadOpenIdProviderConfiguration", "Config URL is valid.");
            Logger.verbosePII(TAG + ":loadOpenIdProviderConfiguration", "Using request URL: " + configUrl);
            HttpResponse providerConfigResponse = httpClient.get(configUrl.toURL(), new HashMap<String, String>());
            int statusCode = providerConfigResponse.getStatusCode();
            if (200 != statusCode || StringUtil.isNullOrEmpty(providerConfigResponse.getBody())) {
                throw new ServiceException("failed_to_load_openid_configuration", "OpenId Provider Configuration metadata failed to load with status: " + statusCode, null);
            }
            OpenIdProviderConfiguration parsedConfig = this.parseMetadata(providerConfigResponse.getBody());
            this.cacheConfiguration(configUrl, parsedConfig);
            return parsedConfig;
        }
        catch (IOException | URISyntaxException e) {
            throw new ServiceException("failed_to_load_openid_configuration", "IOException while requesting metadata", e);
        }
    }

    private void cacheConfiguration(@NonNull URI configUrl, @NonNull OpenIdProviderConfiguration parsedConfig) {
        if (configUrl == null) {
            throw new NullPointerException("configUrl is marked non-null but is null");
        }
        if (parsedConfig == null) {
            throw new NullPointerException("parsedConfig is marked non-null but is null");
        }
        sConfigCache.put(configUrl, parsedConfig);
    }

    private OpenIdProviderConfiguration parseMetadata(@NonNull String body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return (OpenIdProviderConfiguration)this.mGson.fromJson(body, OpenIdProviderConfiguration.class);
    }

    public static interface OpenIdProviderConfigurationCallback
    extends TaskCompletedCallbackWithError<OpenIdProviderConfiguration, Exception> {
    }
}

