/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.relay;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.telemetry.observers.ITelemetryObserver;
import com.microsoft.identity.common.java.telemetry.relay.ITelemetryEventFilter;
import com.microsoft.identity.common.java.telemetry.relay.TelemetryRelayException;
import lombok.NonNull;

public abstract class AbstractTelemetryRelayClient<T>
implements ITelemetryObserver<T> {
    private static final String TAG = AbstractTelemetryRelayClient.class.getSimpleName();
    private ITelemetryEventFilter<T> mEventFilter = null;

    @Override
    public void onReceived(T telemetryData) {
        String methodTag = TAG + ":onReceived";
        T filteredData = telemetryData;
        if (this.mEventFilter != null) {
            filteredData = this.mEventFilter.apply(telemetryData);
        }
        if (filteredData != null) {
            try {
                this.relayEvent(filteredData);
            }
            catch (TelemetryRelayException e) {
                Logger.error(methodTag, "Error relaying telemetry data", e);
            }
        }
    }

    public void setFilter(ITelemetryEventFilter<T> filter) {
        this.mEventFilter = filter;
    }

    public abstract void relayEvent(@NonNull T var1) throws TelemetryRelayException;

    public abstract void flush();
}

