/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.NonNull;

public class FileUtil {
    private static final String TAG = FileUtil.class.getSimpleName();

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDataToFile(@NonNull byte[] data, @NonNull File file) throws ClientException {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String methodName = ":writeKeyData";
        Logger.verbose(TAG + ":writeKeyData", "Writing data to a file");
        try (FileOutputStream out = new FileOutputStream(file);){
            ((OutputStream)out).write(data);
        }
        catch (IOException e) {
            ClientException clientException = new ClientException("io_error", e.getMessage(), e);
            Logger.error(TAG + ":writeKeyData", clientException.getErrorCode(), e);
            throw clientException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static byte[] readFromFile(@NonNull File file, int dataSize) throws ClientException {
        byte[] byArray;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String methodName = ":readKeyData";
        if (!file.exists()) {
            return null;
        }
        Logger.verbose(TAG + ":readKeyData", "Reading data from a file");
        FileInputStream in = new FileInputStream(file);
        try {
            int count;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[dataSize];
            while ((count = ((InputStream)in).read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            byArray = bytes.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                ClientException clientException = new ClientException("io_error", e.getMessage(), e);
                Logger.error(TAG + ":readKeyData", clientException.getErrorCode(), e);
                throw clientException;
            }
        }
        ((InputStream)in).close();
        return byArray;
    }

    public static void deleteFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String methodName = ":deleteKeyFile";
        if (file.exists()) {
            Logger.verbose(TAG + ":deleteKeyFile", "Delete File");
            if (!file.delete()) {
                Logger.verbose(TAG + ":deleteKeyFile", "Failed to delete file.");
            }
        }
    }
}

